<?php
namespace Emlm\Traits\Fields;
/**
 *
 * @package    FoodBook
 * @since      3.0.0
 * @version    3.0.0
 * @author     ThemeLooks
 * @Websites:  http://themelooks.com/
 *
 */

trait Image {

    protected static $args;

    public function image( $name, $args ) {
        $default = [
            'label'       => '',
            'description' => '',
            'type'        => '',
            'label_block' => false,
        ];

        self::$args = wp_parse_args( $args, $default );
        self::$args['name'] = $name;

        self::image_markup();
    }

    protected static function image_markup() {

        $optionName = self::$optionName;
        $getData = self::$getOptionData;
        $args = self::$args;
        $fieldName = $args['name'];
        $image_id = !empty( $getData[$fieldName] ) ? $getData[$fieldName] : '';
        $label_block = ( $args['label_block'] == false ) ? 'emlm-label-block' : '';
        $conditionData = '';
        if ( !empty( $args['condition'] ) ) {
            $conditionData = wp_json_encode( $args['condition'] );
        }

        ?>
        <div class="emlm-form-field <?php echo esc_attr( $label_block ); ?>">
            <div class="emlm-label">
                <h4><?php echo esc_html( $args['label'] ) ?></h4>
                <p><?php echo esc_html( $args['description'] ) ?></p>
            </div>
            <div class="field-group">
                <div class="emlm-image-preview-wrapper">
                    <?php
                     if ( !empty( $image_id ) ) {
                        echo wp_get_attachment_image( $image_id, 'thumbnail' );
                        }
                    ?>
                </div>
                <input type="hidden" name="<?php echo esc_attr( $optionName ) . '[' . esc_attr( $fieldName ) . ']'; ?>" class="emlm_image_attachment_id" value="<?php echo esc_attr( $image_id ); ?>">
                <input type="button" class="button emlm_upload_image" value="<?php echo esc_html__( 'Upload Image', 'emlm-license-key-manager' ) ?>">
                <input type="button" class="button emlm_remove_image" value="<?php echo esc_html__( 'Remove Image', 'emlm-license-key-manager' ) ?>">
            </div>
        </div>
		<?php
    }
}
