<?php
namespace Emlm\Traits\Fields;

trait Heading {
    protected static $args;
    /**
     * Method Description.
     *
     * @param string $name Name of the text field.
     * @param array $args Arguments for the text field.
     */
    public function heading( $args ) {
        $default = [
            'label'       => '',
            'description' => '',
            'type'        => '',
        ];

        self::$args = wp_parse_args( $args, $default );

        self::heading_markup();
    }

    protected static function heading_markup() {
        $args = self::$args;
        ?>
        <div class="emlm-form-field">
            <h2><?php echo esc_html( $args['label'] ) ?></h2>
        </div>
        <?php
}
}
