<?php
namespace Emlm\Traits\Fields;

trait Gallery {

    protected static $args;

    public function gallery( $name, $args ) {
        $default = [
            'label'       => '',
            'description' => '',
            'type'        => '',
            'label_block' => false,
        ];

        self::$args = wp_parse_args( $args, $default );
        self::$args['name'] = $name;

        self::gallery_markup();
    }

    protected static function gallery_markup() {

        $optionName = self::$optionName;
        $getData = self::$getOptionData;
        $args = self::$args;
        $fieldName = $args['name'];
        $image_ids = !empty( $getData[$fieldName] ) ? $getData[$fieldName] : '';
        $image_ids_array = array();
        if ( !empty( $image_ids ) ) {
            $image_ids_array = explode( ',', $image_ids );
            $image_ids_array = array_map( 'intval', $image_ids_array );
        }
        $conditionData = '';
        if ( !empty( $args['condition'] ) ) {
            $conditionData = wp_json_encode( $args['condition'] );
        }

        ?>
        <div class="emlm-form-field" data-condition="<?php echo esc_attr( $conditionData ); ?>">
            <div class="emlm-label">
                <h4><?php echo esc_html( $args['label'] ) ?></h4>
                <p><?php echo esc_html( $args['description'] ) ?></p>
            </div>
            <div class="emlm-gallery-preview-wrapper">
                <?php
                if ( !empty( $image_ids_array && is_array( $image_ids_array ) ) ) {
                    foreach ( $image_ids_array as $image_id ) {
                        ?>
                        <div class="gallery-image" data-image-id="<?php echo esc_attr( $image_id ); ?>">
                            <?php echo wp_get_attachment_image( $image_id, 'thumbnail' ); ?>
                            <button class="remove-image"><?php echo esc_html__( 'remove', 'emlm-license-key-manager' ); ?></button>
                        </div>
                        <?php
                    }
                }
                 ?>
            </div>
            <input type="hidden" name="<?php echo esc_attr( $optionName ) . '[' . esc_attr( $fieldName ) . ']'; ?>" class="emlm-gallery-attachment-ids" value="<?php echo esc_attr( $image_ids ); ?>">
            <input type="button" class="emlm-upload-gallery-button button" value="Upload Image">
            <input type="button" class="emlm-remove-gallery-button button" value="Remove All Images">
        </div>
        <?php
    }
}
