<?php
namespace Emlm\Traits\Fields;
/**
 *
 * @package    FoodBook
 * @since      3.0.0
 * @version    3.0.0
 * @author     ThemeLooks
 * @Websites:  http://themelooks.com/
 *
 */

trait Checkbox {

    protected static $args;

    public function checkbox( $name, $args ) {
        $default = [
            'label'       => '',
            'description' => '',
            'type'        => '',
            'default'     => '',
            'label_block' => false,
        ];

        self::$args = wp_parse_args( $args, $default );
        self::$args['name'] = $name;

        self::checkbox_markup();
    }

    protected static function checkbox_markup() {

        $optionName = self::$optionName;
        $args = self::$args;
        $getData = self::$getOptionData;
        $fieldName = $args['name'];
        $value = !empty( $getData[$fieldName] ) ? $getData[$fieldName] : $args['default'];
        $label_block = ( $args['label_block'] == false ) ? 'emlm-label-block' : '';

        $conditionData = '';
        if ( !empty( $args['condition'] ) ) {
            $conditionData = wp_json_encode( $args['condition'] );
        }
        ?>
		<div class="emlm-form-field <?php echo esc_attr( $label_block ); ?>" data-condition="<?php echo esc_attr( $conditionData ); ?>">
			<div class="emlm-label">
                <h4><?php echo esc_html( $args['label'] ) ?></h4>
                <p><?php echo esc_html( $args['description'] ) ?></p>
            </div>
			<div class="field-group">
                <input type="hidden" name="<?php echo esc_attr( $optionName ) . '[' . esc_attr( $fieldName ) . ']'; ?>" value="" />
                <input type="checkbox" name="<?php echo esc_attr( $optionName ) . '[' . esc_attr( $fieldName ) . ']'; ?>" value="yes" <?php checked( esc_attr( $value ), 'yes' );?>  />
			</div>
		</div>
		<?php
}
}
