<?php
namespace Emlm\Traits;
use Emlm\Traits\Fields;

if ( !defined( 'ABSPATH' ) ) {
    exit;
}

trait ControlerManager {
    use Fields\Heading;
    use Fields\Text;
    use Fields\TextArea;
    use Fields\Number;
    use Fields\Select;
    use Fields\Checkbox;
    use Fields\MultiCheck;
    use Fields\MultiSelect;
    use Fields\Image;
    use Fields\Gallery;
    use Fields\Button;

    private $unique_names = array();

    public function add_control( $name, $args ) {
        // Check if the name is unique
        if ( !$this->is_name_unique( $name ) ) {
            return;
        }

        $this->unique_names[] = $name;

        switch ( $args['type'] ?? null ) {
        case 'text':
            $this->text( $name, $args );
            break;
        case 'number':
            $this->number( $name, $args );
            break;
        case 'textarea':
            $this->textarea( $name, $args );
            break;
        case 'select':
            $this->select( $name, $args );
            break;
        case 'checkbox':
            $this->checkbox( $name, $args );
            break;
        case 'radio':
            $this->textarea( $name, $args );
            break;
        case 'multiselect':
            $this->multi_select( $name, $args );
            break;
        case 'multicheck':
            $this->multi_check( $name, $args );
            break;
        case 'image':
            $this->image( $name, $args );
            break;
        case 'gallery':
            $this->gallery( $name, $args );
            break;
        case 'heading':
            $this->heading( $args );
            break;
        case 'button':
            $this->button( $args );
            break;
        default:
            break;
        }
    }

    private function is_name_unique( $name ) {
        return !in_array( $name, $this->unique_names );
    }

}
