<?php
namespace Emlm\Installer;

use Emlm\Databases\Migration\PluginMigration;
use Emlm\Databases\Seeder\PluginSeeder;
use Emlm\Helpers\APIKeyGenerator;

/**
 * Installer
 *
 * @package License Key Manager
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Installer {
    /**
	 * Run the installer.
	 *
	 * @since 1.0
	 *
	 * @return void
	 */
	public function activation(): void {
		// Run the database seeders.
		new APIKeyGenerator();
		$this->update_default_settings();
	}
    /**
	 * Create necessary database tables.
	 *
	 * @since 1.0
	 *
	 * @return void
	 */
    public function update_default_settings() {
        //insert default value into database
		$settings = array(
			// General settings
			array(
				'id'      => 'allow_characters',
				'type'    => 'text',
				'default' => 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789',
			),
			array(
				'id'      => 'character_type',
				'type'    => 'option',
				'default' => 'alphanumeric',
			),
			array(
				'id'      => 'license_length',
				'type'    => 'number',
				'default' => 16,
			),
			array(
				'id'      => 'license_prefix',
				'type'    => 'text',
				'default' => '',
			),
			array(
				'id'      => 'license_suffix',
				'type'    => 'text',
				'default' => '',
			),
			array(
				'id'      => 'license_delimiters',
				'type'    => 'text',
				'default' => '-',
			),
			array(
				'id'      => 'license_key_section',
				'type'    => 'number',
				'default' => 4,
			),
			array(
				'id'      => 'license_expiration',
				'type'    => 'number',
				'default' => 365,
			),
			array(
				'id'      => 'consumer_key',
				'type'    => 'text',
				'default' => APIKeyGenerator::get_consumer_key(),
			),
			array(
				'id'      => 'consumer_secret',
				'type'    => 'text',
				'default' => APIKeyGenerator::get_consumer_secret(),
			),
			array(
				'id'      => 'email_subject_expired_license',
				'type'    => 'text',
				'default' => 'Your license has expired.',
			),
			array(
				'id'      => 'email_body_submitted_recived',
				'type'    => 'text',
				'default' => '[License "{product_title}" has expired. Please renew this product license by clicking {product_link}]',
			),

		);

		if ( !empty( $settings ) ) {

			$settings_array = [];
			foreach ( $settings as $item ) {

				$key = $item['id'];
				$value = !empty( $item['default'] ) ? $item['default'] : "";
				// Update option with prefix
				$settings_array[$key] = stripslashes( $value );

			}
			update_option( 'emlm_options', $settings_array );
		}
    }


}