<?php
namespace Emlm;

use Emlm\AdminNotices\WooCommerceCheck;
use Emlm\Base\Enqueue;
use Emlm\Controllers\License\LicenseColumns;
use Emlm\Controllers\License\LicenseController;
use Emlm\Controllers\License\LicenseMetabox;
use Emlm\Controllers\License\LicenseType;
use Emlm\Controllers\Menu\Menu;
use Emlm\Emails\LicenseExpiredEmail;
use Emlm\ExportImport\ExportImport;
use Emlm\Helpers\Helper;
use Emlm\Helpers\LicenseStatusUpdate;
use Emlm\RestAPIs\AllLicense;
use Emlm\RestAPIs\LicenseStats;
use Emlm\RestAPIs\LicenseVerify;
use Emlm\RestAPIs\SingleLicense;
use Emlm\Woocommerce\LicenseKeyInputSystem;

/**
 * Class Description.
 *
 * @package License Key Manager
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Init {

    function __construct() {

        if ( is_admin() ) {
            new LicenseController();
            new Enqueue();
            new LicenseMetabox();
            new LicenseType();
            new LicenseColumns();
            new Menu();
            new LicenseStatusUpdate();
            new Helper();
            new LicenseExpiredEmail();
            new WooCommerceCheck();
            new ExportImport();
            if ( class_exists( 'WooCommerce' ) ) {
                new LicenseKeyInputSystem();
            }
        }

        new LicenseStats();
        new LicenseVerify();
        new AllLicense();
        new SingleLicense();

    }

}