<?php
namespace Emlm\Helpers;
/**
 * Class Options
 *
 * @package License Key Manager
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Options {

    public static function get_license_status() {
        $options = [
            "active"    => esc_html__( "Active", "emlm-license-key-manager" ),
            "inactive"  => esc_html__( "Inactive", "emlm-license-key-manager" ),
            "sold"      => esc_html__( "Sold", "emlm-license-key-manager" ),
            "deactived" => esc_html__( "Deactived", "emlm-license-key-manager" ),
            "expired"   => esc_html__( "Expired", "emlm-license-key-manager" ),
            "cancelled" => esc_html__( "Cancelled", "emlm-license-key-manager" ),

        ];

        return apply_filters( 'emlm_license_status', $options );
    }

    public static function get_license_type() {
        $options = [
            "limitation" => esc_html__( "Limitation", "emlm-license-key-manager" ),
            "unlimited"  => esc_html__( "Unlimited", "emlm-license-key-manager" ),
        ];

        return apply_filters( 'emlm_license_type', $options );
    }

    public static function get_product_type() {
        $args = array(
            'taxonomy'   => 'emlm_product_types', // Specify the taxonomy
            'orderby'    => 'term_id',
            'order'      => 'ASC',
            'hide_empty' => false, // Show all terms, even those without posts
        );

        // Use WP_Term_Query to fetch the terms
        $term_query = new \WP_Term_Query( $args );
        $terms = !empty( $term_query->terms ) ? $term_query->terms : [];

        return $terms;
    }

    public static function get_options() {
        return get_option( 'emlm_options' );
    }

}