<?php
namespace Emlm\Helpers;
/**
 * Class API Key Generator
 *
 * @package License Key Manager
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class APIKeyGenerator {

    private static $consumer_key_option = 'emlm_consumer_key';
    private static $consumer_secret_option = 'emlm_consumer_secret';

    /**
     * Constructor - Generates and stores API keys if they do not already exist
     */
    public function __construct() {
        // Check if the keys already exist
        if ( !$this->get_consumer_key() && !$this->get_consumer_secret() ) {
            $api_keys = $this->generate_api_keys();
            $this->store_api_keys( $api_keys );
        }
    }

    /**
     * Generate a random consumer key and secret
     *
     * @return array An array with 'consumer_key' and 'consumer_secret'
     */
    public function generate_api_keys() {
        // Generate new keys
        $consumer_key = 'ck_' . bin2hex( random_bytes( 16 ) ); // ck_ is the prefix for consumer keys
        $consumer_secret = 'cs_' . bin2hex( random_bytes( 16 ) ); // cs_ is the prefix for consumer secret

        return array(
            'consumer_key'    => $consumer_key,
            'consumer_secret' => $consumer_secret,
        );
    }

    /**
     * Store API keys in options
     *
     * @param array $api_keys Array with 'consumer_key' and 'consumer_secret'
     */
    public function store_api_keys( $api_keys ) {
        add_option( self::$consumer_key_option, $api_keys['consumer_key'] );
        add_option( self::$consumer_secret_option, $api_keys['consumer_secret'] );
    }

    /**
     * Retrieve the Consumer Key.
     *
     * @return string|null Consumer Key or null if not set.
     */
    public static function get_consumer_key() {
        return get_option( self::$consumer_key_option );
    }

    /**
     * Retrieve the Consumer Secret.
     *
     * @return string|null Consumer Secret or null if not set.
     */
    public static function get_consumer_secret() {
        return get_option( self::$consumer_secret_option );
    }
}
