<?php
namespace Emlm\Emails;

use Emlm\Helpers\Options;

/**
 * Handles License Expired Email Notification
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Class LicenseExpiredEmail
 */
class LicenseExpiredEmail {

    /**
     * Send an email when the license expires
     * 
     * @param int $license_id License post ID
     */
    public static function handle_email_template( $license_id ) {
        // Retrieve the product/license details
        $product_id    = get_post_meta( $license_id, '_emlm_product', true );
        $product_title = get_the_title( $product_id );
        $owner_email   = get_post_meta( $license_id, '_emlm_owner_email', true );
        $owner_name    = get_post_meta( $license_id, '_emlm_owner_name', true );
        $admin_email   = get_option( 'admin_email' );  // Get the admin email
        $site_title    = get_bloginfo( 'name' );       // Site title
        $product_link  = get_edit_post_link( $license_id ); // Link to the license post

        // Define placeholders for the email body and subject
        $placeholders = array(
            '{site_title}',
            '{license_id}',
            '{product_title}',
            '{owner_email}',
            '{owner_name}',
            '{product_link}',
        );

        // Define corresponding values
        $values = array(
            $site_title,
            $license_id,
            $product_title,
            $owner_email,
            $owner_name,
            $product_link,
        );

        // Get the email subject and body from the plugin's options
        $options            = Options::get_options(); // Assuming Options::get_options() retrieves the email content settings
        $subject_template   = $options['email_subject_expired_license']; // Email subject template
        $body_template      = $options['email_body_expired_license'];    // Email body template

        // Replace placeholders with actual values in the subject and body
        $subject = str_replace( $placeholders, $values, $subject_template );
        $body_message = str_replace( $placeholders, $values, $body_template );

        // Set up the email headers
        $headers = array(
            "From: " . $site_title . " <" . $admin_email . ">",
            "Reply-To: " . $admin_email,
            "Content-Type: text/html"
        );

        // Send email to the license owner
        wp_mail( $owner_email, $subject, $body_message, $headers );
    }
}
