<?php
namespace Emlm\Controllers\Menu\Pages\TabsContent;
use Emlm\Abstracts\FieldsBase;
use Emlm\Helpers\APIKeyGenerator;
use Emlm\Traits\ControlerManager;

/**
 * Plugin Settings
 *
 * @package License Key Manager
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Settings extends FieldsBase {
    use ControlerManager;

    public function get_option_name() {
        return 'emlm_options'; 
    }

    function get_settings_panel() {

        //general settings
        $this->start_fields_section( [
            'title'   => esc_html__( 'General', 'emlm-license-key-manager' ),
            'icon'    => 'fa fa-home',
            'class'   => 'active',
            'id'      => 'tab-general',
            'display' => 'block',

        ] );

        $this->add_control(
            'allow_characters', [
                'label'       => esc_html__( 'Allowed characters', 'emlm-license-key-manager' ),
                'description' => '',
                'type'        => 'text',
                'default'     => 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789',
                'label_block' => false,
            ]
        );

        $this->add_control(
            'character_type', [
                'label'       => esc_html__( 'Character Type', 'emlm-license-key-manager' ),
                'description' => '',
                'type'        => 'select',
                'default'     => 'alphanumeric_a_z_0_9',
                'label_block' => false,
                'options'     => [
                    'alphanumeric' => 'Alphanumeric (A-Z, 0-9)',
                    'numberic'     => 'Numeric only (0-9)',
                    'alphabetic'   => 'Alphabetic only (A-Z)',
                ],
            ]
        );

        $this->add_control(
            'license_length', [
                'label'       => esc_html__( 'License Length', 'emlm-license-key-manager' ),
                'description' => '',
                'type'        => 'number',
                'default'     => 16,
                'label_block' => false,
            ]
        );

        $this->add_control(
            'license_prefix', [
                'label'       => esc_html__( 'Prefix', 'emlm-license-key-manager' ),
                'description' => '',
                'type'        => 'text',
                'default'     => '',
                'label_block' => false,
            ]
        );

        $this->add_control(
            'license_suffix', [
                'label'       => esc_html__( 'Suffix', 'emlm-license-key-manager' ),
                'description' => '',
                'type'        => 'text',
                'default'     => '',
                'label_block' => false,
            ]
        );

        $this->add_control(
            'license_delimiters', [
                'label'       => esc_html__( 'Custom Delimiters', 'emlm-license-key-manager' ),
                'description' => 'Add custom delimiters (e.g., dashes, underscores) between key sections.',
                'type'        => 'text',
                'default'     => '-',
                'label_block' => false,
            ]
        );

        $this->add_control(
            'license_key_section', [
                'label'       => esc_html__( 'Key Sections', 'emlm-license-key-manager' ),
                'description' => 'Enable splitting the license into multiple sections, such as XXXX-XXXX-XXXX.',
                'type'        => 'number',
                'default'     => 4,
                'label_block' => false,
            ]
        );

        $this->add_control(
            'license_expiration', [
                'label'       => esc_html__( 'License Expiration (Days)', 'emlm-license-key-manager' ),
                'description' => '',
                'type'        => 'number',
                'default'     => 365,
                'label_block' => false,
            ]
        );

        $this->end_fields_section();

        //rest api settings
        $this->start_fields_section( [
            'title'   => esc_html__( 'Rest API', 'emlm-license-key-manager' ),
            'icon'    => 'fa fa-home',
            'class'   => '',
            'id'      => 'rest-api',
            'display' => 'none',

        ] );

        $this->add_control(
            'consumer_key', [
                'label'       => esc_html__( 'Consumer Key', 'emlm-license-key-manager' ),
                'description' => '',
                'type'        => 'text',
                'default'     => APIKeyGenerator::get_consumer_key(),
                'label_block' => false,
            ]
        );

        $this->add_control(
            'consumer_secret', [
                'label'       => esc_html__( 'Consumer Secret', 'emlm-license-key-manager' ),
                'description' => '',
                'type'        => 'text',
                'default'     => APIKeyGenerator::get_consumer_secret(),
                'label_block' => false,
            ]
        );

        $this->end_fields_section();

        //email settings
        $this->start_fields_section( [
            'title'   => esc_html__( 'Email', 'emlm-license-key-manager' ),
            'icon'    => 'fa fa-home',
            'class'   => '',
            'id'      => 'email',
            'display' => 'none',

        ] );

        $this->add_control(
            'expired_license_heading', [
                'label' => esc_html__( 'License Expired Email', 'emlm-license-key-manager' ),
                'type'  => 'heading',
            ]
        );

        $this->add_control(
            'email_subject_expired_license', [
                'label'       => esc_html__( 'Subject', 'emlm-license-key-manager' ),
                'description' => esc_html__( 'Edit the subject for sending to the admin when a license is expired.', 'emlm-license-key-manager' ),
                'type'        => 'text',
                'default'     => 'Your license has expired.', // Corrected default text
                'label_block' => false,
            ]
        );

        $this->add_control(
            'email_body_submitted_recived', [
                'label'       => esc_html__( 'Email Body', 'emlm-license-key-manager' ),
                'description' => esc_html__( 'Edit the email template for sending to the admin when a product license is expired.', 'emlm-license-key-manager' ),
                'type'        => 'textarea',
                'default'     => '[License "{product_title}" has expired. Please renew this product license by clicking {product_link}]', // Corrected default text and message
                'label_block' => false,
            ]
        );

        $this->end_fields_section();

    }

}