<?php
namespace Emlm\Controllers\Menu\Pages;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class PageTemplate {

    public function admin_page_init() {
        $this->admin_page_mapping();
    }

    public function admin_page_mapping() {
        
        ?>
        <div class="emlm-options-wrapper wrap">
            <h1><?php esc_html_e( 'Settings', 'emlm-license-key-manager' ); ?></h1>
            <?php
            add_settings_error( 'emlm_messages', 'emlm_message', esc_html__( 'Settings Saved', 'emlm-license-key-manager' ), 'updated' ); 
            ?>
          <?php $this->tabs(); ?>
          <form method="post" action="options.php">
            <?php  
                settings_fields( 'emlm_settings_option_group' ); 
                do_settings_sections( 'emlm_settings_option_group' ); 
                settings_errors( 'emlm_messages' );
               
            ?>
            <?php $this->tab_content()?>
            <?php wp_nonce_field( 'emlm_options_nonce', 'emlm_options_nonce' ); ?>
            <?php submit_button( 'Save Settings' ); ?>
          </form>  
        </div>
        <?php
    }

    public function tabs() {
        ?>
        <h2 class="nav-tab-wrapper">
            <a href="#tab-general" class="nav-tab nav-tab-active"><?php esc_html_e( 'General', 'emlm-license-key-manager' ); ?></a>
            <a href="#rest-api" class="nav-tab"><?php esc_html_e( 'Rest API', 'emlm-license-key-manager' ); ?></a>
            <a href="#email" class="nav-tab"><?php esc_html_e( 'Email', 'emlm-license-key-manager' ); ?></a>
        </h2>
        <?php
    }

    public function tab_content() {
       //settings content
       $settings = new TabsContent\Settings();
       $settings->get_settings_panel();

    }
}

