<?php
namespace Emlm\Controllers\Menu;

use Emlm\Controllers\License\LicenseExportImport;
use Emlm\Controllers\License\LicenseOverview;

/**
 * Menu
 *
 * @package License Key Manager
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Menu {
    private $model;
    /**
     * Constructor.
     */
    public function __construct() {
        add_action( 'admin_menu', array( $this, 'add_menu_page' ) );
        add_action( 'admin_init', array( $this, 'page_settings_init' ) );
    }

    public function add_menu_page() {

        // Submenu: Overview
        add_submenu_page(
            'edit.php?post_type=emlm_listing', // Parent slug
            'Overviews', // Page title
            'Overviews', // Menu title
            'manage_options', // Capability
            'emlm_overviews', // Menu slug (same as parent to open Overview by default)
            array( $this, 'render_overview_page' ), // Callback function for Overview page
            0// Menu position
        );

        // Submenu: Settings
        add_submenu_page(
            'edit.php?post_type=emlm_listing', // Parent slug
            'Settings', // Page title
            'Settings', // Menu title
            'manage_options', // Capability
            'emlm-settings', // Menu slug
            array( $this, 'render_settings_page' ), // Callback function for settings page
            6// Menu position
        );

        // Export/Import
        add_submenu_page(
            'edit.php?post_type=emlm_listing',
            'Export/Import',
            'Export/Import',
            'manage_options',
            'export-import',
            array( $this, 'render_export_import_page' ),
            7
        );

    }

    public function render_overview_page() {
        $overview = new LicenseOverview();
        $overview->render_overview_page();
    }

    public function render_export_import_page() {

        $expoer_import = new LicenseExportImport();
        $expoer_import->rander_export_import_page();

    }

    public function render_settings_page() {

        $settings = new Pages\PageTemplate();
        $settings->admin_page_init();
    }

    public static function page_settings_init() {
        register_setting(
            'emlm_settings_option_group',
            'emlm_options',
            array(
            'sanitize_callback' => array( __CLASS__, 'sanitize_options' )
            )
        );
    }

    public static function sanitize_options( $input ) {
    $sanitized = array();

    foreach ( $input as $key => $value ) {

        switch ( $key ) {

            // ✅ Email field
            case 'email':
                $sanitized[$key] = sanitize_email( $value );
                break;

            // ✅ URL field
            case 'url':
            case 'website':
                $sanitized[$key] = esc_url_raw( $value );
                break;

            // ✅ Integer / number field
            case 'count':
            case 'number':
                $sanitized[$key] = absint( $value );
                break;

            // ✅ Checkbox field (1 or 0)
            case 'enable_feature':
            case 'is_active':
                $sanitized[$key] = ! empty( $value ) ? 1 : 0;
                break;

            // ✅ Textarea (multi-line text)
            case 'description':
            case 'custom_css':
                $sanitized[$key] = sanitize_textarea_field( $value );
                break;

            // ✅ Select / dropdown with whitelisted values
            case 'color_scheme':
                $allowed = array( 'light', 'dark', 'auto' );
                $sanitized[$key] = in_array( $value, $allowed, true ) ? $value : 'light';
                break;

            // ✅ Radio button (example with fixed choices)
            case 'mode':
                $allowed_modes = array( 'simple', 'advanced' );
                $sanitized[$key] = in_array( $value, $allowed_modes, true ) ? $value : 'simple';
                break;

            // ✅ Default = plain text field
            default:
                if ( is_array( $value ) ) {
                    // recursively sanitize arrays (useful if option stores multiple values)
                    $sanitized[$key] = array_map( 'sanitize_text_field', $value );
                } else {
                    $sanitized[$key] = sanitize_text_field( $value );
                }
                break;
        }
    }

    return $sanitized;
}


}
