<?php
namespace Emlm\Controllers\License;
/**
 * Listing Type.
 *
 * @package License Key Manager
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class LicenseType {
    /**
     * Constructor.
     */
    public function __construct() {
        // Constructor body
        add_action( 'init', array( $this, 'register_license_type_taxonomy' ) );
    }

    private function post_type() {
        return 'emlm_listing';
    }

    private function plural_name() {
        return 'Product Types';
    }

    private function singular_name() {
        return 'Product Type';
    }

    function register_license_type_taxonomy() {
        $labels = array(
            'name'                       => _x( 'Product Types', 'taxonomy general name', 'emlm-license-key-manager' ),
            'singular_name'              => _x( 'Product Type', 'taxonomy Type', 'emlm-license-key-manager' ),
            'search_items'               => __( 'Search Types', 'emlm-license-key-manager' ),
            'all_items'                  => __( 'All Product Types', 'emlm-license-key-manager' ),
            'parent_item'                => __( 'Parent Type', 'emlm-license-key-manager' ),
            'parent_item_colon'          => __( 'Parent Type :', 'emlm-license-key-manager' ),
            'edit_item'                  => __( 'Edit Type', 'emlm-license-key-manager' ),
            'update_item'                => __( 'Update Type', 'emlm-license-key-manager' ),
            'add_new_item'               => __( 'Add New Type', 'emlm-license-key-manager' ),
            'new_item_name'              => __( 'New Type Name', 'emlm-license-key-manager' ),
            'menu_name'                  => __( 'Product Types', 'emlm-license-key-manager' ),
            'view_item'                  => __( 'View Type', 'emlm-license-key-manager' ),
            'popular_items'              => __( 'Popular Types', 'emlm-license-key-manager' ),
            'separate_items_with_commas' => __( 'Separate Types with commas', 'emlm-license-key-manager' ),
            'add_or_remove_items'        => __( 'Add or remove Types', 'emlm-license-key-manager' ),
            'choose_from_most_used'      => __( 'Choose from the most used', 'emlm-license-key-manager' ),
            'not_found'                  => __( 'No Types found.', 'emlm-license-key-manager' ),
            'no_terms'                   => __( 'No Types', 'emlm-license-key-manager' ),
            'items_list_navigation'      => __( 'Types list navigation', 'emlm-license-key-manager' ),
            'items_list'                 => __( 'Types list', 'emlm-license-key-manager' ),
        );
        $args = array(
            'labels'            => $labels,
            'hierarchical'      => true,
            'public'            => true,
            'show_ui'           => true,
            'show_admin_column' => false,
            'show_in_nav_menus' => true,
            'show_tagcloud'     => true,
        );
        register_taxonomy( 'emlm_product_types', $this->post_type(), $args );
    }

}