<?php
namespace Emlm\Controllers\License;

use Emlm\Helpers\Helper;

/**
 * License Overview page.
 *
 * @package License Key Manager
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class LicenseOverview {
    private $total_license;
    private $active_license;
    private $expired_license;
    /**
     * Constructor.
     */
    public function __construct() {
        // Constructor body
        $this->total_license = Helper::get_total_license();
        $this->active_license = Helper::get_active_license();
        $this->expired_license = Helper::get_expired_license();
    }

    public function render_overview_page() {
        ?>
        <div class="emlm-overview">
            <div class="emlm-title">
                <h1><?php echo esc_html__( 'Overview', 'emlm-license-key-manager' ); ?></h1>
            </div>
            <div class="emlm-overview-wrapper">
                <div class="emlm-total-license">
                    <h3><?php echo esc_html__( 'Total License', 'emlm-license-key-manager' ); ?></h3>
                    <div class="count">
                        <span><?php echo esc_html( $this->total_license ); ?></span>
                    </div>
                </div>
                <div class="emlm-active-license">
                    <h3><?php echo esc_html__( 'Active License', 'emlm-license-key-manager' ); ?></h3>
                    <div class="count">
                        <span><?php echo esc_html( $this->active_license ); ?></span>
                    </div>
                </div>
                <div class="emlm-expired-license">
                    <h3><?php echo esc_html__( 'Expired License', 'emlm-license-key-manager' ); ?></h3>
                    <div class="count">
                        <span><?php echo esc_html( $this->expired_license ); ?></span>
                    </div>
                </div>
            </div>
            <div class="emlm-chart">
                <div style="width: 1040px;"><canvas id="emlm-monthly-analytics"></canvas></div>
            </div>
        </div>
        <?php
    }

}