<?php
namespace Emlm\Controllers\License;

use Emlm\Helpers\GenerateKey;
use Emlm\Helpers\Options;
/**
 * Listing Metabox.
 *
 * @package License Key Manager
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class LicenseMetabox {
    private $post_type = 'emlm_listing';
    /**
     * Constructor.
     */
    public function __construct() {
        add_action( 'add_meta_boxes', [$this, 'add_custom_meta_box'] );
        add_action( 'save_post', [$this, 'save_custom_meta_box_data'] );
    }

    public function add_custom_meta_box() {
        add_meta_box(
            $this->post_type . '_meta_box',
            __('License Information', 'emlm-license-key-manager'),
            [$this, 'render_general_info_meta_box'],
            $this->post_type,
            'normal',
            'high'
        );
    }

    public function render_general_info_meta_box( $post ) {
        wp_nonce_field( 'emlm_meta_box_nonce', 'emlm_meta_box_nonce' );

        // Retrieve existing values from the database
        $emlm_product_types = Options::get_product_type();
        $emlm_license_types = Options::get_license_type();
        $emlm_all_statuses = Options::get_license_status();
        $emlm_generator = new \Emlm\Helpers\GenerateKey();
        $emlm_generated_key = $emlm_generator->generate_license_key();
        $emlm_license_key = get_post_meta( $post->ID, '_emlm_generate_key', true ) ? get_post_meta( $post->ID, '_emlm_generate_key', true ) : $emlm_generated_key;
        $emlm_owener_name = get_post_meta( $post->ID, '_emlm_owener_name', true ) ? get_post_meta( $post->ID, '_emlm_owener_name', true ) : '';
        $emlm_issue_date = get_post_meta( $post->ID, '_emlm_issue_date', true ) ? get_post_meta( $post->ID, '_emlm_issue_date', true ) : '';
        $emlm_validation_days = get_post_meta( $post->ID, '_emlm_validation_days', true ) ? get_post_meta( $post->ID, '_emlm_validation_days', true ) : '';
        $emlm_maximum_activations = get_post_meta( $post->ID, '_emlm_maximum_activations', true ) ? get_post_meta( $post->ID, '_emlm_maximum_activations', true ) : '';
        $emlm_license_status = get_post_meta( $post->ID, '_emlm_license_status', true ) ? get_post_meta( $post->ID, '_emlm_license_status', true ) : '';
        $emlm_license_type = get_post_meta( $post->ID, '_emlm_license_type', true ) ? get_post_meta( $post->ID, '_emlm_license_type', true ) : '';
        $emlm_product_type = get_post_meta( $post->ID, '_emlm_product_type', true ) ? get_post_meta( $post->ID, '_emlm_product_type', true ) : '';
        $emlm_product_id = get_post_meta( $post->ID, '_emlm_product_id', true ) ? get_post_meta( $post->ID, '_emlm_product_id', true ) : '';

        ?>

        <div class="emlm-metafields">
            <div class="form-field">
                <label for="emlm_generate_key"><?php echo esc_html__( 'Generate Key', 'emlm-license-key-manager' ); ?> <span>*</span></label>
                <input type="text" class="form-control" id="emlm_generate_key" name="_emlm_generate_key" value="<?php echo esc_attr( $emlm_license_key ); ?>" required/>
            </div>
            <div class="form-field">
                <label for="emlm_owener_name"><?php echo esc_html__( 'Owner Name', 'emlm-license-key-manager' ); ?> <span>*</span></label>
                <input type="text" class="form-control" id="emlm_owener_name" name="_emlm_owener_name" value="<?php echo esc_attr( $emlm_owener_name ); ?>" required/>
            </div>
            <div class="form-field">
                <label for="emlm_product_type"><?php echo esc_html__( 'Product Type', 'emlm-license-key-manager' ); ?> <span>*</span></label>
                <select name="_emlm_product_type" class="form-control" id="emlm_product_type" required>
                    <?php
                    if( !empty( $emlm_product_types ) ){
                        foreach( $emlm_product_types as $term) {
                            ?>
                            <option value="<?php echo esc_attr( $term->term_id ); ?>" <?php selected( $emlm_product_type, $term->term_id ); ?>><?php echo esc_html( $term->name ); ?></option>
                            <?php
                        }
                    }
                    ?>
                </select>
            </div>
            <div class="form-field">
                <label for="emlm_product_id"><?php echo esc_html__( 'Product ID', 'emlm-license-key-manager' ); ?> <span>*</span></label>
                <input type="text" class="form-control" id="emlm_product_id" name="_emlm_product_id" value="<?php echo esc_attr( $emlm_product_id ); ?>" required/>
            </div>
            <div class="form-field">
                <label for="emlm_license_type"><?php echo esc_html__( 'License Type', 'emlm-license-key-manager' ); ?> <span>*</span></label>
                <select name="_emlm_license_type" class="form-control" id="emlm_license_type" required>
                    <?php
                    if( !empty( $emlm_license_types ) ){
                        foreach( $emlm_license_types as $index => $term) {
                            ?>
                            <option value="<?php echo esc_attr( $index ); ?>" <?php selected( $emlm_license_type, $index ); ?>><?php echo esc_html( $term ); ?></option>
                            <?php
                        }
                    }
                    ?>
                </select>
            </div>
            <div class="form-field">
                <label for="emlm_issue_date"><?php echo esc_html__( 'Issue Date', 'emlm-license-key-manager' ); ?> <span>*</span></label>
                <input type="date" class="form-control" id="emlm_issue_date" name="_emlm_issue_date" value="<?php echo esc_attr( $emlm_issue_date ); ?>" required/>
            </div>
            <div class="form-field emlm-validation-days">
                <label for="emlm_validation_days"><?php echo esc_html__( 'Validation Days', 'emlm-license-key-manager' ); ?></label>
                <input type="number" class="form-control" id="emlm_validation_days" name="_emlm_validation_days" value="<?php echo esc_attr( $emlm_validation_days ); ?>" />
            </div>
            <div class="form-field emlm-maximun-activation">
                <label for="emlm_maximum_activations"><?php echo esc_html__( 'Maximum Activations', 'emlm-license-key-manager' ); ?></label>
                <input type="number" class="form-control" id="emlm_maximum_activations" name="_emlm_maximum_activations" value="<?php echo esc_attr( $emlm_maximum_activations ); ?>" size="25" />
            </div>
            <div class="form-field">
                <label for="emlm_license_status"><?php echo esc_html__( 'Status', 'emlm-license-key-manager' ); ?> <span>*</span></label>
                <select name="_emlm_license_status" class="form-control" id="emlm_license_status" required>
                    <?php
                    if( !empty( $emlm_all_statuses ) ) {
                        foreach( $emlm_all_statuses as $index => $item) {
                            ?>
                            <option value="<?php echo esc_attr( $index ); ?>" <?php selected( $emlm_license_status, $index ); ?>><?php echo esc_html( $item ); ?></option>
                            <?php
                        }
                    }
                    ?>
                 
                </select>
            </div> 

        </div>

        <?php
    }

    public function save_custom_meta_box_data( $post_id ) {
        // Check if nonce is set
        if ( !isset( $_POST['emlm_meta_box_nonce'] ) ) {
            return;
        }
        
        // Verify nonce
        if ( !wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['emlm_meta_box_nonce'] ) ), 'emlm_meta_box_nonce' ) ) {
            return;
        }
        
        // Check autosave
        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return;
        }
        
        // Check user permissions
        if ( !current_user_can( 'edit_post', $post_id ) ) {
            return;
        }
    
        // Check if it's a emlm_listing post type
        if (get_post_type($post_id) === 'emlm_listing') {
            $post_title = get_post_field('post_title', $post_id);
            if (empty($post_title)) {
                $new_title = 'License Key #' . $post_id;
                wp_update_post(array(
                    'ID' => $post_id,
                    'post_title' => $new_title, //update title
                    'post_name' => sanitize_title($new_title), // update slug too
                ));
            }
        }

        // Save custom field 
        if ( isset( $_POST['_emlm_generate_key'] ) ) {
            update_post_meta( $post_id, '_emlm_generate_key', sanitize_text_field( wp_unslash( $_POST['_emlm_generate_key'] ) ) );
        }

        if ( isset( $_POST['_emlm_owener_name'] ) ) {
            update_post_meta( $post_id, '_emlm_owener_name', sanitize_text_field( wp_unslash( $_POST['_emlm_owener_name'] ) ) );
        }

        if ( isset( $_POST['_emlm_issue_date'] ) ) {
            update_post_meta( $post_id, '_emlm_issue_date', sanitize_text_field( wp_unslash( $_POST['_emlm_issue_date'] ) ) );
        }

        if ( isset( $_POST['_emlm_validation_days'] ) ) {
            update_post_meta( $post_id, '_emlm_validation_days', sanitize_text_field( wp_unslash( $_POST['_emlm_validation_days'] ) ) );
        }

        if ( isset( $_POST['_emlm_maximum_activations'] ) ) {
            update_post_meta( $post_id, '_emlm_maximum_activations', sanitize_text_field( wp_unslash( $_POST['_emlm_maximum_activations'] ) ) );
        }

        if ( isset( $_POST['_emlm_license_status'] ) ) {
            update_post_meta( $post_id, '_emlm_license_status', sanitize_text_field( wp_unslash( $_POST['_emlm_license_status'] ) ) );
        }

        if ( isset( $_POST['_emlm_product_type'] ) ) {
            update_post_meta( $post_id, '_emlm_product_type', sanitize_text_field( wp_unslash( $_POST['_emlm_product_type'] ) ) );
        }

        if ( isset( $_POST['_emlm_product_id'] ) ) {
            update_post_meta( $post_id, '_emlm_product_id', absint( wp_unslash( $_POST['_emlm_product_id'] ) ) );
        }

        if ( isset( $_POST['_emlm_license_type'] ) ) {
            update_post_meta( $post_id, '_emlm_license_type', sanitize_text_field( wp_unslash( $_POST['_emlm_license_type'] ) ) );
        }

        $type_id = get_post_meta( $post_id, '_emlm_product_type', true) ? get_post_meta( $post_id, '_emlm_product_type', true) : 0;

        if (!empty($type_id) && term_exists((int) $type_id, 'emlm_product_types')) {
            wp_set_object_terms($post_id, (int) $type_id, 'emlm_product_types');
        }

    }
    
}