<?php
namespace Emlm\Controllers\License;
/**
 * License Export and Import
 *
 * @package YourPackage
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class LicenseExportImport {

    public function rander_export_import_page() {
        wp_nonce_field( 'emlm_import_nonce_action', 'emlm_import_nonce' );
        $export_url = admin_url( 'admin-post.php?action=emlm_export_licenses&emlm_export_nonce=' . wp_create_nonce( 'emlm_export_nonce_action' ) );
        ?>
        <div class="wrap">
            <h1><?php esc_html_e( 'License Data Export/Import', 'emlm-license-key-manager' );?></h1>

            <!-- Export Section -->
            <h2><?php esc_html_e( 'Export License Data', 'emlm-license-key-manager' );?></h2>
            <p><?php esc_html_e( 'Click the button below to export all license data to a CSV file.', 'emlm-license-key-manager' );?></p>
            <form action="<?php echo esc_url( $export_url ); ?>" method="post">
                <?php submit_button( __( 'Export License Data', 'emlm-license-key-manager' ) );?>
            </form>

            <hr>

            <!-- Import Section -->
            <h2><?php esc_html_e( 'Import License Data', 'emlm-license-key-manager' );?></h2>
            <p><?php esc_html_e( 'Upload a CSV file to import license data.', 'emlm-license-key-manager' );?></p>
            <form action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>" method="post" enctype="multipart/form-data">
                <input type="hidden" name="action" value="emlm_import_licenses">
                <input type="file" name="emlm_license_csv" accept=".csv" required>
                <?php submit_button( __( 'Import License Data', 'emlm-license-key-manager' ) );?>
            </form>
        </div>

        <?php
}
}