<?php
namespace Emlm\Controllers\License;
/**
 * License Controller.
 *
 * @package Licenese key Manager
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class LicenseController {
    /**
     * Constructor.
     */
    public function __construct() {
        add_action( 'init', array( $this, 'register_custom_post_type' ) );
    }

    private function post_type() {
        return 'emlm_listing';
    }

    private function plural_name() {
        return 'License Keys';
    }

    private function License_name() {
        return 'License Key';
    }

    function register_custom_post_type() {
        $labels = array(
            'name'               => _x( 'License Key', 'post type general name', 'emlm-license-key-manager' ),
            'License_name'       => _x( 'License Name', 'post type License name', 'emlm-license-key-manager' ),
            'menu_name'          => _x( 'License Keys', 'admin menu', 'emlm-license-key-manager' ),
            'name_admin_bar'     => _x( 'License', 'add new on admin bar', 'emlm-license-key-manager' ),
            'add_new'            => _x( 'Add New', 'post type', 'emlm-license-key-manager' ),
            'add_new_item'       => __( 'Add New License', 'emlm-license-key-manager' ),
            'new_item'           => __( 'New License', 'emlm-license-key-manager' ),
            'edit_item'          => __( 'Edit License', 'emlm-license-key-manager' ),
            'view_item'          => __( 'View License', 'emlm-license-key-manager' ),
            'all_items'          => __( 'All License', 'emlm-license-key-manager' ),
            'search_items'       => __( 'Search License', 'emlm-license-key-manager' ),
            'parent_item_colon'  => __( 'Parent License :', 'emlm-license-key-manager' ),
            'not_found'          => __( 'No License found.', 'emlm-license-key-manager' ),
            'not_found_in_trash' => __( 'No License found in Trash.', 'emlm-license-key-manager' ),
        );
        $capability = 'manage_options';
        $args = array(
            'labels'              => $labels,
            'description'         => __( 'Description.', 'emlm-license-key-manager' ),
            'public'              => true,
            'publicly_queryable'  => false,
            'show_ui'             => true,
            'show_in_menu'        => current_user_can( $capability ),
            'show_in_nav_menus'   => true,
            'delete_with_user'    => false,
            'exclude_from_search' => false,
            'map_meta_cap'        => true,
            'can_export'          => false,
            'query_var'           => true,
            'rewrite'             => array( 'slug' => 'emlm_listing' ),
            'capability_type'     => 'post',
            'has_archive'         => false,
            'hierarchical'        => false,
            'supports'            => array( 'title' ),
            'menu_icon'           => 'dashicons-admin-network',
        );
        register_post_type( $this->post_type(), $args );
    }

}