<?php
namespace Emlm\Controllers\License;

use Emlm\Helpers\Options;

/**
 *  custom colums
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
} // Exit if accessed directly

class LicenseColumns {

    public function __construct() {
        add_filter( 'manage_emlm_listing_posts_columns', array( $this, 'add_custom_columns_head_in_profile' ) );
        add_action( 'manage_emlm_listing_posts_custom_column', array( $this, 'add_custom_columns_in_profile' ), 10, 2 );
    }

    public function add_custom_columns_head_in_profile( $defaults ) {
        $date = $defaults['date']; // Save the date column
        unset( $defaults['date'] ); // Remove the date column
        unset( $defaults['title'] ); // Remove the date column
        $defaults['_emlm_generate_key'] = esc_html__( 'License Key', 'emlm-license-key-manager' );
        $defaults['_emlm_product_type'] = esc_html__( 'Product Type', 'emlm-license-key-manager' );
        $defaults['_emlm_license_type'] = esc_html__( 'License Type', 'emlm-license-key-manager' );
        $defaults['_emlm_owener_name'] = esc_html__( 'Owner Name', 'emlm-license-key-manager' );
        $defaults['_emlm_activation'] = esc_html__( 'Activation', 'emlm-license-key-manager' );
        $defaults['_emlm_license_status'] = esc_html__( 'Status', 'emlm-license-key-manager' );
        $defaults['date'] = $date;
        return $defaults;
    }

    public function add_custom_columns_in_profile( $column_name, $post_id ) {
        switch ( $column_name ) {
        case '_emlm_generate_key':
            echo esc_html( get_post_meta( $post_id, '_emlm_generate_key', true ) );
            break;

        case '_emlm_product_type':
            $term_id = get_post_meta( $post_id, '_emlm_product_type', true );
            echo esc_html( get_term( $term_id )->name );
            break;

        case '_emlm_license_type':
            $license_type = get_post_meta( $post_id, '_emlm_license_type', true );
            $all_license_type = Options::get_license_type();
            foreach ( $all_license_type as $index => $item ) {
                if ( $index == $license_type ) {
                    echo esc_html( $item );
                }
            }
            break;

        case '_emlm_owener_name':
            echo esc_html( get_post_meta( $post_id, '_emlm_owener_name', true ) );
            break;

        case '_emlm_activation':
            $default_max_activation = 1000;
            $license_type = get_post_meta( $post_id, '_emlm_license_type', true );
            if ( $license_type == 'limitation' ) {
                $max_activation = get_post_meta( $post_id, '_emlm_maximum_activations', true ) ? get_post_meta( $post_id, '_emlm_maximum_activations', true ) : $default_max_activation;
                $activated_key = get_post_meta( $post_id, '_emlm_activations', true ) ? get_post_meta( $post_id, '_emlm_activations', true ) : array();
                $activation = count( $activated_key ) . '/' . $max_activation;
                echo '<span class="limitation">' . esc_html( $activation ) . '</span>';
            } else {
                echo '<span class="unlimited">' . esc_html( '&infin;' ) . '</span>';
            }

            break;

        case '_emlm_license_status':
            $license_status = get_post_meta( $post_id, '_emlm_license_status', true );
            $all_license_status = Options::get_license_status();
            foreach ( $all_license_status as $index => $item ) {
                if ( $index == $license_status ) {
                    if ( $license_status == 'active' ) {
                        echo '<span class="active">' . esc_html( $item ) . '</span>';
                    } elseif ( $license_status == 'expired' ) {
                        echo '<span class="expired">' . esc_html( $item ) . '</span>';
                    } else {
                        echo '<span>' . esc_html( $item ) . '</span>';
                    }
                }
            }
            break;
        }
    }

}
