<?php
namespace Emlm\Base;
/**
 * Enqueue Scripts.
 *
 * @package emlm-license-key-manager
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Enqueue {
    /**
     * Constructor.
     */
    public function __construct() {
        add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
    }

    /**
     * Method Description.
     *
     * @param type $param_name Description.
     * @return return_type Description.
     */
    public function admin_scripts() {
        wp_enqueue_media();
        wp_enqueue_style( 'emlm-admin-styles', EMLM_PLUGIN_URL . 'assets/admin/css/admin.css', array(), EMLM_PLUGIN_VERSION, 'all' );
        wp_enqueue_script( 'chart-js', EMLM_PLUGIN_URL . 'assets/admin/js/chartjs.min.js', array(), EMLM_PLUGIN_VERSION, true );
        wp_enqueue_script( 'emlm-admin-scripts', EMLM_PLUGIN_URL . 'assets/admin/js/admin.js', array( 'jquery' ), EMLM_PLUGIN_VERSION, true );
        wp_localize_script( 'emlm-admin-scripts', 'emlm_ajax_data', array(
            'nonce'    => wp_create_nonce( 'wp_rest' ),
            'home_url' => home_url(),
        ) );

    }

}