<?php
namespace Emlm\AdminNotices;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class WooCommerceCheck {

    /**
     * Constructor to initialize WooCommerce check
     */
    public function __construct() {
        // Hook to check if WooCommerce is active
        add_action( 'admin_init', array( $this, 'check_woocommerce_active' ) );
    }

    /**
     * Check if WooCommerce is active
     */
    public function check_woocommerce_active() {
        if ( !class_exists( 'WooCommerce' ) ) {
            // Display admin notice if WooCommerce is not active
            add_action( 'admin_notices', array( $this, 'display_admin_notice' ) );
        }
    }

    /**
     * Display admin notice if WooCommerce is not activated
     */
    public function display_admin_notice() {
        ?>
        <div class="notice notice-warning is-dismissible">
            <p><strong>License Key Manager :</strong> WooCommerce is not activated. Some features of License Key Manager may not function properly without WooCommerce. Please activate WooCommerce to ensure full compatibility.</p>
        </div>
        <?php
}
}
