<?php
namespace Emlm\Abstracts;
 /**
  * 
  * @package    Licesne Key Manager
  * @since      1.0.0
  * @version    1.0.0
  * @author     Eilmo
  *
  */

 if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

abstract class FieldsBase {

  public static  $optionName;

  public static $getOptionData; 

  public function __construct() {

    self::$optionName = $this->get_option_name();
    self::$getOptionData = get_option(self::$optionName);

  }

  public function get_option_name() {}
  public function get_settings_panel() {}

  public function start_fields_section( $args ) {

    $default = [
      'title'     => esc_html__( 'Title goes here', 'emlm-license-key-manager' ),
      'class'     => '',
      'icon'      => '',
      'id'        => '',
      'display'   => 'none',
    ];

    $args = wp_parse_args( $args, $default );
    ?>
		<div id="<?php echo esc_attr( $args['id'] ); ?>" 
			 class="tab-content <?php echo esc_attr( $args['class'] ); ?>" 
			 style="display:<?php echo esc_attr( $args['display'] ); ?>">
			<?php if ( ! empty( $args['title'] ) ) : ?>
				<h3><?php echo esc_html( $args['title'] ); ?></h3>
			<?php endif; ?>
		<?php
  }

  public function end_fields_section() {
    echo '</div>';
  }

}