<?php
/**
 * Plugin Name:       EmbedVideoGjirafa
 * Plugin URI:        https://wordpress.org/plugins/embedvideogjirafa
 * Description:       Embed code për Video.Gjirafa.com
 * Version:           1.0.4
 * Requires at least: 6.0
 * Author:            Pajtim
 * Author URI:        https://pajtim.dev
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       video.gjirafa.com
 */

define( 'EVGJ_LICENSE', true );

// Codi embed Video Gjirafa
add_shortcode('embedvideogjirafa', array('embedgjirafavideo', 'EVGJ_shortcode'));
class embedgjirafavideo {
    function EVGJ_shortcode($atts, $content=null) {
          extract(shortcode_atts(array(
               'url'      => '',
               'scrolling'      => 'no',
               'width'      => '500',
               'height'      => '300',
               'frameborder'      => '0',
               'marginheight'      => '0',
          ), $atts));
             $url = str_replace('https://video.gjirafa.com/', '/', $url);
     if (empty($url)) return '<!-- Nese nuk ka link ne iframe -->';
     return '<iframe src="https://video.gjirafa.com/embed/'.$url.'" width="'.$width.'" height="'.$height.'" scrolling="'.$scrolling.'" frameborder="'.$frameborder.'" marginheight="'.$marginheight.'"></iframe>';
    }
}

// Hook Butoni Gjirafavideo
add_action('admin_head', 'EVGJ_embedvideogjirafa_button');
function EVGJ_embedvideogjirafa_button() {
    global $typenow;
    if ( !current_user_can('edit_posts') && !current_user_can('edit_pages') ) {
        return;
    }
    if( ! in_array( $typenow, array( 'post', 'page' ) ) )
        return;
    if ( get_user_option('rich_editing') == 'true') {
        add_filter('mce_external_plugins', 'EVGJ_tinymce_plugin');
        add_filter('mce_buttons', 'EVGJ_register_tinymce_plugin');
    }
}

function EVGJ_tinymce_plugin($plugin_array) {
    $plugin_array['EVGJ_embedvideogjirafa_button'] = plugin_dir_url( __FILE__ ).'js/embedvideogjirafa.js';
    return $plugin_array;
}

function EVGJ_register_tinymce_plugin($buttons) {
   array_push($buttons, "EVGJ_embedvideogjirafa_button");
   return $buttons;
}

// Butoni ne QTags
add_action('admin_footer-post-new.php', 'EVGJ_footer_admin');
add_action('admin_footer-post.php', 'EVGJ_footer_admin');
add_action('admin_footer-page-new.php', 'EVGJ_footer_admin');
add_action('admin_footer-page.php', 'EVGJ_footer_admin');
function EVGJ_footer_admin() {
?>
    <script type="text/javascript">
        QTags.addButton('EVGJ_embedvideogjirafa', '<?php echo esc_js(__('<>VideoGjirafa')); ?>', function() {
            var EVGJ_embedvideogjirafa_id = jQuery.trim(prompt('<?php echo esc_js(__('Vendos Linkun e VideoGjirafes')); ?>'));
            if (EVGJ_embedvideogjirafa_id) {
                QTags.insertContent('[embedvideogjirafa url="' + EVGJ_embedvideogjirafa_id + '"]');
            }
        });
    </script>
<?php
}

?>