<?php

defined( 'ABSPATH' ) || exit;

use EmailCraft\WpMVC\App;
use EmailCraft\Database\Setup;

/**
 * Plugin Name:       EmailCraft
 * Description:       Email templates builder
 * Version:           0.0.1
 * Requires at least: 6.5
 * Requires PHP:      7.4
 * Tested up to:      6.8
 * Author:            Crafium
 * Author URI:        https://crafium.com
 * License:           GPL v3 or later
 * License URI:       http://www.gnu.org/licenses/gpl-3.0.html
 * Text Domain:       emailcraft
 * Domain Path:       /languages
 */

require_once __DIR__ . '/vendor/vendor-src/autoload.php';
require_once __DIR__ . '/app/Helpers/helper.php';

final class EmailCraft
{
    public static EmailCraft $instance;

    public static function instance():EmailCraft {
        if ( empty( self::$instance ) ) {
            self::$instance = new self;
        }
        return self::$instance;
    }

    public function load() {
        // Run Activation Tasks
        register_activation_hook(
            __FILE__, function() {
                ( new Setup )->execute();
            } 
        );

        $application = App::instance();

        $application->boot( __FILE__, __DIR__ );

        /**
         * Fires once activated plugins have loaded.
         *
         */
        add_action(
            'plugins_loaded', function () use ( $application ): void {
                $application->load();
            }
        );
    }
}

EmailCraft::instance()->load();
