<?php

namespace EmailCraft\Database;

defined( 'ABSPATH' ) || exit;

use EmailCraft\WpMVC\Database\Schema\Schema;
use EmailCraft\WpMVC\Database\Schema\Blueprint;

class Setup {
    public function execute() {
        $prefix = 'emailcraft_';
        
        Schema::create(
            $prefix . 'template_types', function ( Blueprint $table ) {
                $table->big_increments( 'id' );
                $table->unsigned_big_integer( 'post_id' );
                $table->string( 'integration', 100 );
                $table->string( 'template_type', 100 );
                $table->timestamps();

                $table->foreign( 'post_id' )
                    ->references( 'ID' )
                    ->on( 'posts' )
                    ->on_delete( 'cascade' );
            } 
        );
    }
}