<?php

namespace EmailCraft\App\Repositories;

defined( 'ABSPATH' ) || exit;

use EmailCraft\WpMVC\Repositories\Repository;
use EmailCraft\WpMVC\Database\Query\Builder;
use EmailCraft\App\Models\TemplateType;

class TemplateTypeRepository extends Repository {
    public function get_query_builder(): Builder {
        return TemplateType::query();
    }

    public function get_by_post_id( int $post_id ) {
        $template = $this->get_query_builder()
            ->where( 'post_id', $post_id )
            ->first();

        if ( ! $template ) {
            return null;
        }

        return $template;
    }
} 