<?php

namespace EmailCraft\App\Providers;

defined( 'ABSPATH' ) || exit;

use EmailCraft\App\DTO\ContentDTO;
use EmailCraft\WpMVC\Contracts\Provider;

class WpServiceProvider implements Provider {
    public function boot() {
        add_filter( 'wp_new_user_notification_email', [ $this, 'filter_new_account_email' ], 10, 2 );
        add_filter( 'wp_new_user_notification_email_admin', [ $this, 'filter_new_account_email_admin' ], 10, 2 );
        add_filter( 'retrieve_password_notification_email', [ $this, 'filter_reset_password_email' ], 10, 3 );
        add_filter( 'password_change_email', [ $this, 'filter_password_change_email' ], 10, 2 );
        add_filter( 'wp_password_change_notification_email', [ $this, 'filter_password_change_email_admin' ], 10, 2 );
        add_filter( 'email_change_email', [ $this, 'filter_email_change_email' ], 10, 3 );
    }

    public function filter_new_account_email( $email, $user ) {
        $dto = ( new ContentDTO )
            ->set_integration( 'wordpress' )
            ->set_template_type( 'new_account' )
            ->set_args( compact( 'user' ) );

        $content = emailcraft_get_email_content( $dto );

        if ( $content ) {
            $email['message'] = $content;
            $email['headers'] = emailcraft_get_email_headers();
        }

        return $email;
    }

    public function filter_new_account_email_admin( $email, $user ) {
        $dto = ( new ContentDTO )
            ->set_integration( 'wordpress' )
            ->set_template_type( 'new_account_admin' )
            ->set_args( compact( 'user' ) );

        $content = emailcraft_get_email_content( $dto );

        if ( $content ) {
            $email['message'] = $content;
            $email['headers'] = emailcraft_get_email_headers();
        }

        return $email;
    }

    public function filter_reset_password_email( $email, $key, $user ) {
        $dto = ( new ContentDTO )
            ->set_integration( 'wordpress' )
            ->set_template_type( 'reset_password' )
            ->set_args( compact( 'user' ) );

        $content = emailcraft_get_email_content( $dto );

        if ( $content ) {
            $email['message'] = $content;
            $email['headers'] = emailcraft_get_email_headers();
        }

        return $email;
    }

    public function filter_password_change_email( $email, $user ) {
        $dto = ( new ContentDTO )
            ->set_integration( 'wordpress' )
            ->set_template_type( 'password_change' )
            ->set_args( compact( 'user' ) );

        $content = emailcraft_get_email_content( $dto );

        if ( $content ) {
            $email['message'] = $content;
            $email['headers'] = emailcraft_get_email_headers();
        }

        return $email;
    }
    
    public function filter_password_change_email_admin( $email, $user ) {
        $dto = ( new ContentDTO )
            ->set_integration( 'wordpress' )
            ->set_template_type( 'password_change_admin' )
            ->set_args( compact( 'user' ) );

        $content = emailcraft_get_email_content( $dto );

        if ( $content ) {
            $email['message'] = $content;
            $email['headers'] = emailcraft_get_email_headers();
        }

        return $email;
    }

    public function filter_email_change_email( $email, $user, $updated_user ) {
        $dto = ( new ContentDTO )
            ->set_integration( 'wordpress' )
            ->set_template_type( 'email_change' )
            ->set_args( compact( 'user', 'updated_user' ) );

        $content = emailcraft_get_email_content( $dto );

        if ( $content ) {
            $email['message'] = $content;
            $email['headers'] = emailcraft_get_email_headers();
        }

        return $email;
    }
} 