<?php

namespace EmailCraft\App\Providers;

defined( "ABSPATH" ) || exit;

use EmailCraft\App\DTO\ContentDTO;
use EmailCraft\WpMVC\Contracts\Provider;

class SmartTagServiceProvider implements Provider {
    public function boot() {
        add_filter( 'emailcraft_smarttag_tags', [$this, 'filter_smart_tags'], 10, 2 );
    }

    public function filter_smart_tags( $tags, ContentDTO $content_dto ) {
        if ( 'wordpress' === $content_dto->get_integration() && 'email_change' === $content_dto->get_template_type() ) {
            $tags[] = [
                'label'         => __( 'New Email', 'emailcraft' ),
                'value'         => '{user_new_email}',
                'demo_value'    => 'new.email@example.com',
                'data_callback' => function( $args ) {
                    return $args['updated_user']['user_email'] ?? '';
                },
                'category'      => 'current_template',
            ];
        }

        return $tags;
    }
}