<?php

namespace EmailCraft\App\Providers;

defined( 'ABSPATH' ) || exit;

use EmailCraft\WpMVC\Contracts\Provider;

class MenuServiceProvider implements Provider
{
    public function boot() {
        add_action( 'admin_menu', [$this, 'action_admin_menu'] );
    }

    public function action_admin_menu() {
        add_menu_page( esc_html__( 'EmailCraft', 'emailcraft' ), esc_html__( 'EmailCraft', 'emailcraft' ), 'manage_options', 'emailcraft', [$this, 'content'], 'dashicons-email-alt2', 5 );
    }

    public function content() {
        echo '<div class="emailcraft-root"></div>';
    }
}