<?php

namespace EmailCraft\App\Providers;

defined( 'ABSPATH' ) || exit;

use EmailCraft\WpMVC\Contracts\Provider;

class BlockServiceProvider implements Provider {
    public function boot() {
        add_action( 'init', [ $this, 'action_init' ] );
    }

    /**
     * Fires after WordPress has finished loading but before any headers are sent.
     */
    public function action_init() : void {
        foreach ( emailcraft_config( 'blocks' ) as $block_name => $block_data ) {
            $name = ltrim( $block_name, 'emailcraft' );
            register_block_type( $block_data['dir'] . $name );
        }
    }
}