<?php

namespace EmailCraft\App\Models;

defined( 'ABSPATH' ) || exit;

use EmailCraft\WpMVC\Database\Eloquent\Model;
use EmailCraft\WpMVC\Database\Resolver;
use EmailCraft\WpMVC\App;

class TemplateType extends Model {
    public static function get_table_name(): string {
        return 'emailcraft_template_types';
    }

    public function resolver(): Resolver {
        return App::$container->get( Resolver::class );
    }

    public function post() {
        return $this->belongs_to_one( Post::class, 'ID', 'post_id' );
    }
} 