<?php

namespace EmailCraft\App\Models;

defined( 'ABSPATH' ) || exit;

use EmailCraft\WpMVC\Database\Eloquent\Relations\HasOne;
use EmailCraft\WpMVC\App;
use EmailCraft\WpMVC\Database\Eloquent\Model;
use EmailCraft\WpMVC\Database\Eloquent\Relations\HasMany;
use EmailCraft\WpMVC\Database\Resolver;

class Post extends Model {
    public static function get_table_name():string {
        return 'posts';
    }

    public function template_type(): HasOne {
        return $this->has_one( TemplateType::class, 'post_id', 'ID' );
    }

    public function meta(): HasMany {
        return $this->has_many( PostMeta::class, 'post_id', 'ID' );
    }

    public function resolver():Resolver {
        return App::$container->get( Resolver::class );
    }
}