<?php

namespace EmailCraft\App\Http\Controllers\Admin;

defined( "ABSPATH" ) || exit;

use EmailCraft\App\DTO\ContentDTO;
use EmailCraft\App\Http\Controllers\Controller;
use EmailCraft\WpMVC\Routing\Response;
use EmailCraft\WpMVC\RequestValidator\Validator;
use EmailCraft\WpMVC\Exceptions\Exception;
use WP_REST_Request;

class TestEmailController extends Controller {
    public function send_email( Validator $validator, WP_REST_Request $request ): array {
        $validator->validate(
            [
                'content'       => 'required|string',
                'settings'      => 'required|array',
                'email'         => 'required|email',
                'integration'   => 'required|string',
                'template_type' => 'required|string'
            ]
        );

        add_filter( 'emailcraft_is_test_email', '__return_true' );

        $content  = $request->get_param( 'content' );
        $settings = $request->get_param( 'settings' );

        $dto = ( new ContentDTO )
            ->set_content( $content )
            ->set_settings( $settings )
            ->set_integration( $request->get_param( 'integration' ) )
            ->set_template_type( $request->get_param( 'template_type' ) );

        $content = emailcraft_process_email_content( $dto );

        wp_mail( $request->get_param( 'email' ), "EmailCraft Test Email", $content, emailcraft_get_email_headers() );
        return Response::send( [] );
    }
}