<?php

namespace EmailCraft\App\DTO;

defined( "ABSPATH" ) || exit;

use EmailCraft\WpMVC\DTO\DTO;

class ContentDTO extends DTO {
    private string $content;

    private array $settings;

    private string $integration = '';

    private string $template_type = '';

    private array $args = [];

    /**
     * Get the value of content
     *
     * @return string
     */
    public function get_content(): string {
        return $this->content;
    }

    /**
     * Set the value of content
     *
     * @param string $content 
     *
     * @return self
     */
    public function set_content( string $content ): self {
        $this->content = $content;

        return $this;
    }

    /**
     * Get the value of settings
     *
     * @return array
     */
    public function get_settings(): array {
        return $this->settings;
    }

    /**
     * Set the value of settings
     *
     * @param array $settings 
     *
     * @return self
     */
    public function set_settings( array $settings ): self {
        $this->settings = $settings;

        return $this;
    }

    /**
     * Get the value of integration
     *
     * @return string
     */
    public function get_integration(): string {
        return $this->integration;
    }

    /**
     * Set the value of integration
     *
     * @param string $integration 
     *
     * @return self
     */
    public function set_integration( string $integration ): self {
        $this->integration = $integration;

        return $this;
    }

    /**
     * Get the value of template_type
     *
     * @return string
     */
    public function get_template_type(): string {
        return $this->template_type;
    }

    /**
     * Set the value of template_type
     *
     * @param string $template_type 
     *
     * @return self
     */
    public function set_template_type( string $template_type ): self {
        $this->template_type = $template_type;

        return $this;
    }

    /**
     * Get the value of args
     *
     * @return array
     */
    public function get_args(): array {
        return $this->args;
    }

    /**
     * Set the value of args
     *
     * @param array $args 
     *
     * @return self
     */
    public function set_args( array $args ): self {
        $this->args = $args;

        return $this;
    }
}