<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'EMAILKING_PLUGIN_DIR', dirname( __DIR__ ) );
define( 'EMAILKING_ACCESS_USER_CAP', 'edit_posts' );
define( 'EMAILKING_VERSION', '1.0.0' );
define( 'EMAILKING_BASENAME', basename( EMAILKING_PLUGIN_DIR ) );
define( 'EMAILKING_PLUGIN_URL', rtrim( plugin_dir_url( EMAILKING_PLUGIN_FILE ), '/' ) );
define( 'EMAILKING_URL', admin_url( 'admin-ajax.php?action=emailking-app' ) );

spl_autoload_register(
	function ( $class_name ) {
		$class_name = ltrim( $class_name, '\\' );
		$class_name = str_replace( '\\', '/', $class_name );
		$class_name = str_replace( '_', '-', $class_name );
		$class_name = ltrim( $class_name, '-' );
		$class_name = strtolower( $class_name );

		$namespace = 'emailking/';

		if ( 0 === strpos( $class_name, $namespace ) ) {
			$class_name = substr( $class_name, strlen( $namespace ) );
			$file1      = EMAILKING_PLUGIN_DIR . '/inc/classes/class-' . $class_name . '.php';
			$file2      = EMAILKING_PLUGIN_DIR . '/inc/classes/trait-' . $class_name . '.php';

			if ( file_exists( $file1 ) ) {
				require_once $file1;
				return;
			}

			if ( file_exists( $file2 ) ) {
				require_once $file2;
			}
		}
	}
);

$GLOBALS['EMAIL_KING'] = new \EmailKing\Main( EMAILKING_PLUGIN_FILE );

function emailking( $key = null ) {
	if ( null !== $key ) {
		return $GLOBALS['EMAIL_KING']->$key;
	}

	return $GLOBALS['EMAIL_KING'];
}

require_once EMAILKING_PLUGIN_DIR . '/mods/index.php';
