<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function emailking_init_free() {
	define( 'EMAILKING_PLUGIN_BASENAME', plugin_basename( EMAILKING_PLUGIN_FILE ) );

	if ( defined( 'EMAILKING_PRO' ) ) {
		function emailking_show_pro_installed() {
			echo '<tr class="plugin-update-tr active">';
			echo '<td colspan="12" class="plugin-update colspanchange">';
			echo '<div class="wpemailking_proavl" style="margin: 0 18px 18px 40px;border-radius:4px;padding:6px 10px;background-color:rgba(165,95,61,1);color:#fff;">';
			echo 'The pro version of <strong>Email King</strong> is installed. You can deactivate or remove the free plugin.';
			echo '</div>';
			echo '</td>';
			echo '</tr>';
		}

		add_action( 'after_plugin_row_' . EMAILKING_PLUGIN_BASENAME, 'emailking_show_pro_installed', 1000 );

		return;
	}

	function emailking_add_buy_link( $links, $file ) {
		global $plugin_name;

		if ( EMAILKING_PLUGIN_BASENAME === $file ) {
			$links[] = sprintf( '<a target="_blank" style="color:#a55f3d;font-weight:bold;" href="https://dym5.com/wordpress/plugins/emailking/?ref=fplist">Buy PRO ↗</a>' );
		}

		return $links;
	}

	add_filter( 'plugin_action_links', 'emailking_add_buy_link', 10, 2 );

	require_once __DIR__ . '/plugin.php';
}

add_action( 'plugins_loaded', 'emailking_init_free', -75 );

function emailking_plugins_inline_script( $hook ) {
	if ( 'plugins.php' !== $hook ) {
		return;
	}

	wp_enqueue_script( 'emailking-pp', EMAILKING_PLUGIN_URL . '/static/plugins.js', array(), EMAILKING_VERSION, true );
}

add_action( 'admin_enqueue_scripts', 'emailking_plugins_inline_script', 20 );
