<?php

namespace EmailKing;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Utils {

	private static $get_params_cache = null;

	public static function get_params() {
		if ( null === self::$get_params_cache ) {
			if ( isset( $_SERVER['REQUEST_URI'] ) ) {
				$query_string = sanitize_url( wp_unslash( $_SERVER['REQUEST_URI'] ) );
				$query_string = explode( '?', $query_string, 2 );
				$query_string = isset( $query_string[1] ) ? $query_string[1] : '';
			}

			parse_str( $query_string, self::$get_params_cache );
		}

		if ( null === self::$get_params_cache || empty( self::$get_params_cache ) ) {
			return array();
		}

		return self::$get_params_cache;
	}
}
