<?php

namespace EmailKing;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Admin {

	public static function init() {
		return new self();
	}

	public function __construct() {
		add_action( 'admin_menu', array( $this, 'add_admin_menu' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_assets' ) );
	}

	public function add_admin_menu() {
		$icon = EMAILKING_PLUGIN_URL . '/static/icon.svg';

		add_menu_page(
			'Email King',                      // Page title.
			'Email King',                      // Menu title.
			EMAILKING_ACCESS_USER_CAP,       // Capability.
			'emailking',                      // Menu slug.
			array( $this, 'admin_page' ),      // Callback.
			$icon,                             // Icon URL.
			80,                                // Position.
		);
	}

	public function enqueue_assets( $hook ) {
		if ( 'toplevel_page_emailking' !== $hook ) {
			return;
		}

		wp_enqueue_script( 'emailking-admin', EMAILKING_PLUGIN_URL . '/static/admin.js', array(), EMAILKING_VERSION, true );
		wp_enqueue_style( 'emailking-admin', EMAILKING_PLUGIN_URL . '/static/admin.css', array(), EMAILKING_VERSION );
	}

	public function admin_page() {
		include EMAILKING_PLUGIN_DIR . '/templates/admin.php';
	}
}
