<?php

namespace Legacy\EmailEncoderBundle\Integration;

use OnlineOptimisation\EmailEncoderBundle\Integrations\IntegrationInterface;
use OnlineOptimisation\EmailEncoderBundle\Traits\PluginHelper;

class HivePress implements IntegrationInterface {

    use PluginHelper;

    public function boot (): void {
        if ( $this->is_active() ) {
            add_filter( 'eeb/settings/fields', [ $this, 'deactivate_logic' ], 10 );
        }
    }


    public function is_active(): bool {
        return defined( 'HP_FILE' );
    }


    /**
     * @param array< string, array< string, mixed > > $fields
     * @return array< string, array< string, mixed > >
     */
    public function deactivate_logic( $fields ) {

        $uri = isset( $_SERVER['REQUEST_URI'] )
            ? wp_parse_url( $_SERVER['REQUEST_URI'], PHP_URL_PATH )
            : ''
        ;

        $condition = preg_match( '#/account/listings/(\d+)/?$#', $uri )
            && isset( $fields['protect']['value'] )
        ;

        if ( $condition ) {
            // $this->log( 'HivePress: protecting; trait is working :)' );
            $fields[ 'protect' ]['value'] = $this->settings()::PROTECT_DISABLED;
        }

        return $fields;
    }

}
