jQuery(function($){
    
	//Slutar ladda sida ifall Pluginen inte är laddad
	if(!$(".ellibot_woocommerce_slider_container").length){
		return;
	}
	
	//Visar preloader
	ellibot_woocommerce_slider_preloader(true,"show");
	
	//Fönstret ändrar storlek
	$(window).resize(function(){
		ellibot_woocommerce_slider_resize();
	});
	
	//När sidan laddas görs detta
	ellibot_woocommerce_slider_get_slider();
				
	//Hämtar och visar slider
	function ellibot_woocommerce_slider_get_slider(){
		
		//Skickar med shortcode attribut (json-format)
		var shortcode_attr = $(".ellibot_woocommerce_slider_shortcode_attr").text();
		
		//Skickar med nonce
		var nonce = $(".ellibot_woocommerce_slider_ajax_nonce").text();
		
		var data = {
			'action' : 'ellibot_woocommerce_slider',
			'choice' : 'get_slider',
			'nonce'	: nonce,
			'shortcode_attr' : shortcode_attr
		};
		
		ellibot_woocommerce_slider_do_ajax("start");
		
		jQuery.post(ajax_object.ajax_url, data, function(response) {
			
			var result = JSON.parse(response);
			
			ellibot_woocommerce_slider_do_ajax("stop");
			
			if(result[0] == "alert"){
				alert("Ellibot WooCommerce Slider message (alert): "+result[1]);
			}
			else if(result[0] == "console"){
				console.log("Ellibot WooCommerce Slider message (console): "+result[1]);
			}
			else if(result[0] == "prompt"){
				$(".ellibot_woocommerce_slider_loader_bg").html(result[1]);
				$(".ellibot_woocommerce_slider_loader").hide();
			}
			else if(result[0] == "success"){
				$(".ellibot_woocommerce_slider_container_ajax").html(result[1]);
				ellibot_woocommerce_slider_engine();
			}
			else{
				alert("Ellibot WooCommerce Slider message (response): "+response);
			}
				
		})
			
	}
	
	
	//STARTAR SLIDER
	function ellibot_woocommerce_slider_engine(){
		
		//Thumbnails - Funktion för musklick thumbnail
		$(".ellibot_woocommerce_slider_thumb").mousedown(function(){
			ellibot_woocommerce_slider_thumb_click($(this).attr("data-id"));
		})
		
		//Navs - Funktion för musklick nav
		$(".ellibot_woocommerce_slider_nav").mousedown(function(){
			ellibot_woocommerce_slider_thumb_click($(this).attr("data-id"));
		})
		
		//Funktion för klick av höger-pil i slider
		$(".ellibot_woocommerce_slider_arrow_right").mousedown(function(){
			var slide_id = parseInt($(".ellibot_woocommerce_slider_content").attr("data-slide"));
			var slide_count = parseInt($(".ellibot_woocommerce_slider_slide").length);
			if(slide_id < slide_count){slide_id++;}//else{slide_id = 1;}
			ellibot_woocommerce_slider_thumb_click(slide_id);
		})
		
		//Funktion för klick av vänster-pil i slider
		$(".ellibot_woocommerce_slider_arrow_left").mousedown(function(){
			var slide_id = parseInt($(".ellibot_woocommerce_slider_content").attr("data-slide"));
			var slide_count = parseInt($(".ellibot_woocommerce_slider_slide").length);
			if(slide_id > 1){slide_id--;}//else{slide_id = slide_count;}
			ellibot_woocommerce_slider_thumb_click(slide_id);
		})
		
		$(".ellibot_woocommerce_slider_thumbs_arrow_left").hide();
		$(".ellibot_woocommerce_slider_thumbs_arrow_right").hide();
		
		//Thumbnails - Funktion för musklick vänster-pilen
		$(".ellibot_woocommerce_slider_thumbs_arrow_left").mousedown(function(){
			
			//Det går inte byta mitt i bytet
			var thumb_status = $(".ellibot_woocommerce_slider_thumbs").attr("data-status");
			if(thumb_status == "stop"){return false;}
			$(".ellibot_woocommerce_slider_thumbs").attr("data-status","stop");
			
			var thumbMargin = parseInt(ellibot_woocommerce_slider_global_thumb_margin.replace(/\D/g,''));
			var thumbWidth = parseInt($(".ellibot_woocommerce_slider_thumb").outerWidth())+thumbMargin;
			var thumbConMargin = parseInt($(".ellibot_woocommerce_slider_thumbs_content").css("margin-left").replace(/\D/g,''));
			var thumbMove = parseInt(thumbConMargin-thumbWidth);
			
			//Stopp för vänsterpil
			if(thumbMove < 0){
				$(".ellibot_woocommerce_slider_thumbs_content").animate({ "margin-left": "-"+50,"opacity":0.5}, 100, function(){
					$(".ellibot_woocommerce_slider_thumbs_content").animate({ "margin-left": 0,"opacity":1}, 200, function(){
						$(".ellibot_woocommerce_slider_thumbs").attr("data-status","ready");
					});
				});
				return false;
			}
			
			$(".ellibot_woocommerce_slider_thumbs_content").animate({ "margin-left": "-"+thumbMove}, 200, function(){
				$(".ellibot_woocommerce_slider_thumbs").attr("data-status","ready");
			});
			
		})
		
		//Thumbnail - Funktion för musklick höger-pilen
		$(".ellibot_woocommerce_slider_thumbs_arrow_right").mousedown(function(){
			
			//Det går inte byta mitt i bytet
			var thumb_status = $(".ellibot_woocommerce_slider_thumbs").attr("data-status");
			if(thumb_status == "stop"){return false;}
			$(".ellibot_woocommerce_slider_thumbs").attr("data-status","stop");
			
			var thumbMargin = parseInt(ellibot_woocommerce_slider_global_thumb_margin.replace(/\D/g,''));
			var thumbWidth = parseInt($(".ellibot_woocommerce_slider_thumb").outerWidth())+thumbMargin;
			var thumbConMargin = parseInt($(".ellibot_woocommerce_slider_thumbs_content").css("margin-left").replace(/\D/g,''));
			var thumbMove = parseInt(thumbConMargin+thumbWidth);
			var countThumbs = parseInt($(".ellibot_woocommerce_slider_thumb").length);
			var totalWidth = parseInt(thumbWidth*countThumbs);
			var thumbsWidth = $(".ellibot_woocommerce_slider_thumbs_content").outerWidth();
			
			//Stopp för högerpil (10 = en viss marginal då den ibland räknar fel)
			if((thumbsWidth+thumbMargin+10) >= totalWidth){
				$(".ellibot_woocommerce_slider_thumbs_content").animate({ "margin-left": "-"+(thumbConMargin+50),"opacity":0.5}, 100, function(){
					$(".ellibot_woocommerce_slider_thumbs_content").animate({ "margin-left": "-"+thumbConMargin,"opacity":1}, 200, function(){
						$(".ellibot_woocommerce_slider_thumbs").attr("data-status","ready");
					});
				});
				return false;
			}
			
			$(".ellibot_woocommerce_slider_thumbs_content").animate({ "margin-left": "-"+thumbMove}, 200, function(){
				$(".ellibot_woocommerce_slider_thumbs").attr("data-status","ready");
			});
			
		})
		
		//Aktiverar Touchwipe
		if(parseInt($(".ellibot_woocommerce_slider_thumb").length) > 1){
			$(".ellibot_woocommerce_slider_content").swipe( {
				swipeLeft:function(event, direction, distance, duration, fingerCount, fingerData) {
					ellibot_woocommerce_slider_swipeleftHandler();
				},
				swipeRight:function(event, direction, distance, duration, fingerCount, fingerData) {
					ellibot_woocommerce_slider_swiperightHandler();
				},
				threshold:30//75 standard
			});
		}
		 
		//Funktion för att öppna/stänga thumbnailsfältet
		$(".ellibot_woocommerce_slider_btn_handle_thumbs").on("click",function(){
			
			if(ellibot_woocommerce_slider_global_thumbs_arrow_show == 1){
				$(".ellibot_woocommerce_slider_thumbs_arrow_left").css("opacity",1);
				$(".ellibot_woocommerce_slider_thumbs_arrow_right").css("opacity",1);
			}
			
			//Öppnar
			if($(".ellibot_woocommerce_slider_thumbs").height() <= 0){
				var containerHeight = $(".ellibot_woocommerce_slider_thumbs_container").innerHeight();
				thumbsAnimate();
			}
			//Stänger
			else{
				var containerHeight = 0;
				//Döljer pilar innan animation av thumbs
				$(".ellibot_woocommerce_slider_thumbs_arrow_left").hide();
				$(".ellibot_woocommerce_slider_thumbs_arrow_right").hide();
				thumbsAnimate();
			}
			
			function thumbsAnimate(){
				
				$(".ellibot_woocommerce_slider_thumbs").animate({"height":containerHeight},500, function(){
					if(containerHeight != 0){
						//öppnar (ändrat text till hide och visar pilar)
						$(".ellibot_woocommerce_slider_thumbs").css("height","auto");
						$(".ellibot_woocommerce_slider_thumbs_show").hide();
						$(".ellibot_woocommerce_slider_thumbs_hide").show();
						$(".ellibot_woocommerce_slider_thumbs_arrow_left").show();
						$(".ellibot_woocommerce_slider_thumbs_arrow_right").show();
					}
					else{
						//stänger (ändrar text till show)
						$(".ellibot_woocommerce_slider_thumbs_hide").hide();
						$(".ellibot_woocommerce_slider_thumbs_show").show();
					}
				});
			}
			
		});
		 
		 
		//Visar slidern när alla bilderna är laddade
		var nrOfImagesLoaded = 0;
		var nrOfImages = parseInt($('.ellibot_woocommerce_slider_content').find('img').length);
		$(".ellibot_woocommerce_slider_loader_bg").html("<div class='ellibot_woocommerce_slider_loader_percent'>0%</div>");
		
		$('.ellibot_woocommerce_slider_content').find('img').on('load', function() {
			nrOfImagesLoaded = nrOfImagesLoaded+1;
			$(".ellibot_woocommerce_slider_loader_percent").text(parseInt((nrOfImagesLoaded/nrOfImages)*100)+"%");
			increaseInt();
			if(nrOfImagesLoaded == nrOfImages){
				showSlider();
			}
		})
		
		increaseInt();
		function increaseInt(){
			setTimeout(function(){
				newInt = parseInt($(".ellibot_woocommerce_slider_loader_percent").text().replace(/\D/g,''))+1;
				if(newInt < 100){
					$(".ellibot_woocommerce_slider_loader_percent").text(newInt+"%");
					increaseInt();
				}
			},100);
		}
		
		
		//Öppnar slider
		function showSlider(){
		
			ellibot_woocommerce_slider_resize();
			setTimeout(function(){
			  
				ellibot_woocommerce_slider_preloader(false,"hide");

				//Visar/Döljer thumbs från start
				if(ellibot_woocommerce_slider_global_thumbs_show == 1){
				  var container = $(".ellibot_woocommerce_slider_thumbs_container").innerHeight();
				  $(".ellibot_woocommerce_slider_thumbs").animate({"height":container},500, function(){
						$(".ellibot_woocommerce_slider_thumbs").css("height","auto");
						$(".ellibot_woocommerce_slider_thumbs_hide").show();
						$(".ellibot_woocommerce_slider_navs").animate({"opacity":1},500);
						$(".ellibot_woocommerce_slider_thumbs_arrow_left").show();
						$(".ellibot_woocommerce_slider_thumbs_arrow_right").show();
						if(ellibot_woocommerce_slider_global_thumbs_arrow_show != 0){
							$(".ellibot_woocommerce_slider_thumbs_arrow_left").animate({"opacity":1},500);
							$(".ellibot_woocommerce_slider_thumbs_arrow_right").animate({"opacity":1},500);
						}
						//Resizar fönstret en gång till för att få med scrollbaren i fönstrets bredd som eventuellt visas efter att thumbsen åkt ner, gäller bara om slidern är angedd i procent
						ellibot_woocommerce_slider_resize();
						//Visar första sliden
						ellibot_woocommerce_slider_change();
				  });
				}
				else{
					$(".ellibot_woocommerce_slider_thumbs_show").show();
					$(".ellibot_woocommerce_slider_navs").animate({"opacity":1},ellibot_woocommerce_slider_global_slide_duration);
					//Resizar fönstret en gång till för att få med scrollbaren i fönstrets bredd som eventuellt visas efter att thumbsen åkt ner, gäller bara om slidern är angedd i procent
					ellibot_woocommerce_slider_resize();
					//Visar första sliden
					ellibot_woocommerce_slider_change();
				}
			},0);
		   
		}
		
	}
	
	
	//BYTER SLIDE AUTOMATISKT
	function ellibot_woocommerce_slider_change(){
		
		//Om webbläsar-fönstret inte är aktivt
		if(document.hidden){
			setTimeout(ellibot_woocommerce_slider_change, ellibot_woocommerce_slider_global_slide_auto_speed);
			return;
		}
		
		if($(".ellibot_woocommerce_slider_content").attr("data-auto") == "no"){return false;}
		$(".ellibot_woocommerce_slider_content").attr("data-status","stop");
		
		var slide_id = parseInt($(".ellibot_woocommerce_slider_content").attr("data-slide"));
		var actual_slide_id = slide_id;
		var slide_count = parseInt($(".ellibot_woocommerce_slider_slide").length);
		
		if(slide_id < slide_count){slide_id++;}
		else{slide_id = 1;}
		
		//Byter via animation
		ellibot_woocommerce_slider_do_annimation(slide_id,actual_slide_id,"left");
		$(".ellibot_woocommerce_slider_content").attr("data-slide",slide_id); 
		
		//Timer
		if(slide_count > 1){setTimeout(ellibot_woocommerce_slider_change, ellibot_woocommerce_slider_global_slide_auto_speed);}
		
	}
	

	//BYTER MANUELLT (KLICKAR THUMB)
	function ellibot_woocommerce_slider_thumb_click(slide_id){
		
		//Det går inte byta mitt i bytet
		var slide_status = $(".ellibot_woocommerce_slider_content").attr("data-status");
		if(slide_status == "stop"){return false;}
		
		$(".ellibot_woocommerce_slider_content").attr("data-auto",'no');
		$(".ellibot_woocommerce_slider_content").attr("data-status","stop");
		
		//Det går inte att byta till samma slide som visas
		var actual_slide_id = $(".ellibot_woocommerce_slider_content").attr("data-slide");
		if(actual_slide_id == slide_id){
			$("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).animate({ "left": "-50px","opacity":0.5}, 200, function(){
				$("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).animate({ "left": "0px","opacity":1}, 400, function(){
					$(".ellibot_woocommerce_slider_content").attr("data-status","ready");
				});
			});
			return false;
		}
		
		//Kontrollerar om nästa slide ska hämtas från vänster eller höger
		if(slide_id > actual_slide_id){direction = "left";}else{direction = "right";}
		
		//Byter slide
		ellibot_woocommerce_slider_do_annimation(slide_id,actual_slide_id,direction);
		
	}
	
	
	//SWIPE VÄNSTER
	function ellibot_woocommerce_slider_swipeleftHandler(){
		
		//Det går inte byta mitt i bytet
		var slide_status = $(".ellibot_woocommerce_slider_content").attr("data-status");
		if(slide_status == "stop"){return false;}
		
		$(".ellibot_woocommerce_slider_content").attr("data-auto",'no');
		$(".ellibot_woocommerce_slider_content").attr("data-status","stop");
		
		//Berättar vilken som är vald och vilken som kommer näst
		var actual_slide_id = $(".ellibot_woocommerce_slider_content").attr("data-slide");
		var slide_id = $("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).next().attr("data-id");
		if(slide_id == undefined){slide_id = 1;}
		ellibot_woocommerce_slider_do_annimation(slide_id,actual_slide_id,"left");
		
	}
	
	
	//SWIPE HÖGER
	function ellibot_woocommerce_slider_swiperightHandler(){
		
		//Det går inte byta mitt i bytet
		var slide_status = $(".ellibot_woocommerce_slider_content").attr("data-status");
		if(slide_status == "stop"){return false;}
		
		$(".ellibot_woocommerce_slider_content").attr("data-auto",'no');
		$(".ellibot_woocommerce_slider_content").attr("data-status","stop");
		
		//Berättar vilken som är vald och vilken som kommer näst
		var actual_slide_id = $(".ellibot_woocommerce_slider_content").attr("data-slide");
		var slide_id = $("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).prev().attr("data-id");
		if(slide_id == undefined){slide_id = $(".ellibot_woocommerce_slider_slide").length;}
		ellibot_woocommerce_slider_do_annimation(slide_id,actual_slide_id,"right");
		
	}
	
	
	//BYTER SLIDE GENOM ANIMATION
	function ellibot_woocommerce_slider_do_annimation(slide_id,actual_slide_id,swipe_side){
		
		var winWidth = $(".ellibot_woocommerce_slider_content").width();
		var winHeight = $(".ellibot_woocommerce_slider_content").height();
		
		if(swipe_side == "left"){
			var posOld = winWidth;
			var posNew = -winWidth;
		}
		else if(swipe_side == "right"){
			var posOld = -winWidth;
			var posNew = winWidth;
		}
		
		//Flyttar alla slides utom just den slide som visas till rätt sida
		$(".ellibot_woocommerce_slider_slide").each(function(){
			if($(this).attr("data-id") != actual_slide_id){
				$(this).css("left",posOld);
			}
		})
		
		$(".ellibot_woocommerce_slider_slide").css("opacity",1);
		$(".ellibot_woocommerce_slider_slide").css("display","block");

		ellibot_woocommerce_slider_prepare_animation(slide_id,winWidth,winHeight);
		
		//Animerar (tidigare) aktuell slide att flyttas ut
		$("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).animate({ "left": posNew,"opacity":0}, ellibot_woocommerce_slider_global_slide_duration);
		
		//Animerar (ny) vald slide att flyttas in
		$("#ellibot_woocommerce_slider_slide_id_"+slide_id).css("opacity",0);
		$("#ellibot_woocommerce_slider_slide_id_"+slide_id).animate({ "left": "+0px","opacity":1}, ellibot_woocommerce_slider_global_slide_duration, function(){
			$(".ellibot_woocommerce_slider_content").attr("data-slide",slide_id);
			$(".ellibot_woocommerce_slider_content").attr("data-status","ready");
		});
		
		//Ändrar aktiv nav
		$(".ellibot_woocommerce_slider_nav").removeClass("ellibot_woocommerce_slider_nav_active");
		$("#ellibot_woocommerce_slider_nav_id_"+slide_id).addClass("ellibot_woocommerce_slider_nav_active");
		
	}
	
	
	//FÖNSTRET ÄNDRAR STORLEK
	function ellibot_woocommerce_slider_resize(){
		
		var thumb_height = 0;
		var set_thumb_height = 0;
		
		var winWidth = $(".ellibot_woocommerce_slider_content").width();
		
		//Berättar hur många thumbs som kan visas i bredd
		var countThumbs = parseInt($(".ellibot_woocommerce_slider_thumb").length);
		if(countThumbs > ellibot_woocommerce_slider_global_thumbs_max_count){
			countThumbs = ellibot_woocommerce_slider_global_thumbs_max_count;
		}
		
		//Antalet thumbs som visas styrs också av sliderns bredd
		if(winWidth <= 600){countThumbs = 1;}
		else if(winWidth <= 767 && countThumbs >= 2){countThumbs = 2;}
		else if(winWidth <= 1000 && countThumbs >= 3){countThumbs = 3;}
		else if(winWidth <= 1200 && countThumbs >= 4){countThumbs = 4;}
		else if(winWidth <= 1400 && countThumbs >= 5){countThumbs = 5;}
		else if(winWidth <= 1600 && countThumbs >= 6){countThumbs = 6;}
		else if(winWidth <= 1800 && countThumbs >= 7){countThumbs = 7;}
		else if(winWidth <= 2000 && countThumbs >= 8){countThumbs = 8;}
		else if(winWidth <= 2200 && countThumbs >= 9){countThumbs = 9;}
		else if(countThumbs >= 10){countThumbs = 10;}
		
		var arrowWidth = $(".ellibot_woocommerce_slider_thumbs_arrow_right").outerWidth();
		var thumbMargin = parseInt(ellibot_woocommerce_slider_global_thumb_margin.replace(/\D/g,''));
		
		//Med pilarna dolda
		if(ellibot_woocommerce_slider_global_thumbs_arrow_show == 0){
			var thumbMarginTotal =(thumbMargin*(countThumbs+1))-(thumbMargin*2);
			var freeWinWidth = (winWidth-(thumbMarginTotal));
			var thumbWidth = (freeWinWidth/countThumbs);
			var freeWinArea = (winWidth);
			$(".ellibot_woocommerce_slider_thumb").first().attr("style","margin-left:0 !important");
		}
		//Med pilarna visade
		else{
			var arrowWidthTotal = (arrowWidth*2);
			var thumbMarginTotal = (thumbMargin*(countThumbs+1));
			var freeWinWidth = (winWidth-(arrowWidthTotal+thumbMarginTotal));
			var thumbWidth = (freeWinWidth/countThumbs);
			var freeWinArea = (winWidth-arrowWidthTotal-1);
		}
		
		$(".ellibot_woocommerce_slider_thumbs_container").css("max-width",freeWinArea);
		$(".ellibot_woocommerce_slider_thumbs_content").css("margin-left",0);
			
		//Sätter pilarna på rätt plats
		$(".ellibot_woocommerce_slider_thumbs_arrow_right").css("left",parseInt((winWidth-arrowWidth)));
		$(".ellibot_woocommerce_slider_arrow_right").css("left",parseInt((winWidth-arrowWidth)));
		
		//Sätter bredd på thumbs så att alla har samma bredd
		$(".ellibot_woocommerce_slider_thumb").css("width",thumbWidth);
		
		//Hämtar ut den thumb som är högst
		$(".ellibot_woocommerce_slider_thumb").css("height","auto");
		$(".ellibot_woocommerce_slider_thumb").each(function(){
			thumb_height = parseInt($(this).outerHeight());
			if(thumb_height > set_thumb_height){set_thumb_height = thumb_height;}
		})
		
		//Sätter höjd på thumbs så att alla har samma storlek oavsett innehåll
		$(".ellibot_woocommerce_slider_thumb").css("height",set_thumb_height);
		
		//Om slidern ska ha hela fönstrets höjd
		if(ellibot_woocommerce_slider_global_slide_full_height == 1){
			var screenHeight = $(window).height();
			var thumbsHeight = 0;
			var sliderTop = $(".ellibot_woocommerce_slider_content").offset().top;
			if(ellibot_woocommerce_slider_global_thumbs_show == 1){
				thumbsHeight = $(".ellibot_woocommerce_slider_thumbs_container").outerHeight();
			}
			var freeHeight = (screenHeight-sliderTop)-thumbsHeight;
			if(freeHeight < 300){freeHeight = screenHeight-sliderTop;}
			$(".ellibot_woocommerce_slider_container_ajax").css("min-height",freeHeight);
			$(".ellibot_woocommerce_slider_content").css("height",freeHeight);
		}
		var winHeight = $(".ellibot_woocommerce_slider_content").height();
		
		//Sätter pilarna till rätt höjd
		$(".ellibot_woocommerce_slider_thumbs_arrow_left").css("height",set_thumb_height);
		$(".ellibot_woocommerce_slider_thumbs_arrow_right").css("height",set_thumb_height);
		$(".ellibot_woocommerce_slider_arrow_left").css("height",winHeight);
		$(".ellibot_woocommerce_slider_arrow_right").css("height",winHeight);
		
		//Flyttar vald slider till rätt position och gömmer de andra (fix när man ändrar storlek på skärm)
		var actual_slide_id = $(".ellibot_woocommerce_slider_content").attr("data-slide");
		$(".ellibot_woocommerce_slider_slide").css("opacity",0);
		$("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).css("left",0);
		$("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).css("opacity",1);
		
		//Synkar med CSS för liten skärmbredd 767
		if($(".ellibot_woocommerce_slider_screen_check_767px").is(":visible")){
			
			ellibot_woocommerce_slider_global_slide_duration = 500;
			
			$(".ellibot_woocommerce_slider_image_text").css("position","relative");
			$(".ellibot_woocommerce_slider_image_text_desc").css("display","block");
			$(".ellibot_woocommerce_slider_image_text_desc").css("white-space","normal");
			$(".ellibot_woocommerce_slider_image_text_title").css("white-space","normal");
			
			//Anpassar slider för liten skärm (högsta text-höjd +  högsta bild-höjd = sätter total höjd)
			var setSlideImageHeight = 0;
			var setSlideTextHeight = 0;
			$(".ellibot_woocommerce_slider_slide").each(function(){
				
				var slideImageHeight = $(this).find("img").outerHeight();
				var slideTextHeight = $(this).find(".ellibot_woocommerce_slider_image_text").outerHeight();
				
				if(slideImageHeight > setSlideImageHeight){setSlideImageHeight = slideImageHeight;}
				if(slideTextHeight > setSlideTextHeight){setSlideTextHeight = slideTextHeight;}
			});
			$(".ellibot_woocommerce_slider_content").css("min-height",parseInt(setSlideImageHeight+setSlideTextHeight));
			$(".ellibot_woocommerce_slider_content").css("max-height",parseInt(setSlideImageHeight+setSlideTextHeight));
			
		}
		else{
			ellibot_woocommerce_slider_global_slide_duration = ellibot_woocommerce_slider_global_slide_duration_original;
			$(".ellibot_woocommerce_slider_content").css("min-height","auto");
			ellibot_woocommerce_slider_prepare_animation(actual_slide_id,winWidth,winHeight);
		}
		
		ellibot_woocommerce_slider_preloader(true);
		
	}
	
	
	//FÖRBEREDER INFÖR BYTE AV SLIDE
	function ellibot_woocommerce_slider_prepare_animation(actual_slide_id,winWidth,winHeight){
		
		//Använder bilden som bakgrund i stället för text och bild sida vid sida
		if(ellibot_woocommerce_slider_global_slide_image_asbg == 1 && !$(".ellibot_woocommerce_slider_screen_check_767px").is(":visible")){
			$(".ellibot_woocommerce_slider_image").css("width","100%");
			$(".ellibot_woocommerce_slider_image_text").css("position","absolute");
		}
		/* Sätter bildens storlek i förhållande till texten */
		else{
			var slideImageWidth = (100-ellibot_woocommerce_slider_global_slide_max_width) + "%";
			$(".ellibot_woocommerce_slider_image").css("width",slideImageWidth);
		}
		
		/* Sätter textens storlek i förhållande till bilden */
		var slideImageText = ellibot_woocommerce_slider_global_slide_max_width + "%";
		$(".ellibot_woocommerce_slider_image_text").css("width",slideImageText);
		
		//Återställer text-innehåll
		$("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).find(".ellibot_woocommerce_slider_image_text_title").css("white-space","normal");
		$("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).find(".ellibot_woocommerce_slider_image_text_desc").css("white-space","normal");
		$("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).find(".ellibot_woocommerce_slider_image_text_desc").css("display","block");
		
		//Sätter placering av text i mitten i höjdled
		var slideTextHeight = $("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).find(".ellibot_woocommerce_slider_image_text").height();
		if(winHeight > slideTextHeight){
			var slideTextPadding = parseInt(parseInt(winHeight-slideTextHeight)/2);
			$("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).find(".ellibot_woocommerce_slider_image_text").css("padding-top",slideTextPadding);
			$("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).find(".ellibot_woocommerce_slider_image_text").css("padding-bottom",slideTextPadding);
		}
		else{
			
			//Om inte texten får plats tvingas beskrivning till enkelrad utan radbrytning
			$("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).find(".ellibot_woocommerce_slider_image_text_desc").css("white-space","nowrap");
			
			var slideTextHeight = $("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).find(".ellibot_woocommerce_slider_image_text").height();
			if(winHeight > slideTextHeight){
				var slideTextPadding = parseInt(parseInt(winHeight-slideTextHeight)/2);
				$("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).find(".ellibot_woocommerce_slider_image_text").css("padding-top",slideTextPadding);
				$("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).find(".ellibot_woocommerce_slider_image_text").css("padding-bottom",slideTextPadding);
			}
			else{
				
				//Om inte texten får plats döljs hela beskrivningen
				$("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).find(".ellibot_woocommerce_slider_image_text_desc").css("display","none");
				
				var slideTextHeight = $("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).find(".ellibot_woocommerce_slider_image_text").height();
				if(winHeight > slideTextHeight){
					var slideTextPadding = parseInt(parseInt(winHeight-slideTextHeight)/2);
					$("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).find(".ellibot_woocommerce_slider_image_text").css("padding-top",slideTextPadding);
					$("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).find(".ellibot_woocommerce_slider_image_text").css("padding-bottom",slideTextPadding);
				}
				else{
					
					//Om inte texten får plats tvingas även titeln till enkelrad utan radbrytning
					$("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).find(".ellibot_woocommerce_slider_image_text_title").css("white-space","nowrap");
					
					var slideTextHeight = $("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).find(".ellibot_woocommerce_slider_image_text").height();
					if(winHeight > slideTextHeight){
						var slideTextPadding = parseInt(parseInt(winHeight-slideTextHeight)/2);
						$("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).find(".ellibot_woocommerce_slider_image_text").css("padding-top",slideTextPadding);
						$("#ellibot_woocommerce_slider_slide_id_"+actual_slide_id).find(".ellibot_woocommerce_slider_image_text").css("padding-bottom",slideTextPadding);
					}
					
				}
				
				
			}
		}
		
	}
	
	
	//PRELOADER
	function ellibot_woocommerce_slider_preloader(resize,action){
		
		if(resize == true){
			if($(".ellibot_woocommerce_slider_content").length){
				var winWidth = $(".ellibot_woocommerce_slider_content").width();
				var winHeight = $(".ellibot_woocommerce_slider_content").height();
			}
			else{
				var winWidth = $(".ellibot_woocommerce_slider_container").width();
				var winHeight = $(".ellibot_woocommerce_slider_container").height();
				if(winHeight <= 0){winHeight = 200;}//En minsta storlek så att loadern får plats
			}
			
			//Ändar storlek på laddar-fönstret
			var loaderWidth = $(".ellibot_woocommerce_slider_loader").outerWidth();
			var loaderHeight = $(".ellibot_woocommerce_slider_loader").outerWidth();
			$(".ellibot_woocommerce_slider_loader").css("left",parseInt(winWidth/2)-parseInt(loaderWidth/2));
			$(".ellibot_woocommerce_slider_loader").css("margin-top",parseInt(winHeight/2)-parseInt(loaderHeight/2));
			$(".ellibot_woocommerce_slider_loader_bg").css("width",winWidth);
			$(".ellibot_woocommerce_slider_loader_bg").css("height",winHeight);
			
		}
		
		if(action == "show"){
			$(".ellibot_woocommerce_slider_loader").animate({"opacity":1}, 1000);
			$(".ellibot_woocommerce_slider_loader_bg").animate({"opacity":1}, 1000);
		}
		if(action == "hide"){
			$(".ellibot_woocommerce_slider_loader").animate({"opacity":0}, 1000, function(){
				$(".ellibot_woocommerce_slider_loader").hide();
			});
			$(".ellibot_woocommerce_slider_loader_bg").animate({"opacity":0}, 1000,function(){
				$(".ellibot_woocommerce_slider_loader_bg").hide();
			});
		}
		
	}
	

	//HÄMTAR/SKICKAR DATA MED AJAX
	function ellibot_woocommerce_slider_do_ajax(action){
		
		if(action == "start"){
			$("body").css("cursor","wait");
		}
		else if(action == "stop"){
			$("body").css("cursor","default");
		}
		
	}
	
	
})