<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/*
Plugin Name: Ellibot WooCommerce Slider
Plugin URI: https://ellibot.com/product/ellibot-woocommerce-slider-pro/
Description: Show your WooCommerce products in a beautiful slider.
Version: 1.0.1
Author: Ellibot
Author URI: https://ellibot.com
Text Domain: ellibot_woocommerce_slider_textdomain
WC requires at least: 3.0.0
WC tested up to: 3.2.0
*/

/*

-------- OM EJ PRO-VERSION ----------

Radera filen: ellibot_engine_pro.php

Avkommentera rad:35
require_once("ellibot_engine_pro.php");

Avkommentera rad 48
$this->ellibot_e->ellibot_e_pro = new ellibot_woocommerce_slider_engine_pro();

*/

//Ellibot Engine
require_once('ellibot_engine.php');

//Ellibot Engine Pro (OBS!!! avkommentera om ej PRO)
//require_once("ellibot_engine_pro.php");


class ellibot_woocommerce_slider{
	
	private $ellibot_e;
	
	public function __construct(){
		
		//Ellibot Engine klass
		$this->ellibot_e = new ellibot_woocommerce_slider_engine();
		
		//Ellibot Engine PRO klass (OBS!!! avkommentera om ej PRO)
		//$this->ellibot_e->ellibot_e_pro = new ellibot_woocommerce_slider_engine_pro();
		
		//Registrerar funktion för att installera/aktivera aktuell plugin
		register_activation_hook( __FILE__, array( $this, 'ellibot_install_plugin' ) );
		
		//Lägger in länken i menyn inställningar
		add_action('admin_menu',array( $this, 'ellibot_add_option_menu'));
		
		//Laddar css, javascript till admin
		add_action('admin_enqueue_scripts',array( $this, 'ellibot_admin_js_css'));
		
		//Laddar css, javascript till utsidan
		add_action('wp_enqueue_scripts',array( $this, 'ellibot_output_js_css'));
		
		//Laddar custom css, javascript till utsidan (i headern)
		//Denna går inte att ropa på här eftersom det finns variabler behövs som sätts i do_shortcode()
		#add_action('wp_head',array( $this, 'ellibot_output_custom_js_css'));
		
		//Aktiverar ajax om inloggad (viktigt att dessa har egna namn efter wp_ajax för att inte krocka)
		add_action('wp_ajax_ellibot_woocommerce_slider', array($this,'ellibot_ajax_calls_backend'));
	
		//Aktiverar ajax på utsidan (viktigt att dessa har egna namn efter wp_ajax för att inte krocka)
		add_action('wp_ajax_nopriv_ellibot_woocommerce_slider', array($this,'ellibot_ajax_calls_frontend'));
		
		//Laddar språkfiler
		add_action('plugins_loaded',array( $this, 'ellibot_textdomain'));
		
		//Shortcode - Visar plugin på utsidan i content via shortcode
		add_shortcode($this->ellibot_e->vars("shortcode"), array($this,'ellibot_shortcode_output'));
		
	}
	
	
	//Installerar/aktiverar plugin
	function ellibot_install_plugin(){
		require_once('ellibot_install.php');
	}
	
	
	//Skapar en länk/länkar till pluginen i admin menyn
	function ellibot_add_option_menu(){
		
		 add_menu_page(
			__($this->ellibot_e->vars("plugin_name"),$this->ellibot_e->vars("lang")),
			__($this->ellibot_e->vars("plugin_short_name"),$this->ellibot_e->vars("lang")),
			$this->ellibot_e->vars("manage_options"),
			$this->ellibot_e->vars("plugin_alias"),
			array($this, 'ellibot_backend'),
			'dashicons-slides',
			56
		);
		
		/*
		add_submenu_page(
			$this->ellibot_e->vars("plugin_alias"), 
			"Extra",
			"Extra",
			$this->ellibot_e->vars("manage_options"),
			$this->ellibot_e->vars("plugin_alias")."_offers",
			array($this, 'ellibot_backend_extra')
		);
		*/
		
	}
	
	
	//Redigera pluginens inställningar i admin
	function ellibot_backend(){
		require_once('ellibot_backend.php');
	}
	
	
	//Javascript och css i admin
	function ellibot_admin_js_css(){
		
		#$ellibot_cache = date("YmdHis");
		$ellibot_cache = "";
		
		//Stilmall att använda i admin
		wp_enqueue_style($this->ellibot_e->vars("plugin_alias")."_css_backend", plugins_url( '/stylesheets/ellibot_backend.css' , __FILE__ ),array(),$ellibot_cache);
		
		//JavaScript att använda i admin
		wp_enqueue_script( $this->ellibot_e->vars("plugin_alias")."_js_backend", plugins_url( '/javascripts/ellibot_backend.js' , __FILE__ ),array(),$ellibot_cache);
	
		//Kopplar Ajax server-fil
		wp_localize_script($this->ellibot_e->vars("plugin_alias")."_js_backend", 'ajax_object', array('ajax_url' => admin_url('admin-ajax.php')));
		
	}
	
	
	//Javascript och css på utsidan
	function ellibot_output_js_css(){
		
		#$ellibot_cache = date("YmdHis");
		$ellibot_cache = "";
		
		//Stilmall att använda på utsidan
		wp_enqueue_style( $this->ellibot_e->vars("plugin_alias")."_css_frontend", plugins_url( '/stylesheets/ellibot_frontend.css' ,__FILE__ ),array(),$ellibot_cache);
		
		//JavaScript att använda på utsidan
		wp_enqueue_script( $this->ellibot_e->vars("plugin_alias")."_js_frontend", plugins_url( '/javascripts/ellibot_frontend.js' ,__FILE__ ),array(),$ellibot_cache,9999);
		
		//Läser in TouchSwipe
		wp_enqueue_script( $this->ellibot_e->vars("plugin_alias")."_js_touchswipe", plugins_url( '/javascripts/TouchSwipe-Jquery-Plugin-master/jquery.touchSwipe.min.js' ,__FILE__ ),array(),$ellibot_cache,9999);
		//Dokumentation: http://labs.rampinteractive.co.uk/touchSwipe/demos/index.html
		
		//Kopplar Ajax server-fil
		wp_localize_script($this->ellibot_e->vars("plugin_alias")."_js_frontend", 'ajax_object', array('ajax_url' => admin_url('admin-ajax.php')));
		
	}
	
	 
	//Ropar på ajax serverfil om inloggad
	function ellibot_ajax_calls_backend() {
		
		//Ifall frontend
		if($this->ellibot_e->ellibot_is_frontend_ajax() == true){
		
			require_once("ellibot_ajax_calls_frontend.php");
			die();
			
		}
		//Ifall backend (admin)
		else{
			require_once("ellibot_ajax_calls_backend.php");
			die();
		}
		
	}
	
	
	//Ropar på ajax serverfil på utsidan
	function ellibot_ajax_calls_frontend() {
		require_once("ellibot_ajax_calls_frontend.php");
		die();
	}
	
	
	//Språkfiler
	function ellibot_textdomain() {
		load_plugin_textdomain(
			$this->ellibot_e->vars("lang")
			,false
			,dirname( plugin_basename( __FILE__ )) . '/languages/'
		);
	}
	
	
	//Shortcode - Visa plugin på utsidan via shortcode
	function ellibot_shortcode_output($atts){
		
		$atts = shortcode_atts(array('settings-id' => null, 'cat-id' => null, 'type' => null, 'orderby' => null, 'order' => null, 'limit' => null, 'pro-id' => null), $atts);
		
		//Skriver ut style och javascript
		$this->ellibot_output_custom_js_css($atts["settings-id"]);
		
		//Skriver ut innehåll som sedan hanteras med AJAX
		$attr = json_encode($atts);
		$content .= "
			<section class='ellibot_woocommerce_slider_container'>
				<div class='ellibot_woocommerce_slider_loader'></div>
				<div class='ellibot_woocommerce_slider_loader_bg'></div>
				<div class='ellibot_woocommerce_slider_container_ajax'></div>
				<div class='ellibot_woocommerce_slider_shortcode_attr'>".$attr."</div>
				<div class='ellibot_woocommerce_slider_ajax_nonce'>".wp_create_nonce("ellibot_woocommerce_slider_ajax_nonce")."</div>
				<div class='ellibot_woocommerce_slider_screen_check_767px'></div>
			</section>
		";
		
		return $content;
		
	}
	
	
	//Custom css på utsidan
	function ellibot_output_custom_js_css($settings_id){
		
		//Hämtar inställningar med rätt inställnings id
		$var_array = $this->ellibot_e->db_vars("var_array",null,$settings_id);
		
		//Hastighet för automatiskt byte av slide (min 2sek, standard 6sek)
		$custom_slide_auto_speed = intval($var_array["custom_slide_auto_speed"]["v"]);
		if($custom_slide_auto_speed == "" OR $custom_slide_auto_speed <= 0){$custom_slide_auto_speed = 6000;}
		else if($custom_slide_auto_speed < 2000){$custom_slide_auto_speed = 2000;}
		
		//Hastighet för slidern att förflytta sig (min 0,3 sek, standard 1 sek)
		$custom_slide_duration = intval($var_array["custom_slide_duration"]["v"]);
		if($custom_slide_duration == "" OR $custom_slide_duration <= 0){$custom_slide_duration = 1000;}
		else if($custom_slide_duration < 300){$custom_slide_duration = 300;}
		
		//Max yta i procent för bild gentemot text i slidern (50% är standard)
		$custom_slide_max_width = intval($var_array["custom_slide_max_width"]["v"]);
		if($custom_slide_max_width == "" OR $custom_slide_max_width < 0 OR $custom_slide_max_width > 100){$custom_slide_max_width = 50;}
		
		//Visa bild i slidern som bakgrundsbild (upptar 100%, text hamnar över)
		$custom_slide_image_asbg = intval($var_array["custom_slide_image_asbg"]["v"]);
		
		//Max antal thumbs att visa samtidigt (10 är standard)
		$custom_thumbs_max_count = intval($var_array["custom_thumbs_max_count"]["v"]);
		if($custom_thumbs_max_count == "" OR $custom_thumbs_max_count < 0 OR $custom_thumbs_max_count > 10){$custom_thumbs_max_count = 10;}
		
		//Visa thumbs från start
		$custom_slide_full_height = intval($var_array["custom_slide_full_height"]["v"]);
		
		//Visa thumbs från start
		$custom_show_thumbs = intval($var_array["custom_show_thumbs"]["v"]);
		
		//Visa knapp för visa/dölj thumbs
		$custom_show_thumbs_btn = intval($var_array["custom_show_thumbs_btn"]["v"]);
		if($custom_show_thumbs_btn <= 0){$custom_show_thumbs_btn = "display:none !important;";}
		
		//Visa navigeringsprickar
		$custom_show_navs = intval($var_array["custom_show_navs"]["v"]);
		if($custom_show_navs <= 0){$custom_show_navs = "display:none !important;";}else{$custom_show_navs = "";}
		
		//Visa pilar/thumbs
		$custom_show_arrows = intval($var_array["custom_show_arrows"]["v"]);
		
		//Margin-left för thumbs
		$custom_thumb_margin = trim($var_array["css_thumbs_box_margin_left"]["v"]);
		if($custom_thumb_margin == ""){$custom_thumbs_margin = "0px";}
		
		//Teckensnitt
		$custom_embed_fonts = trim($var_array["custom_embed_fonts"]["v"]);
		echo $custom_embed_fonts;
		
		//Egen css
		$custom_css_style = trim($var_array["custom_css_style"]["v"]);
		
		echo "
		
		<script type='text/javascript'>
			var ellibot_woocommerce_slider_global_slide_auto_speed = ".$custom_slide_auto_speed.";
			var ellibot_woocommerce_slider_global_slide_duration = ".$custom_slide_duration.";
			var ellibot_woocommerce_slider_global_slide_duration_original = ".$custom_slide_duration.";
			var ellibot_woocommerce_slider_global_slide_max_width = ".$custom_slide_max_width.";
			var ellibot_woocommerce_slider_global_slide_image_asbg = ".$custom_slide_image_asbg.";
			var ellibot_woocommerce_slider_global_slide_full_height = ".$custom_slide_full_height.";
			var ellibot_woocommerce_slider_global_thumbs_max_count = ".$custom_thumbs_max_count.";
			var ellibot_woocommerce_slider_global_thumbs_show = ".$custom_show_thumbs.";
			var ellibot_woocommerce_slider_global_thumbs_arrow_show = ".$custom_show_arrows.";
			var ellibot_woocommerce_slider_global_thumb_margin = '".$custom_thumb_margin."';
		</script>
		
		<style type='text/css'>
			
			.ellibot_woocommerce_slider_loader{	
				border-color:".$var_array["css_preloader_bgcolor1"]["v"]." !important; 
				border-top-color:".$var_array["css_preloader_bgcolor2"]["v"]." !important;
			}
			.ellibot_woocommerce_slider_loader_percent{
				color:".$var_array["css_preloader_color"]["v"]." !important;
			}
			.ellibot_woocommerce_slider_loader_bg{
				background-color:".$var_array["css_preloader_bgcolor"]["v"]." !important;
			}
		   
		    .ellibot_woocommerce_slider_container_ajax{
				width:".$var_array["css_slider_width"]["v"]." !important;
				min-height:".$var_array["css_slider_min_height"]["v"].";
				background-color:".$var_array["css_slider_bgcolor"]["v"]." !important;
				outline-style:".$var_array["css_slider_border_style"]["v"]." !important;
				outline-width:".$var_array["css_slider_border_size"]["v"]." !important;
				outline-color:".$var_array["css_slider_border_color"]["v"]." !important;
			}
			
			.ellibot_woocommerce_slider_content{
				height:".$var_array["css_slider_min_height"]["v"].";
				background-color:".$var_array["css_slider_text_bgcolor"]["v"]." !important;
				outline-style:".$var_array["css_slider_slides_border_style"]["v"]." !important;
				outline-width:".$var_array["css_slider_slides_border_size"]["v"]." !important;
				outline-color:".$var_array["css_slider_slides_border_color"]["v"]." !important;
			}
			
			.ellibot_woocommerce_slider_image{
				background-color:".$var_array["css_slider_image_bgcolor"]["v"]." !important;
				background-size:".$var_array["css_slider_image_bgsize"]["v"]." !important;
				background-position:".$var_array["css_slider_image_bgpos"]["v"]." !important;
			}
			
			.ellibot_woocommerce_slider_image_text{
				font-family:".$var_array["css_slider_text_font"]["v"]." !important;
				background-color:".$var_array["css_slider_text_bgcolor"]["v"]." !important;
			}
			
			.ellibot_woocommerce_slider_image_text_title{
				font-family:".$var_array["css_slider_text_h_font"]["v"]." !important;
				font-size:".$var_array["css_slider_text_h_size"]["v"]." !important;
				color:".$var_array["css_slider_text_h_color"]["v"]." !important;
				font-weight:".$var_array["css_slider_text_h_weight"]["v"]." !important;
				margin-top:".$var_array["css_slider_text_h_margin_top"]["v"]." !important;
				padding-left:".$var_array["css_slider_text_padding_left"]["v"]." !important;
				padding-right:".$var_array["css_slider_text_padding_right"]["v"]." !important;
			}
			
			.ellibot_woocommerce_slider_image_text_desc{
				font-family:".$var_array["css_slider_text_desc_font"]["v"]." !important;
				font-size:".$var_array["css_slider_text_desc_size"]["v"]." !important;
				color:".$var_array["css_slider_text_desc_color"]["v"]." !important;
				font-weight:".$var_array["css_slider_text_desc_weight"]["v"]." !important;
				margin-top:".$var_array["css_slider_text_desc_margin_top"]["v"]." !important;
				padding-left:".$var_array["css_slider_text_padding_left"]["v"]." !important;
				padding-right:".$var_array["css_slider_text_padding_right"]["v"]." !important;
			}
			.ellibot_woocommerce_slider_image_text_desc p{
				
			}
			
			.ellibot_woocommerce_slider_image_text_price{
				margin-top:".$var_array["css_slider_text_pricetext_margin_top"]["v"]." !important;
				font-family:".$var_array["css_slider_text_pricetext_font"]["v"]." !important;
				font-size:".$var_array["css_slider_text_pricetext_size"]["v"]." !important;
				color:".$var_array["css_slider_text_pricetext_color"]["v"]." !important;
				font-weight:".$var_array["css_slider_text_pricetext_weight"]["v"]." !important;
				padding-left:".$var_array["css_slider_text_padding_left"]["v"]." !important;
				padding-right:".$var_array["css_slider_text_padding_right"]["v"]." !important;
			}
			
			.ellibot_woocommerce_slider_image_text_button{
				padding-left:".$var_array["css_slider_text_padding_left"]["v"]." !important;
				padding-right:".$var_array["css_slider_text_padding_right"]["v"]." !important;
			}
			.ellibot_woocommerce_slider_image_text_button a{
				font-family:".$var_array["css_slider_text_button_font"]["v"]." !important;
				font-size:".$var_array["css_slider_text_button_size"]["v"]." !important;
				background-color:".$var_array["css_slider_text_button_bgcolor"]["v"]." !important;
				width:".$var_array["css_slider_text_button_width"]["v"]." !important;
				max-width:".$var_array["css_slider_text_button_max_width"]["v"]." !important;
				padding:".$var_array["css_slider_text_button_padding"]["v"]." !important;
				margin-top:".$var_array["css_slider_text_button_margin_top"]["v"]." !important;
				color:".$var_array["css_slider_text_button_color"]["v"]." !important;
				font-weight:".$var_array["css_slider_text_button_weight"]["v"]." !important;
				border-style:".$var_array["css_slider_text_button_border_style"]["v"]." !important;
				border-width:".$var_array["css_slider_text_button_border_size"]["v"]." !important;
				border-color:".$var_array["css_slider_text_button_border_color"]["v"]." !important;
			}
			
			.ellibot_woocommerce_slider_image_text_button a:hover{
				background-color:".$var_array["css_slider_text_button_bgcolor_hover"]["v"]." !important;
				border-style:".$var_array["css_slider_text_button_border_style_hover"]["v"]." !important;
				border-width:".$var_array["css_slider_text_button_border_size_hover"]["v"]." !important;
				border-color:".$var_array["css_slider_text_button_border_color_hover"]["v"]." !important;
			}
			
			.ellibot_woocommerce_slider_thumbs{
				background-color:".$var_array["css_thumbs_bgcolor"]["v"]." !important;
				outline-style:".$var_array["css_thumbs_border_style"]["v"]." !important;
				outline-width:".$var_array["css_thumbs_border_size"]["v"]." !important;
				outline-color:".$var_array["css_thumbs_border_color"]["v"]." !important;
			}
			
			.ellibot_woocommerce_slider_thumbs_container{
				padding-top:".$var_array["css_thumbs_margin_top"]["v"]." !important;
				padding-bottom:".$var_array["css_thumbs_margin_bottom"]["v"]." !important;
			}
			
			.ellibot_woocommerce_slider_thumbs_arrow_left, .ellibot_woocommerce_slider_thumbs_arrow_right{
				margin-top:".$var_array["css_thumbs_margin_top"]["v"]." !important;
				width:".$var_array["css_thumbs_arrow_width"]["v"]." !important;
				background-color:".$var_array["css_thumbs_arrow_bgcolor"]["v"]." !important;
			}
			
			.ellibot_woocommerce_slider_arrow_left, .ellibot_woocommerce_slider_arrow_right{
				width:".$var_array["css_slide_arrow_width"]["v"]." !important;
				background-color:".$var_array["css_slide_arrow_bgcolor"]["v"]." !important;
			}
			
			.ellibot_woocommerce_slider_thumbs_arrow_left:hover, .ellibot_woocommerce_slider_thumbs_arrow_right:hover{
				background-color:".$var_array["css_thumbs_arrow_bgcolor_hover"]["v"]." !important;
			}
			
			.ellibot_woocommerce_slider_thumb{
				background-color:".$var_array["css_thumbs_box_bgcolor"]["v"]." !important;
				margin-left:".$var_array["css_thumbs_box_margin_left"]["v"]." !important;
				border-style:".$var_array["css_thumbs_box_border_style"]["v"]." !important;
				border-width:".$var_array["css_thumbs_box_border_size"]["v"]." !important;
				border-color:".$var_array["css_thumbs_box_border_color"]["v"]." !important;
			}
			
			.ellibot_woocommerce_slider_thumb:hover{
				background-color:".$var_array["css_thumbs_box_bgcolor_hover"]["v"]." !important;
				border-style:".$var_array["css_thumbs_box_hover_border_style"]["v"]." !important;
				border-width:".$var_array["css_thumbs_box_hover_border_size"]["v"]." !important;
				border-color:".$var_array["css_thumbs_box_hover_border_color"]["v"]." !important;
			}
			
			.ellibot_woocommerce_slider_thumb_image{
				height:".$var_array["css_thumbs_image_height"]["v"]." !important;
				background-color:".$var_array["css_thumbs_image_bgcolor"]["v"]." !important;
				background-size:".$var_array["css_thumbs_image_bgsize"]["v"]." !important;
				background-position:".$var_array["css_thumbs_image_bgpos"]["v"]." !important;
			}
			
			.ellibot_woocommerce_slider_thumb_text{
				font-family:".$var_array["css_thumbs_text_font"]["v"]." !important;
				margin-top:".$var_array["css_thumbs_text_margin_top"]["v"]." !important;
				margin-bottom:".$var_array["css_thumbs_text_margin_bottom"]["v"]." !important;
			}
			
			.ellibot_woocommerce_slider_thumb_title{
				font-family:".$var_array["css_thumbs_text_h_font"]["v"]." !important;
				font-size:".$var_array["css_thumbs_text_h_size"]["v"]." !important;
				font-weight:".$var_array["css_thumbs_text_h_weight"]["v"]." !important;
				color:".$var_array["css_thumbs_text_h_color"]["v"]." !important;
			}
			
			.ellibot_woocommerce_slider_thumb_price{
				font-family:".$var_array["css_thumbs_text_pricetext_font"]["v"]." !important;
				font-size:".$var_array["css_thumbs_text_pricetext_size"]["v"]." !important;
				font-weight:".$var_array["css_thumbs_text_pricetext_weight"]["v"]." !important;
				margin-top:".$var_array["css_thumbs_text_pricetext_margin_top"]["v"]." !important;
				color:".$var_array["css_thumbs_text_pricetext_color"]["v"]." !important;
			}
			
			.ellibot_woocommerce_slider_navs{
				margin-top:".$var_array["css_nav_margin_top"]["v"]." !important;
				width:".$var_array["css_slider_width"]["v"]." !important;
			}
			
			.ellibot_woocommerce_slider_nav{
				".$custom_show_navs."
				background-color:".$var_array["css_nav_bgcolor"]["v"]." !important;
				width:".$var_array["css_nav_width"]["v"]." !important;
				height:".$var_array["css_nav_height"]["v"]." !important;
				margin-left:".$var_array["css_nav_margin_left"]["v"]." !important;
				margin-right:".$var_array["css_nav_margin_right"]["v"]." !important;
				outline-style:".$var_array["css_nav_border_style"]["v"]." !important;
				outline-width:".$var_array["css_nav_border_size"]["v"]." !important;
				outline-color:".$var_array["css_nav_border_color"]["v"]." !important;
			}
			.ellibot_woocommerce_slider_nav:hover{
				background-color:".$var_array["css_nav_bgcolor_hover"]["v"]." !important;
				outline-style:".$var_array["css_nav_hover_border_style"]["v"]." !important;
				outline-width:".$var_array["css_nav_hover_border_size"]["v"]." !important;
				outline-color:".$var_array["css_nav_hover_border_color"]["v"]." !important;
			}
			
			.ellibot_woocommerce_slider_nav_active, .ellibot_woocommerce_slider_nav_active:hover{
				background-color:".$var_array["css_nav_active_bgcolor"]["v"]." !important;
				outline-style:".$var_array["css_nav_active_border_style"]["v"]." !important;
				outline-width:".$var_array["css_nav_active_border_size"]["v"]." !important;
				outline-color:".$var_array["css_nav_active_border_color"]["v"]." !important;
			}
			
			.ellibot_woocommerce_slider_btn_handle_thumbs{
				".$custom_show_thumbs_btn."
				font-family:".$var_array["css_nav_thumbs_btn_font"]["v"]." !important;
				font-size:".$var_array["css_nav_thumbs_btn_size"]["v"]." !important;
				font-weight:".$var_array["css_nav_thumbs_btn_weight"]["v"]." !important;
				margin-left:".$var_array["css_nav_thumbs_btn_margin_left"]["v"]." !important;
				color:".$var_array["css_nav_thumbs_btn_color"]["v"]." !important;
			}
			.ellibot_woocommerce_slider_btn_handle_thumbs:hover{
				color:".$var_array["css_nav_thumbs_btn_color_hover"]["v"]." !important;
			}
			
			@media(max-width : 767px){
				
				.ellibot_woocommerce_slider_screen_check_767px{
					display: block !important;
				}
				
				.ellibot_woocommerce_slider_container_ajax{
					min-height:auto !important;
					max-width:100% !important;
					min-width:100% !important;
					height:auto !important;
				}
				
				.ellibot_woocommerce_slider_content{
					border: none !important;
					background-color:".$var_array["css_slider_text_mobile_bgcolor"]["v"]." !important;
				}
				
				.ellibot_woocommerce_slider_image{
					display:block !important;
					width:100% !important;
					background-position:center top !important;
					background-size:contain !important;
				}
				
				.ellibot_woocommerce_slider_image img{
					width:100% !important;
					height:auto !important;
				}
				
				.ellibot_woocommerce_slider_image_text{
					display:block !important;
					width:100% !important;
					height:auto !important;
					padding-top:20px !important;
					padding-bottom:20px !important;
					background-color:".$var_array["css_slider_text_mobile_bgcolor"]["v"]." !important;
				}
				.ellibot_woocommerce_slider_image_text_title, .ellibot_woocommerce_slider_image_text_desc, ellibot_woocommerce_slider_image_text_price, .ellibot_woocommerce_slider_image_text_button{
					padding-left:5% !important;
					padding-right:5% !important;
					font-size:100% !important;
				}
				.ellibot_woocommerce_slider_image_text_title{
					font-size:30px !important;
					line-height:40px !important;
					margin-top:0 !important;
				}
				.ellibot_woocommerce_slider_image_text_desc{
					font-size:16px !important;
					margin-top:15px !important;
				}
				.ellibot_woocommerce_slider_image_text_price{
					font-size:30px !important;
					margin-top:15px !important;
				}
				.ellibot_woocommerce_slider_image_text_button a{
					font-size:16px !important;
					width:100% !important;
					max-width:100% !important;
					margin-top:20px !important;
					margin-bottom:10px !important;
				}
				
				.ellibot_woocommerce_slider_thumbs{
					display:none !important;
				}
				
				.ellibot_woocommerce_slider_navs{
					max-width:100% !important;
					min-width:100% !important;
				}
				
				.ellibot_woocommerce_slider_btn_handle_thumbs{
					display:none;
				}
				
				.ellibot_woocommerce_slider_arrow_left, .ellibot_woocommerce_slider_arrow_right{
					display:none;
				}
				
			}
			
			".$custom_css_style."
			
        </style>
		
		";
	}
	
}

//Ellibot Plugin klass
new ellibot_woocommerce_slider();  

?>