<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/*Detta klassnamn måste vara unikt för varje wordpress-plugin och ska sluta på: _engine */
class ellibot_woocommerce_slider_engine{
	
	//Pluginens fasta variabler
	function vars($str){
		
		global $wpdb;
		
		$var["plugin_alias"]							= 	"ellibot_woocommerce_slider";
		$var["shortcode"]								=	"ellibot_wc_slider";
		$var["lang"]									= 	$var["plugin_alias"]."_textdomain";		
		$var["plugin_name"]								= 	"Ellibot WooCommerce Slider";
		$var["plugin_short_name"]						= 	"Ellibot WC Slider";	
		$var["manage_options"]							= 	"publish_posts";
		$var["db_settings_table_name"]					= 	$wpdb->base_prefix.$var["plugin_alias"]."_settings";
		$var["site_id"]									=	1;
		$var["license"]									=	"Free version";
		
		//Hämtar PRO-variabler
		if($this->ellibot_e_pro){$var = $this->ellibot_e_pro->vars($var);}
		
		if(isset($str) AND $str == "var_array"){return($var);}
		else if(isset($var[$str])){return($var[$str]);}
		else{echo(__("This variable is not set",$var["lang"])." [{$str}]");}
		
	}
	
	
	//Hämtar angivet shortcode attribut (går enbart att göra via ellibot_ajax_calls_frontend.php)
	function attr($attr){
		$shortcode_attr_arr = array();
		$shortcode_attr_arr = json_decode(stripslashes($_POST['shortcode_attr']),true);
		if(count($shortcode_attr_arr) > 0){
			if(isset($shortcode_attr_arr[$attr]) and sanitize_text_field($shortcode_attr_arr[$attr]) != ""){
				return sanitize_text_field($shortcode_attr_arr[$attr]);
			}
		}
	}
	
	
	//Pluginens föränderliga variabler
	//Denna funktionen bör bara hämtas en gång eftersom den innehåller databasanrop, sätt str till "var_array" om ett settings_id anges dvs;
	function db_vars($str,$type=null,$settings_id=null){
	
		global $wpdb;
		$lang = $this->vars("lang");
	
		//OBS! Färg måste anges med 6 tecken för att typ='color' ska fungera!
		//Värden som inte har ett ['n'] kommer inte att visas i redigeringsläget och inte heller sparas i databasen
		//Css: style border måste namnges med ordet "border_style" i sig
		//Css: style background-color måste namnges med ordet "bgcolor" i sig
		
		//Hämtar PRO-fält
		if($this->ellibot_e_pro){$var = $this->ellibot_e_pro->db_vars($var,$lang);}
		
		//Hämtar övriga fält
		
		//Avsnitt
		$var["section_settings"]['s']						=	__("General settings",$lang);
	
		//Inställningarnas namn
		$var['custom_slide_settings_name']['v']				=	__("New slider settings",$lang);
		$var['custom_slide_settings_name']['n']				=	__("Slider settings name",$lang);
	
		//Hastighet för automatiskt byte av slide
		$var["custom_slide_auto_speed"]['v']				=	6000;
		$var['custom_slide_auto_speed']['n']				=	__("Time before change of slide (min 2000ms, max 10000ms)",$lang);
		$var['custom_slide_auto_speed']['tn']				=	"2000,10000";
		
		//Hastighet för slidern att förflytta sig
		$var["custom_slide_duration"]['v']					=	1000;
		$var['custom_slide_duration']['n']					=	__("Speed ​​to change slide (min 300ms, max 10000ms)",$lang);
		$var['custom_slide_duration']['tn']					=	"300,10000";
	
		//Rubrik
		$var["section_custom_slider"]['h']					=	__("Slider",$lang);
	
		//Visa produktnamn
		$var['custom_show_proname']['v']					= 	1;
		$var['custom_show_proname']['n']					=	__("Show product name in slider",$lang);
		$var['custom_show_proname']['ts']					=	array(0 => __("No",$lang), 1 => __("Yes",$lang));
	
		//Visa pris
		$var['custom_show_price']['v']						= 	1;
		$var['custom_show_price']['n']						=	__("Show price in slider",$lang);
		$var['custom_show_price']['ts']						=	array(0 => __("No",$lang), 1 => __("Yes",$lang));
		
		//Visa knapp
		$var['custom_show_button']['v']						= 	1;
		$var['custom_show_button']['n']						=	__("Show \"Read more\" button in slider",$lang);
		$var['custom_show_button']['ts']						=	array(0 => __("No",$lang), 1 => __("Yes",$lang));
	
		//Visa ingress/beskrivning
		$var['custom_show_desc']['v']						= 	1;
		$var['custom_show_desc']['n']						=	__("Show excerpt text in slider",$lang);
		$var['custom_show_desc']['ts']						=	array(0 => __("No",$lang), 1 => __("Yes",$lang));
	
		//tillåt html i excerpt
		$var['custom_allow_html_desc']['v']					= 	0;
		$var['custom_allow_html_desc']['n']					=	__("Allow HTML in excerpt text",$lang);
		$var['custom_allow_html_desc']['ts']				=	array(0 => __("No",$lang), 1 => __("Yes",$lang));
	
		//Låt slidern uppta hela fönstrets höjd
		$var['custom_slide_full_height']['v']				= 	0;
		$var['custom_slide_full_height']['n']				=	__("Full window-height slider (overrides Slider container style height)",$lang);
		$var['custom_slide_full_height']['ts']				=	array(0 => __("No",$lang), 1 => __("Yes",$lang));
	
		$var['custom_image_size']['v']						= 	"shop_single";
		$var['custom_image_size']['n']						=	__("Image size",$lang);
		$var['custom_image_size']['ts']						=	array("full" => "Full", "large" => "Large", "medium" => "Medium", "thumbnail" => "Thumbnail", "shop_thumbnail" => "Shop Thumbnail", "shop_catalog" => "Shop Catalog", "shop_single" => "Shop Single");
	
		//Max yta (%) upptagande av yta för bild gentemot text
		$var['custom_slide_max_width']['v']					=	50;
		$var['custom_slide_max_width']['n']					=	__("The width of the slider text relative to the image in %",$lang);
		$var['custom_slide_max_width']['tn']				=	"0,100";
	
		//Använd bilden som bakgrund
		$var['custom_slide_image_asbg']['v']				= 	0;
		$var['custom_slide_image_asbg']['n']				=	__("Use slide image as a background-image",$lang);
		$var['custom_slide_image_asbg']['ts']				=	array(0 => __("No",$lang), 1 => __("Yes",$lang));
	
		//Använd samma url på alla knappar
		$var['custom_slide_button_url']['v']				=	"";
		$var['custom_slide_button_url']['n']				=	__("Url - Use the same url on all product \"Read more\" buttons (leave blank for no)",$lang);
	
		//Rubrik
		$var["section_custom_thumbnails"]['h']				=	__("Thumbnails",$lang);
	
		//Visa thumbs från start
		$var['custom_show_thumbs']['v']						= 	1;
		$var['custom_show_thumbs']['n']						=	__("Show thumbnails from start",$lang);
		$var['custom_show_thumbs']['ts']					=	array(0 => __("No",$lang), 1 => __("Yes",$lang));
		
		//Max antal thumbs att visa samtidigt (Lämna tomt eller 0 för obegränsat, max 10)
		$var['custom_thumbs_max_count']['v']				=	10;
		$var['custom_thumbs_max_count']['n']				=	__("Max number of thumbs to show at the same time (restricted by slider size)",$lang);
		$var['custom_thumbs_max_count']['tn']				=	"1,10";
	
		//Göm/visa pilar
		$var['custom_show_arrows']['v']						=	1;
		$var['custom_show_arrows']['n']						=	__("Show navigation arrows",$lang);
		$var['custom_show_arrows']['ts']					=	array(0 => __("No",$lang), 1 => __("Yes",$lang));
	
		//Rubrik
		$var["section_custom_nav"]['h']						=	__("Navigation",$lang);
	
		//Visa knapp för visa/dölj thumbs
		$var['custom_show_thumbs_btn']['v']					=	1;
		$var['custom_show_thumbs_btn']['n']						=	__("Show button to show/hide thumbnails",$lang);
		$var['custom_show_thumbs_btn']['ts']					=	array(0 => __("No",$lang), 1 => __("Yes",$lang));
		
		//Visa navigeringsprickar
		$var['custom_show_navs']['v']						=	1;
		$var['custom_show_navs']['n']						=	__("Show navigation dots",$lang);
		$var['custom_show_navs']['ts']						=	array(0 => __("No",$lang), 1 => __("Yes",$lang));
	
		//Rubrik
		$var["section_custom_translations"]['h']			=	__("Translations",$lang);
		
		//Översättningar
		$var['translate_btn_thumbnails_show']['v']			=	"";
		$var['translate_btn_thumbnails_show']['n']			=	__("Text, \"Show\" thumbnail-content (leave blank to display default value)",$lang);
		
		$var['translate_btn_thumbnails_hide']['v']			=	"";
		$var['translate_btn_thumbnails_hide']['n']			=	__("Text, \"Hide\" thumbnail-content (leave blank to display default value)",$lang);
		
		$var['translate_btn_slider']['v']					=	"";
		$var['translate_btn_slider']['n']					=	__("Text, \"Read more\" slide button (leave blank to display default value)",$lang);
	
		//Rubrik
		$var["section_custom_embed"]['h']					=	__("Embed",$lang);
	
		//Inbäddade teckensnitt
		$var['custom_embed_fonts']['v']						=	"";
		$var['custom_embed_fonts']['n']						=	__("Embedded fonts",$lang);
		$var['custom_embed_fonts']['tt']					=	true;
		
		//Inbäddad stilmall
		$var['custom_css_style']['v']						=	"";
		$var['custom_css_style']['n']						=	__("Embedded CSS-style",$lang);
		$var['custom_css_style']['tt']						=	true;
	
	
		/* CSS */
	
	
		//Avsnitt
		$var["section_css_preloader"]['s']					=	__("Preloader style",$lang);
	
		//css - Preloader
		$var['css_preloader_bgcolor']['v']					= 	"#efefef";
		$var['css_preloader_bgcolor']['n']					=	__("Background-color",$lang);
		$var['css_preloader_bgcolor']['tc']					=	true;
		
		$var['css_preloader_bgcolor1']['v']					= 	"#fafafa";
		$var['css_preloader_bgcolor1']['n']					=	__("Color (circle)",$lang);
		$var['css_preloader_bgcolor1']['tc']				=	true;
		
		$var['css_preloader_bgcolor2']['v']					= 	"#dddddd";
		$var['css_preloader_bgcolor2']['n']					=	__("Color (animation)",$lang);
		$var['css_preloader_bgcolor2']['tc']				=	true;
		
		$var['css_preloader_color']['v']					= 	"#ccc";
		$var['css_preloader_color']['n']					=	__("Font-color",$lang);
		$var['css_preloader_color']['tc']					=	true;
		
	
	
		//Avsnitt
		$var["section_css_slider"]['s']						=	__("Slider container style",$lang);
	
		//css - Sliderns behållare
		$var['css_slider_bgcolor']['v']						= 	"#ffffff";
		$var['css_slider_bgcolor']['n']						=	__("Background-color",$lang);
		$var['css_slider_bgcolor']['tc']					=	true;
		
		$var['css_slider_width']['v']						= 	"100%";
		$var['css_slider_width']['n']						=	__("Width",$lang);
		
		$var['css_slider_min_height']['v']					= 	"400px";
		$var['css_slider_min_height']['n']					=	__("Height",$lang);
		
		$var['css_slider_border_style']['v']				= 	"solid";
		$var['css_slider_border_style']['n']				=	__("Border-style",$lang);
		$var['css_slider_border_style']['ts']				=	array("none"=>"none","hidden"=>"hidden","dotted"=>"dotted","dashed"=>"dashed","solid"=>"solid","double"=>"double","groove"=>"groove","ridge"=>"ridge","inset"=>"inset","outset"=>"outset","initial"=>"initial","inherit"=>"inherit");
		
		$var['css_slider_border_size']['v']					= 	"1px";
		$var['css_slider_border_size']['n']					=	__("Border-size",$lang);
		
		$var['css_slider_border_color']['v']				= 	"#eee";
		$var['css_slider_border_color']['n']				=	__("Border-color",$lang);
		$var['css_slider_border_color']['tc']				=	true;
		
		
		
		//Avsnitt
		$var["section_css_slide"]['s']						=	__("Slide style",$lang);
		
		//css - Sliders
		$var['css_slider_slides_border_style']['v']			= 	"none";
		$var['css_slider_slides_border_style']['n']			=	__("Border-style",$lang);
		$var['css_slider_slides_border_style']['ts']		=	array("none"=>"none","hidden"=>"hidden","dotted"=>"dotted","dashed"=>"dashed","solid"=>"solid","double"=>"double","groove"=>"groove","ridge"=>"ridge","inset"=>"inset","outset"=>"outset","initial"=>"initial","inherit"=>"inherit");
		
		$var['css_slider_slides_border_size']['v']			= 	"";
		$var['css_slider_slides_border_size']['n']			=	__("Border-size",$lang);
		
		$var['css_slider_slides_border_color']['v']			= 	"";
		$var['css_slider_slides_border_color']['n']			=	__("Border-color",$lang);
		$var['css_slider_slides_border_color']['tc']		=	true;
		
		//Rubrik
		$var["section_css_slide_arrows"]['h']				=	__("Slide arrows",$lang);
		
		//css - thumbnails pilar
		$var['css_slide_arrow_width']['v']					=	"80px";
		$var['css_slide_arrow_width']['n']					=	__("Width",$lang);
		
		$var['css_slide_arrow_bgcolor']['v']				=	"transparent";
		$var['css_slide_arrow_bgcolor']['n']				=	__("Background-color",$lang);
		$var['css_slide_arrow_bgcolor']['tc']				=	true;
		
		//Rubrik
		$var["section_css_slide_image"]['h']				=	__("Slide image",$lang);
		
		//css - Bild i slider 
		$var['css_slider_image_bgcolor']['v']				= 	"#ffffff";
		$var['css_slider_image_bgcolor']['n']				=	__("Background-color",$lang);
		$var['css_slider_image_bgcolor']['tc']				=	true;
		
		$var['css_slider_image_bgsize']['v']				= 	"cover";		//cover
		$var['css_slider_image_bgsize']['n']				=	__("Background-size",$lang);
		$var['css_slider_image_bgsize']['ts']				=	array("auto"=>"auto","cover"=>"cover","contain"=>"contain","initial"=>"initial","inherit"=>"inherit");
		
		$var['css_slider_image_bgpos']['v']					= 	"center center";	//center center
		$var['css_slider_image_bgpos']['n']					=	__("Background-position",$lang);
		
		//Rubrik
		$var["section_css_slide_text"]['h']					=	__("Slide text",$lang);
		
		//css - Text i slider
		$var['css_slider_text_bgcolor']['v']				= 	"#efefef";
		$var['css_slider_text_bgcolor']['n']				=	__("Background-color",$lang);
		$var['css_slider_text_bgcolor']['tc']				=	true;
		
		$var['css_slider_text_mobile_bgcolor']['v']			= 	"#efefef";
		$var['css_slider_text_mobile_bgcolor']['n']			=	__("Background-color (small screen)",$lang);
		$var['css_slider_text_mobile_bgcolor']['tc']		=	true;
		
		$var['css_slider_text_font']['v']					=	"";
		$var['css_slider_text_font']['n']					=	__("Font-family",$lang);
		
		$var['css_slider_text_padding_left']['v']			=	"5%";
		$var['css_slider_text_padding_left']['n']			=	__("Padding-left",$lang);
		
		$var['css_slider_text_padding_right']['v']			=	"5%";
		$var['css_slider_text_padding_right']['n']			=	__("Padding-right",$lang);
		
		//Rubrik
		$var["section_css_slide_text_headline"]['h']		=	__("Slide text headline",$lang);
		
		//css slider - rubrik
		$var['css_slider_text_h_font']['v']					=	"";
		$var['css_slider_text_h_font']['n']					=	__("Font-family",$lang);
		
		$var['css_slider_text_h_size']['v']					= 	"31px";
		$var['css_slider_text_h_size']['n']					=	__("Font-size",$lang);
		
		$var['css_slider_text_h_color']['v']				= 	"#666666";
		$var['css_slider_text_h_color']['n']				=	__("Font-color",$lang);
		$var['css_slider_text_h_color']['tc']				=	true;
		
		$var['css_slider_text_h_weight']['v']				= 	"bold";
		$var['css_slider_text_h_weight']['n']				=	__("Font-weight",$lang);
		$var['css_slider_text_h_weight']['ts']				=	array("normal" => "normal", "bold" => "bold", "bolder" => "bolder", "lighter" => "lighter");
		
		$var['css_slider_text_h_margin_top']['v']			= 	"10px";
		$var['css_slider_text_h_margin_top']['n']			=	__("Margin-top",$lang);
		
		//Rubrik
		$var["section_css_slide_text_excerpt"]['h']			=	__("Slide excerpt",$lang);
		
		//css slider - beskrivning
		$var['css_slider_text_desc_font']['v']				=	"";
		$var['css_slider_text_desc_font']['n']				=	__("Font-family",$lang);
		
		$var['css_slider_text_desc_size']['v']				= 	"16px";
		$var['css_slider_text_desc_size']['n']				=	__("Font-size",$lang);
		
		$var['css_slider_text_desc_color']['v']				= 	"#333333";
		$var['css_slider_text_desc_color']['n']				=	__("Font-color",$lang);
		$var['css_slider_text_desc_color']['tc']			=	true;
		
		$var['css_slider_text_desc_weight']['v']			= 	"normal";
		$var['css_slider_text_desc_weight']['n']			=	__("Font-weight",$lang);
		$var['css_slider_text_desc_weight']['ts']			=	array("normal" => "normal", "bold" => "bold", "bolder" => "bolder", "lighter" => "lighter");
		
		$var['css_slider_text_desc_margin_top']['v']		= 	"10px";
		$var['css_slider_text_desc_margin_top']['n']		=	__("Margin-top",$lang);
		
		//Rubrik
		$var["section_css_slide_text_pricetext"]['h']		=	__("Slide price",$lang);
		
		//css - slider (pris + inkl.moms)
		$var['css_slider_text_pricetext_font']['v']			=	"";
		$var['css_slider_text_pricetext_font']['n']			=	__("Font-family",$lang);
		
		$var['css_slider_text_pricetext_size']['v']			= 	"41px";
		$var['css_slider_text_pricetext_size']['n']			=	__("Font-size",$lang);
		
		$var['css_slider_text_pricetext_color']['v']		= 	"#ff3333";
		$var['css_slider_text_pricetext_color']['n']		=	__("Font-color",$lang);
		$var['css_slider_text_pricetext_color']['tc']		=	true;
		
		$var['css_slider_text_pricetext_weight']['v']		= 	"bold";
		$var['css_slider_text_pricetext_weight']['n']		=	__("Font-weight",$lang);
		$var['css_slider_text_pricetext_weight']['ts']		=	array("normal" => "normal", "bold" => "bold", "bolder" => "bolder", "lighter" => "lighter");
		
		$var['css_slider_text_pricetext_margin_top']['v']	= 	"10px";
		$var['css_slider_text_pricetext_margin_top']['n']	=	__("Margin-top",$lang);
		
		//Rubrik
		$var["section_css_slide_text_button"]['h']			=	__("Slide button",$lang);
		
		//css - slider knapp
		$var['css_slider_text_button_font']['v']			=	"";
		$var['css_slider_text_button_font']['n']			=	__("Font-family",$lang);
		
		$var['css_slider_text_button_size']['v']			= 	"21px";
		$var['css_slider_text_button_size']['n']			=	__("Font-size",$lang);
		
		$var['css_slider_text_button_color']['v']			= 	"#ffffff";
		$var['css_slider_text_button_color']['n']			=	__("Font-color",$lang);
		$var['css_slider_text_button_color']['tc']			=	true;
		
		$var['css_slider_text_button_bgcolor']['v']			= 	"#cc0000";
		$var['css_slider_text_button_bgcolor']['n']			=	__("Background-color",$lang);
		$var['css_slider_text_button_bgcolor']['tc']		=	true;
		
		$var['css_slider_text_button_bgcolor_hover']['v']	= 	"#990000";
		$var['css_slider_text_button_bgcolor_hover']['n']	=	__("Background-color (hover)",$lang);
		$var['css_slider_text_button_bgcolor_hover']['tc']	=	true;
		
		$var['css_slider_text_button_border_style']['v']		= 	"none";
		$var['css_slider_text_button_border_style']['n']		=	__("Border-style",$lang);
		$var['css_slider_text_button_border_style']['ts']		=	array("none"=>"none","hidden"=>"hidden","dotted"=>"dotted","dashed"=>"dashed","solid"=>"solid","double"=>"double","groove"=>"groove","ridge"=>"ridge","inset"=>"inset","outset"=>"outset","initial"=>"initial","inherit"=>"inherit");
		
		$var['css_slider_text_button_border_size']['v']			= 	"";
		$var['css_slider_text_button_border_size']['n']			=	__("Border-size",$lang);
		
		$var['css_slider_text_button_border_color']['v']		= 	"";
		$var['css_slider_text_button_border_color']['n']		=	__("Border-color",$lang);
		$var['css_slider_text_button_border_color']['tc']		=	true;
		
		$var['css_slider_text_button_border_style_hover']['v']	= 	"none";
		$var['css_slider_text_button_border_style_hover']['n']	=	__("Border-style (hover)",$lang);
		$var['css_slider_text_button_border_style_hover']['ts']	=	array("none"=>"none","hidden"=>"hidden","dotted"=>"dotted","dashed"=>"dashed","solid"=>"solid","double"=>"double","groove"=>"groove","ridge"=>"ridge","inset"=>"inset","outset"=>"outset","initial"=>"initial","inherit"=>"inherit");
		
		$var['css_slider_text_button_border_size_hover']['v']	= 	"";
		$var['css_slider_text_button_border_size_hover']['n']	=	__("Border-size (hover)",$lang);
		
		$var['css_slider_text_button_border_color_hover']['v']	= 	"";
		$var['css_slider_text_button_border_color_hover']['n']	=	__("Border-color (hover)",$lang);
		$var['css_slider_text_button_border_color_hover']['tc']	=	true;
		
		$var['css_slider_text_button_weight']['v']			= 	"normal";
		$var['css_slider_text_button_weight']['n']			=	__("Font-weight",$lang);
		$var['css_slider_text_button_weight']['ts']			=	array("normal" => "normal", "bold" => "bold", "bolder" => "bolder", "lighter" => "lighter");
		
		$var['css_slider_text_button_margin_top']['v']		= 	"20px";
		$var['css_slider_text_button_margin_top']['n']		=	__("Margin-top",$lang);
		
		$var['css_slider_text_button_padding']['v']			= 	"10px";
		$var['css_slider_text_button_padding']['n']			=	__("Padding",$lang);
		
		$var['css_slider_text_button_width']['v']			= 	"100%";
		$var['css_slider_text_button_width']['n']			=	__("Width",$lang);
		
		$var['css_slider_text_button_max_width']['v']		= 	"130px";
		$var['css_slider_text_button_max_width']['n']		=	__("Max-width",$lang);
		
		
		
		//Avsnitt
		$var["section_css_thumbs"]['s']						=	__("Thumbnails style",$lang);
		
		//css - thumbnails
		$var['css_thumbs_margin_top']['v']					=	"30px";
		$var['css_thumbs_margin_top']['n']					=	__("Margin-top",$lang);
		
		$var['css_thumbs_margin_bottom']['v']				=	"30px";
		$var['css_thumbs_margin_bottom']['n']				=	__("Margin-bottom",$lang);
		
		$var['css_thumbs_bgcolor']['v']						=	"transparent";
		$var['css_thumbs_bgcolor']['n']						=	__("Background-color",$lang);
		$var['css_thumbs_bgcolor']['tc']					=	true;
		
		$var['css_thumbs_border_style']['v']				= 	"none";
		$var['css_thumbs_border_style']['n']				=	__("Border-style",$lang);
		$var['css_thumbs_border_style']['ts']				=	array("none"=>"none","hidden"=>"hidden","dotted"=>"dotted","dashed"=>"dashed","solid"=>"solid","double"=>"double","groove"=>"groove","ridge"=>"ridge","inset"=>"inset","outset"=>"outset","initial"=>"initial","inherit"=>"inherit");
		
		$var['css_thumbs_border_size']['v']					= 	"";
		$var['css_thumbs_border_size']['n']					=	__("Border-size",$lang);
		
		$var['css_thumbs_border_color']['v']				= 	"";
		$var['css_thumbs_border_color']['n']				=	__("Border-color",$lang);
		$var['css_thumbs_border_color']['tc']				=	true;
		
		//Rubrik
		$var["section_css_thumbs_arrows"]['h']				=	__("Thumbnails arrows",$lang);
		
		//css - thumbnails pilar
		$var['css_thumbs_arrow_width']['v']					=	"80px";
		$var['css_thumbs_arrow_width']['n']					=	__("Width",$lang);
		
		$var['css_thumbs_arrow_bgcolor']['v']				=	"#858585";
		$var['css_thumbs_arrow_bgcolor']['n']				=	__("Background-color",$lang);
		$var['css_thumbs_arrow_bgcolor']['tc']				=	true;
		
		$var['css_thumbs_arrow_bgcolor_hover']['v']			=	"#777777";
		$var['css_thumbs_arrow_bgcolor_hover']['n']			=	__("Background-color (hover)",$lang);
		$var['css_thumbs_arrow_bgcolor_hover']['tc']		=	true;
		
		//Rubrik
		$var["section_css_thumbs_content"]['h']				=	__("Thumbnails content",$lang);
		
		$var['css_thumbs_box_margin_left']['v']				= 	"20px";
		$var['css_thumbs_box_margin_left']['n']				=	__("Margin-left",$lang);
		
		//css - thumbnails innehåll
		$var['css_thumbs_box_bgcolor']['v']					= 	"#efefef";
		$var['css_thumbs_box_bgcolor']['n']					=	__("Background-color",$lang);
		$var['css_thumbs_box_bgcolor']['tc']				=	true;
		
		$var['css_thumbs_box_bgcolor_hover']['v']			= 	"#dedede";
		$var['css_thumbs_box_bgcolor_hover']['n']			=	__("Background-color (hover)",$lang);
		$var['css_thumbs_box_bgcolor_hover']['tc']			=	true;
		
		$var['css_thumbs_box_border_style']['v']			= 	"none";
		$var['css_thumbs_box_border_style']['n']			=	__("Border-style",$lang);
		$var['css_thumbs_box_border_style']['ts']			=	array("none"=>"none","hidden"=>"hidden","dotted"=>"dotted","dashed"=>"dashed","solid"=>"solid","double"=>"double","groove"=>"groove","ridge"=>"ridge","inset"=>"inset","outset"=>"outset","initial"=>"initial","inherit"=>"inherit");
		
		$var['css_thumbs_box_border_size']['v']				= 	"";
		$var['css_thumbs_box_border_size']['n']				=	__("Border-size",$lang);
		
		$var['css_thumbs_box_border_color']['v']			= 	"";
		$var['css_thumbs_box_border_color']['n']			=	__("Border-color",$lang);
		$var['css_thumbs_box_border_color']['tc']			=	true;
		
		$var['css_thumbs_box_hover_border_style']['v']		= 	"none";
		$var['css_thumbs_box_hover_border_style']['n']		=	__("Border-style (hover)",$lang);
		$var['css_thumbs_box_hover_border_style']['ts']		=	array("none"=>"none","hidden"=>"hidden","dotted"=>"dotted","dashed"=>"dashed","solid"=>"solid","double"=>"double","groove"=>"groove","ridge"=>"ridge","inset"=>"inset","outset"=>"outset","initial"=>"initial","inherit"=>"inherit");
		
		$var['css_thumbs_box_hover_border_size']['v']		= 	"";
		$var['ccss_thumbs_box_hover_border_size']['n']		=	__("Border-size (hover)",$lang);
		
		$var['css_thumbs_box_hover_border_color']['v']		= 	"";
		$var['css_thumbs_box_hover_border_color']['n']		=	__("Border-color (hover)",$lang);
		$var['css_thumbs_box_hover_border_color']['tc']		=	true;
		
		//Rubrik
		$var["section_css_thumbs_image"]['h']				=	__("Thumbnails image",$lang);
		
		//css - thumbnail bild
		$var['css_thumbs_image_height']['v']				= 	"150px";
		$var['css_thumbs_image_height']['n']				=	__("Height",$lang);
		
		$var['css_thumbs_image_bgcolor']['v']				= 	"#fafafa";
		$var['css_thumbs_image_bgcolor']['n']				=	__("Background-color",$lang);
		$var['css_thumbs_image_bgcolor']['tc']				=	true;
		
		$var['css_thumbs_image_bgsize']['v']				= 	"cover";			//cover
		$var['css_thumbs_image_bgsize']['n']				=	__("Background-size",$lang);
		$var['css_thumbs_image_bgsize']['ts']				=	array("auto"=>"auto","cover"=>"cover","contain"=>"contain","initial"=>"initial","inherit"=>"inherit");
		
		$var['css_thumbs_image_bgpos']['v']					= 	"center center";	//center center
		$var['css_thumbs_image_bgpos']['n']					=	__("Background-position",$lang);
		
		//Rubrik
		$var["section_css_thumbs_text"]['h']				=	__("Thumbnails text",$lang);
		
		//css - thumbnails text
		$var['css_thumbs_text_font']['v']					=	"";
		$var['css_thumbs_text_font']['n']					=	__("Font-family",$lang);
		
		$var['css_thumbs_text_margin_top']['v']				= 	"10px";
		$var['css_thumbs_text_margin_top']['n']				=	__("Margin-top",$lang);
		
		$var['css_thumbs_text_margin_bottom']['v']			= 	"10px";
		$var['css_thumbs_text_margin_bottom']['n']			=	__("Margin-bottom",$lang);
		
		//Rubrik
		$var["section_css_thumbs_headline"]['h']			=	__("Thumbnails headline",$lang);
		
		//css - thumbnails rubrik
		$var['css_thumbs_text_h_font']['v']					=	"";
		$var['css_thumbs_text_h_font']['n']					=	__("Font-family",$lang);
		
		$var['css_thumbs_text_h_size']['v']					= 	"16px";
		$var['css_thumbs_text_h_size']['n']					=	__("Font-size",$lang);
		
		$var['css_thumbs_text_h_color']['v']				= 	"#333333";
		$var['css_thumbs_text_h_color']['n']				=	__("Font-color",$lang);
		$var['css_thumbs_text_h_color']['tc']				=	true;
		
		$var['css_thumbs_text_h_weight']['v']				= 	"normal";
		$var['css_thumbs_text_h_weight']['n']				=	__("Font-weight",$lang);
		$var['css_thumbs_text_h_weight']['ts']				=	array("normal" => "normal", "bold" => "bold", "bolder" => "bolder", "lighter" => "lighter");
		
		//Rubrik
		$var["section_css_thumbs_pricetext"]['h']			=	__("Thumbnails price",$lang);
		
		//css - thumbnails (pris + inkl.moms)
		$var['css_thumbs_text_pricetext_font']['v']			=	"";
		$var['css_thumbs_text_pricetext_font']['n']			=	__("Font-family",$lang);
		
		$var['css_thumbs_text_pricetext_size']['v']			= 	"21px";
		$var['css_thumbs_text_pricetext_size']['n']			=	__("Font-size",$lang);
		
		$var['css_thumbs_text_pricetext_color']['v']		= 	"#ff3333";
		$var['css_thumbs_text_pricetext_color']['n']		=	__("Font-color",$lang);
		$var['css_thumbs_text_pricetext_color']['tc']		=	true;
		
		$var['css_thumbs_text_pricetext_weight']['v']		= 	"normal";
		$var['css_thumbs_text_pricetext_weight']['n']		=	__("Font-weight",$lang);
		$var['css_thumbs_text_pricetext_weight']['ts']		=	array("normal" => "normal", "bold" => "bold", "bolder" => "bolder", "lighter" => "lighter");
		
		$var['css_thumbs_text_pricetext_margin_top']['v']	= 	"";
		$var['css_thumbs_text_pricetext_margin_top']['n']	=	__("Margin-top",$lang);
		
		
		
		//Avsnitt
		$var["section_css_navs"]['s']						=	__("Navigation style",$lang);
		
		$var['css_nav_margin_top']['v']						=	"20px";
		$var['css_nav_margin_top']['n']						=	__("Margin-top",$lang);
		
		//Rubrik
		$var['section_css_nav']['h']						=	__("Navigation dots",$lang);
		
		//css - Navigeringspunkter
		$var['css_nav_margin_left']['v']					=	"0px";
		$var['css_nav_margin_left']['n']					=	__("Margin-left",$lang);
		
		$var['css_nav_margin_right']['v']					=	"0px";
		$var['css_nav_margin_right']['n']					=	__("Margin-right",$lang);
		
		$var['css_nav_width']['v']							=	"20px";
		$var['css_nav_width']['n']							=	__("Width",$lang);
		
		$var['css_nav_height']['v']							=	"20px";
		$var['css_nav_height']['n']							=	__("Height",$lang);
		
		$var['css_nav_bgcolor']['v']						=	"#dddddd";
		$var['css_nav_bgcolor']['n']						=	__("Background-color",$lang);
		$var['css_nav_bgcolor']['tc']						=	true;
		
		$var['css_nav_bgcolor_hover']['v']					=	"#cccccc";
		$var['css_nav_bgcolor_hover']['n']					=	__("Background-color (hover)",$lang);
		$var['css_nav_bgcolor_hover']['tc']					=	true;
		
		$var['css_nav_active_bgcolor']['v']					=	"#ffffff";
		$var['css_nav_active_bgcolor']['n']					=	__("Background-color (active)",$lang);
		$var['css_nav_active_bgcolor']['tc']				=	true;
		
		$var['css_nav_border_style']['v']					= 	"none";
		$var['css_nav_border_style']['n']					=	__("Border-style",$lang);
		$var['css_nav_border_style']['ts']					=	array("none"=>"none","hidden"=>"hidden","dotted"=>"dotted","dashed"=>"dashed","solid"=>"solid","double"=>"double","groove"=>"groove","ridge"=>"ridge","inset"=>"inset","outset"=>"outset","initial"=>"initial","inherit"=>"inherit");
		
		$var['css_nav_border_size']['v']					= 	"";
		$var['css_nav_border_size']['n']					=	__("Border-size",$lang);
		
		$var['css_nav_border_color']['v']					= 	"";
		$var['css_nav_border_color']['n']					=	__("Border-color",$lang);
		$var['css_nav_border_color']['tc']					=	true;
		
		$var['css_nav_hover_border_style']['v']				= 	"none";
		$var['css_nav_hover_border_style']['n']				=	__("Border-style (hover)",$lang);
		$var['css_nav_hover_border_style']['ts']			=	array("none"=>"none","hidden"=>"hidden","dotted"=>"dotted","dashed"=>"dashed","solid"=>"solid","double"=>"double","groove"=>"groove","ridge"=>"ridge","inset"=>"inset","outset"=>"outset","initial"=>"initial","inherit"=>"inherit");
		
		$var['css_nav_hover_border_size']['v']				= 	"";
		$var['css_nav_hover_border_size']['n']				=	__("Border-size (hover)",$lang);
		
		$var['css_nav_hover_border_color']['v']				= 	"";
		$var['css_nav_hover_border_color']['n']				=	__("Border-color (hover)",$lang);
		$var['css_nav_hover_border_color']['tc']			=	true;
		
		$var['css_nav_active_border_style']['v']			= 	"solid";
		$var['css_nav_active_border_style']['n']			=	__("Border-style (active)",$lang);
		$var['css_nav_active_border_style']['ts']			=	array("none"=>"none","hidden"=>"hidden","dotted"=>"dotted","dashed"=>"dashed","solid"=>"solid","double"=>"double","groove"=>"groove","ridge"=>"ridge","inset"=>"inset","outset"=>"outset","initial"=>"initial","inherit"=>"inherit");
		
		$var['css_nav_active_border_size']['v']				= 	"1px";
		$var['css_nav_active_border_size']['n']				=	__("Border-size (active)",$lang);
		
		$var['css_nav_active_border_color']['v']			= 	"#ddd";
		$var['css_nav_active_border_color']['n']			=	__("Border-color (active)",$lang);
		$var['css_nav_active_border_color']['tc']			=	true;
		
		//Rubrik
		$var["section_css_navs_thumbs_btn"]['h']			=	__("Navigation text \"show/hide\" thumbnails",$lang);
		
		//css - Thumbnails visa/dölj knapp
		$var['css_nav_thumbs_btn_font']['v']				=	"";
		$var['css_nav_thumbs_btn_font']['n']				=	__("Font-family",$lang);
		
		$var['css_nav_thumbs_btn_margin_left']['v']			=	"10px";
		$var['css_nav_thumbs_btn_margin_left']['n']			=	__("Margin-left",$lang);
		
		$var['css_nav_thumbs_btn_color']['v']				=	"#cccccc";
		$var['css_nav_thumbs_btn_color']['n']				=	__("Font-color",$lang);
		$var['css_nav_thumbs_btn_color']['tc']				=	true;
		
		$var['css_nav_thumbs_btn_color_hover']['v']			=	"#bbbbbb";
		$var['css_nav_thumbs_btn_color_hover']['n']			=	__("Font-color (hover)",$lang);
		$var['css_nav_thumbs_btn_color_hover']['tc']		=	true;
		
		$var['css_nav_thumbs_btn_size']['v']				=	"16px";
		$var['css_nav_thumbs_btn_size']['n']				=	__("Font-size",$lang);
		
		$var['css_nav_thumbs_btn_weight']['v']				=	"normal";
		$var['css_nav_thumbs_btn_weight']['n']				=	__("Font-weight",$lang);
		$var['css_nav_thumbs_btn_weight']['ts']				=	array("normal" => "normal", "bold" => "bold", "bolder" => "bolder", "lighter" => "lighter");
		
		
		//Hämtar bara värden från databasen ifall ett settings_id är angett
		if(isset($settings_id) AND $settings_id > 0){
		
			$site_id = $this->vars("site_id");
			$db_settings_table_name = $this->vars("db_settings_table_name");
		
			//Hämtar ut värden från databasen (skriver över alla fasta variabla värden, även pro)
			$sql = "SELECT * FROM $db_settings_table_name WHERE site_id = $site_id AND settings_id = $settings_id";
			$dbResult = $wpdb->get_results($sql);
			foreach($dbResult as $db){$var[$db->slug]['v'] = $db->val;}
			
			//Lägger till och visar id intill inställningsnamnet i formuläret
			if(count($dbResult) > 0){
				$var['custom_slide_settings_name']['n'] .= " | settings-id:".$settings_id;
			}
		
		}
		
		
		//Hämtar hela arrayen
		if(isset($str) AND $str == "var_array"){
			return($var);
		}
		//Hämtar ut enskilt värde från array (bör ej användas eftersom databasanrop görs vid varje hämtning)
		else if(isset($type)){
			return $var[$str][$type];
		}
		//Om inget är satt hämtas första värdet 
		else if(isset($var[$str])){
			return $var[$str]['v'];
		}
		else{echo(__("This variable is not set",$var["lang"])." [{$str}]");}
		
	}
	
	
	//Kontrollerar behörighet
	function ellibot_capability($capability){
		if(!current_user_can($this->vars($capability))){
			wp_die($this->ellibot_message(
				__("You are not authorized",$this->vars("lang")) .
				" - capability: '" . $this->vars("manage_options") . "' required.",
				null
			));
		}
	}
	
	
	//Plugin-data (exempelvis version)
	function ellibot_plugin_data($arg){
		$plugin_data = get_plugin_data(plugin_dir_path(__FILE__)."ellibot_index.php");
		return $plugin_data[$arg];
	}
	
	
	//Kontrollerar ifall man befinner sig i admin eller inte (används av AJAX)
	function ellibot_is_frontend_ajax(){
		
		$script_filename = isset($_SERVER['SCRIPT_FILENAME']) ? $_SERVER['SCRIPT_FILENAME'] : '';

		if((defined('DOING_AJAX') && DOING_AJAX)){
			
			$ref = '';
			if ( ! empty( $_REQUEST['_wp_http_referer'] ) )
			$ref = wp_unslash( $_REQUEST['_wp_http_referer'] );
			elseif ( ! empty( $_SERVER['HTTP_REFERER'] ) )
			$ref = wp_unslash( $_SERVER['HTTP_REFERER'] );

			if(((strpos($ref, admin_url()) === false) && (basename($script_filename) === 'admin-ajax.php')))
			return true;
		}

		return false;
		
	}

}
	
?>