<?php
	
	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
	
	//Kontrollerar behörighet
	$this->ellibot_e->ellibot_capability("manage_options");
	
	//Kontrollerar om PRO-användare
	if($this->ellibot_e->ellibot_e_pro){$pro_user = true;}else{$pro_user == false;}
	
	//Deklarerar variabler
	global $wpdb;
	$site_id = $this->ellibot_e->vars("site_id");
	$db_settings_table_name = $this->ellibot_e->vars("db_settings_table_name");
	
	//Hämtar valt inställnings id
	if(isset($_POST['ellibot_woocommerce_slider_backend_save_settings_id'])){
		$settings_id = intval($_POST['ellibot_woocommerce_slider_backend_save_settings_id']);
	}
	
	if($settings_id > 0){
	
		//Kontrollerar om rätt Nonce
		if(isset($_POST['ellibot_woocommerce_slider_backend_save_settings'])){
			check_admin_referer('ellibot_nonce_save_settings_id_'.$settings_id,"ellibot_nonce_save");
		}
		else if(isset($_POST['ellibot_woocommerce_slider_backend_save_as_new_settings'])){
			check_admin_referer('ellibot_nonce_save_as_new_settings_id_'.$settings_id,"ellibot_nonce_save_as");
		}
		else if(isset($_POST['ellibot_woocommerce_slider_backend_save_create_new_settings'])){
			check_admin_referer('ellibot_nonce_save_create_new_settings_id_'.$settings_id,"ellibot_nonce_new");
		}
		else if(isset($_POST['ellibot_woocommerce_slider_backend_delete_settings'])){
			check_admin_referer('ellibot_nonce_delete_settings_id_'.$settings_id,"ellibot_nonce_delete");
		}
		
		//Raderar inställningar för valt id
		if(isset($_POST['ellibot_woocommerce_slider_backend_delete_settings'])){
			$sql = "DELETE FROM $db_settings_table_name WHERE site_id = $site_id AND settings_id = $settings_id";
			if(false === $wpdb->query($sql)){
				die(__("Database error! Your data was not deleted.",$this->ellibot_e->vars("lang")));
			}
			$settings_id = intval($wpdb->get_var("SELECT MIN(settings_id) FROM $db_settings_table_name WHERE site_id = $site_id"));
			if($settings_id <= 0){$settings_id = 1;}
		}
		
		//Skapar helt nya inställningar
		if(isset($_POST['ellibot_woocommerce_slider_backend_save_create_new_settings'])){
			$settings_id = intval($wpdb->get_var("SELECT MAX(settings_id) FROM $db_settings_table_name WHERE site_id = $site_id"))+1;
			$sql = "INSERT INTO $db_settings_table_name(site_id,settings_id,slug,val) VALUES ($site_id,$settings_id,'custom_slide_settings_name','".__("New slider settings",$this->ellibot_e->vars("lang"))."')";
			if(false === $wpdb->query($sql)){
				die(__("Database error! Your data was not saved.",$this->ellibot_e->vars("lang")));
			}
		}
		
		//Sparar inställningar till databasen
		if(isset($_POST['ellibot_woocommerce_slider_backend_save_settings']) OR isset($_POST['ellibot_woocommerce_slider_backend_save_as_new_settings'])){
			
			//Skapar ett nytt inställnings id
			if(isset($_POST['ellibot_woocommerce_slider_backend_save_as_new_settings'])){
				$settings_id = intval($wpdb->get_var("SELECT MAX(settings_id) FROM $db_settings_table_name WHERE site_id = $site_id"))+1;
			}
			else{

				//Raderar tidigare värden med detta inställnings id och sajt id för att kunna lägga in nya
				$sql = "DELETE FROM $db_settings_table_name WHERE site_id = $site_id AND settings_id = $settings_id";
				if(false === $wpdb->query($sql)){
					die(__("Database error! Your data was not deleted.",$this->ellibot_e->vars("lang")));
				}
				
			}
			
			//Sparar bara de variabler som är angedda i db_vars
			$var_array = array();
			$var_array = $this->ellibot_e->db_vars("var_array");
			
			foreach($_POST as $key => $value){
				
				if(!array_key_exists($key,$var_array)){continue;}
				
				if($key != "custom_css_style"){
					$value = trim(str_replace(";","",$value));
				}
				
				$value = trim(str_replace(";","",$value));
				if(strpos($key,'border_style') !== false AND $value == ""){$value = "none";}
				else if(strpos($key,'bgcolor') !== false AND $value == ""){$value = "transparent";}
				
				//Spara poster till databasen
				$sql = "INSERT INTO $db_settings_table_name(site_id,settings_id,slug,val) VALUES ($site_id,$settings_id,'$key','$value')";
				if(false === $wpdb->query($sql)){
					die(__("Database error! Your data was not saved.",$this->ellibot_e->vars("lang")));
				}
				
			}
			
		}
	
	}//end if settings > 0
	
	//Visar reklam om Pro för vanliga användare
	if($pro_user == false){
		$comercial = "
			<div class='card'>
				<h2>".__("Buy Pro version - from 17$ only",$this->ellibot_e->vars("lang"))."</h2>
				<ul>
					<li><strong>* Custom image type and excerpt</strong> - Set your own custom image field and excerpt text field for WooCommerce products (compatible with ACF)</li>
					<li><strong>* Multisite compatible</strong> - Different settings on different sites in the same installation</li>
					<li><strong>* Different settings</strong> - Different settings on different sliders on the same website</li>
					<li><strong>* Category based</strong> - Show products (all or/and featured products) from specific categories</li>
					<li><strong>* Specific slides</strong> - Choose exactly what products are displayed in the slider</li>
					<li><strong>* Sort and order</strong> - Order slides by: date, title, rand, comment_count, menu_order...</li>
					<li><strong>* Unlimited</strong> - Unlimited number of slides</li>
					<li><strong>* Premium support</strong> - Exclusive to Pro users</li>
				</ul>
				<p>
					<a class='ellibot_woocommerce_slider_backend_btn_buy' target='_blank' href='https://ellibot.com/shop/ellibot-woocommerce-slider-pro'>".__("Buy Pro version now!",$this->ellibot_e->vars("lang"))."</a>
				</p>
				<br />
			</div>
		";
	}
	else{$comercial = "";}
	
	//Om inget inställnings id angetts hämtas det första från databasen
	if(!isset($settings_id) OR $settings_id <= 0){
		$settings_id = intval($wpdb->get_var("SELECT MIN(settings_id) FROM $db_settings_table_name WHERE site_id = $site_id"));
		if($settings_id <= 0){$settings_id = 1;}
	}
	
	//Hämtar ut formulärets värden från databasen 
	$var_array = array();
	$var_array = $this->ellibot_e->db_vars("var_array",null,$settings_id);
	
	//Hämtar ut inställnings id
	$db_options = "";
	$sql = "SELECT settings_id,val FROM $db_settings_table_name WHERE site_id = $site_id AND slug = 'custom_slide_settings_name' ORDER BY settings_id ASC";
	$dbResult = $wpdb->get_results($sql);
	foreach($dbResult as $db){
		if($settings_id == $db->settings_id){$selected = " selected";}else{$selected = "";}
		if($db_options == ""){$default = " (default)";}else{$default = "";}
		$db_options .= "<option value='".$db->settings_id."'".$selected.">".$db->val." - id:".$db->settings_id.$default."</option>";
	}
	if($db_options == ""){
		$db_options .= "<option value='1'>".$var_array["custom_slide_settings_name"]["v"]." (default)</option>";
	}
	$output_select = "
		<select name='ellibot_woocommerce_slider_backend_save_settings_id' id='ellibot_woocommerce_slider_backend_save_settings_id'>
			".$db_options."
		</select>
	";
	
	//Skapar formuläret för inställningar
	$output = "<div>";
	$output_menu = "";
	$newUl = true;
	
	foreach($var_array as $key => $value){
		
		$s = "";		//Section
		$h = "";		//Headline
		$v = "";		//field value
		$n = "";		//field name
		$tt = "";		//field type: textarea
		$tc = "";		//field type: color
		$tn = "";		//field type: number
		$ts = array();	//field type: select
		
		foreach($value as $child_key => $child_value){
			if($child_key == "s"){$s = $child_value;}
			else if($child_key == "h"){$h = $child_value;}
			else if($child_key == "v"){$v = $child_value;}
			else if($child_key == "n"){$n = $child_value;}
			else if($child_key == "tt"){$tt = $child_value;}
			else if($child_key == "tc"){$tc = $child_value;}
			else if($child_key == "tn"){$tn = $child_value;}
			else if($child_key == "ts"){$ts = $child_value;}
		}
		
		if($s != ""){
			if($output != ""){$output .= "</div>";}
			$output .= "<div id='".$key."'>";
			$output .= "<h3>".$s."</h3>";
			if($newUl == false){$output_menu .= "</ul></li>";} 
			else if($output_menu != ""){$output_menu .= "</li>";}
			$output_menu .= "<li><a href='#".$key."'>".$s."</a>";
			$newUl = true;
		}
		else if($h != ""){
			if($output != ""){$output .= "</div>";}
			$output .= "<div id='".$key."'><h4>".$h."</h4>";
			if($newUl == true){$output_menu .= "<ul>";} $newUl = false;
			$output_menu .= "<li><a href='#".$key."'>".$h."</a></li>";
		}
		
		else{
			
			if($n == ""){continue;}
			$type = "";
			
			//type: textarea
			if($tt != ""){
				$type = "<textarea id='ellibot_woocommerce_slider_db_vars_".$key."' name='".$key."'>".$v."</textarea>";
			}
			
			//type: color
			else if($tc != ""){
				$v_color = trim(strtolower($v));
				if($v_color == "transparent" or $v_color == ""){$v_color = "#ffffff";}
				else if(strlen($v_color) == 4){$v_color = $v_color.substr($v,-3);}
				$type = "<input class='ellibot_woocommerce_slider_backend_type_color' id='ellibot_woocommerce_slider_db_vars_".$key."' type='text' name='".$key."' value='".$v."' /><input type='color' value='".$v_color."' />";
			}
			
			//type: number
			else if($tn != ""){
				$min = explode(",",$tn)[0];
				$max = explode(",",$tn)[1];
				$type = "<input id='ellibot_woocommerce_slider_db_vars_".$key."' type='number' min='".$min."' max='".$max."' name='".$key."' value='".$v."' />";
			}
			
			//type: select
			else if(count($ts) > 0){
				$options = "";
				$selected = "";
				foreach($ts as $option_key => $option_value){
					if($option_key == $v){$selected = " selected";}else{$selected = "";}
					$options .= "<option value='".$option_key."'".$selected.">".$option_value."</option>";
				}
				$type="<select name='".$key."'>".$options."</select>";
			}
			
			//type: text
			else{
				$type = "<input id='ellibot_woocommerce_slider_db_vars_".$key."' type='text' name='".$key."' value='".$v."' />";
			}
			
			$output .= "
				<span>
					<label for='ellibot_woocommerce_slider_db_vars_".$key."'>".$n."</label>
					".$type."
				</span>
			";
			
		}
		
	}
	
	$output .= "</div>";
	if($newUl == false){$output_menu .= "</ul></li>";}
	
	echo "
		<section id='ellibot_woocommerce_slider_backend'>
			
			<div class='wrap'>

				<div class='card'>
					<h1>".$var_array = $this->ellibot_e->vars("plugin_name")."</h1>
					
					<p>"
					.__("Version",$this->ellibot_e->vars("lang")) . ": " . $this->ellibot_e->ellibot_plugin_data('Version')
					.", ".__("License",$this->ellibot_e->vars("lang")) . ": " . $this->ellibot_e->vars('license')
					.", ".__("Author",$this->ellibot_e->vars("lang")) . ": " . $this->ellibot_e->ellibot_plugin_data('Author')
					.", ".__("About",$this->ellibot_e->vars("lang")) . ": <a target='_blank' href='" . $this->ellibot_e->ellibot_plugin_data('PluginURI') . "'>".__("Plugin URI",$this->ellibot_e->vars("lang"))."</a>
					</p>
				</div>
				
			</div>
			
			<div class='wrap'>
				
				".$comercial."
				
				<div class='card'>
					<h2>".__("How to use",$this->ellibot_e->vars("lang"))."</h2>
					<ul>	
						<li><strong>Use shortcodes in content or in templates to show the slider on the website.</strong></li>
						<li>In content, use shortcode: <strong>[".$this->ellibot_e->vars("shortcode")."]</strong> to display all featured products.</li>
						<li>In php-template, use: <strong>do_shortcode(\"[".$this->ellibot_e->vars("shortcode")."]\");</strong></li>
						<li>Set attribute: <strong>settings-id=\"x\"</strong> for the settings you want to use for the current slider.</li>
						<li><i>Remember:  max 20 featured products will appear in the slider. Go Pro for more options!</i></li>
					</ul>
					<h3>".__("Shortcode attributes for Pro users only",$this->ellibot_e->vars("lang"))."</h3>
					<ul>
						<li>Set attribute: <strong>settings-id=\"x\"</strong> for the settings you want to use for the current slider.</li>
						<li>Set attribute: <strong>cat-id=\"x\"</strong> to show all products from product categories id.<br />Separate each id with a comma, example: <i>1,2,3</i>.</li>
						<li>Set attribute: <strong>type=\"x\"</strong> to show all or featured products from the product categories id. Possible values ​​are: <i>all (default)</i> or <i>featured</i>.</li>
						<li>Set attribute: <strong>orderby=\"x\"</strong> to get products in specified order. Possible values ​​are: <i>menu_order, rand, date (default), title, comment_count</i>.</li>
						<li>Set attribute: <strong>order=\"x\"</strong> to get products in ascending or descending order. Possible values ​​are: <i>asc (default)</i> or <i>desc</i>.</li>
						<li>Set attribute: <strong>limit=\"x\"</strong> to limit to a certain number of slides. Default is 10.</li>
						<li>Set attribute: <strong>pro-id=\"x\"</strong> to show specific products.<br />Separate each id with a comma, example: <i>1,2,3</i>.<br />Important! Pro-id overrides attributes: cat-id, type and limit.</li>
						<li>Example: <strong>[".$this->ellibot_e->vars("shortcode")." settings-id=\"1\" cat-id=\"10,16\" type=\"featured\" orderby=\"title\" order=\"asc\"]</strong> Displays all featured products from categories id 10 and 16, order by title ascending. The slider will use settings width id 1.</li>
					</ul>
					<p><a href='https://ellibot.com/documentation/ellibot-woocommerce-slider/' target='blank'>Full documentation here</a></p><br />
				</div>
				
			</div>
			
			<form method='post' id='ellibot_woocommerce_slider_backend_form_send'>
			
				<div class='wrap'>
					
					<div class='card' id='ellibot_woocommerce_slider_backend_menu'>
						<h2>".__("Settings and Style",$this->ellibot_e->vars("lang"))."</h2>
						<ul>".$output_menu."</ul>
						".$output_select."
						<input type='submit' class='ellibot_woocommerce_slider_backend_btn' name='ellibot_woocommerce_slider_backend_save_settings' value='".__("Save settings",$this->ellibot_e->vars("lang"))."' />
						<input type='submit' class='ellibot_woocommerce_slider_backend_new' name='ellibot_woocommerce_slider_backend_save_as_new_settings' value='".__("Save as new settings",$this->ellibot_e->vars("lang"))."' />
						<input type='submit' class='ellibot_woocommerce_slider_backend_new' name='ellibot_woocommerce_slider_backend_save_create_new_settings' value='".__("Create new settings",$this->ellibot_e->vars("lang"))."' />
						<input type='submit' class='ellibot_woocommerce_slider_backend_delete' name='ellibot_woocommerce_slider_backend_delete_settings' value='".__("Delete settings",$this->ellibot_e->vars("lang"))."' />
					</div>
					
				</div>
				
				<div class='wrap'>
					
					<div class='card' id='ellibot_woocommerce_slider_backend_form'>
						".$output."
					</div>
					
					".wp_nonce_field('ellibot_nonce_save_settings_id_'.$settings_id,"ellibot_nonce_save")."
					".wp_nonce_field('ellibot_nonce_save_as_new_settings_id_'.$settings_id,"ellibot_nonce_save_as")."
					".wp_nonce_field('ellibot_nonce_save_create_new_settings_id_'.$settings_id,"ellibot_nonce_new")."
					".wp_nonce_field('ellibot_nonce_delete_settings_id_'.$settings_id,"ellibot_nonce_delete")."
					
				</div>
			
			</form>
			
			<div class='ellibot_woocommerce_slider_backend_screen_check_767px'></div>
			
		</section>
	";
	
?>