<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

//Anrop från ellibot_frontend.js (Ajax)
if(isset($_POST['choice']) AND trim($_POST['choice']) != ""){
	
	//Kontrollerar nonce
	$nonce_check = check_ajax_referer('ellibot_woocommerce_slider_ajax_nonce','nonce',false);
	if($nonce_check != true){
		die(json_encode(array("prompt","<div class='ellibot_woocommerce_slider_message'>Ellibot WooCoomerce Slider ".__("Message",$lang).": ".__("Wrong nonce is given.",$lang)."</div>")));
	}
		
	$choice = sanitize_text_field($_POST['choice']);
	
	if($choice == "get_slider"){
		
		//Hämtar inställningar
		$settings_id = $this->ellibot_e->attr("settings-id");
		$var_array = $this->ellibot_e->db_vars("var_array",null,$settings_id);
		
		//Hämtar PRO-attribut
		if($this->ellibot_e->ellibot_e_pro){
			
			$args = $this->ellibot_e->ellibot_e_pro->args();
			$pro_user = true;
			$pro_custom_image = $var_array["pro_custom_image"]["v"];
			$pro_custom_excerpt = $var_array["pro_custom_excerpt"]["v"];
			
		}
		//Vanliga användare (ej Pro)
		else{
			
			$args = "";
			$pro_user = false;
			$pro_custom_image = "";
			$pro_custom_excerpt = "";
			
		}
	
		ellibot_woocommerce_slider_get_slider(
			$pro_user,
			$settings_id,
			$this->ellibot_e->vars("site_id"),
			$pro_custom_image,
			$pro_custom_excerpt,
			$var_array["custom_slide_button_url"]["v"],
			$var_array["custom_image_size"]["v"],
			$var_array["custom_show_proname"]["v"],
			$var_array["custom_show_price"]["v"],
			$var_array["custom_show_button"]["v"],
			$var_array["custom_show_desc"]["v"],
			$var_array["custom_allow_html_desc"]["v"],
			$var_array['translate_btn_thumbnails_show']["v"],
			$var_array['translate_btn_thumbnails_hide']["v"],
			$var_array['translate_btn_slider']["v"], 
			$var_array["lang"]["v"],
			$this->ellibot_e->vars("db_settings_table_name"),
			$args
		);
		
	}
	else{
		die(json_encode(array("alert","Inget val gjort!")));
	}
}
else{
	die(json_encode(array("console","Det saknas variabler!")));
}


/* Funktion för att skapa och visa Slider */
function ellibot_woocommerce_slider_get_slider(
	$pro_user,
	$settings_id,
	$site_id,
	$pro_custom_image,
	$pro_custom_excerpt,
	$custom_slide_button_url,
	$custom_image_size,
	$custom_show_proname,
	$custom_show_price,
	$custom_show_button,
	$custom_show_desc,
	$custom_allow_html_desc,
	$translate_btn_thumbnails_show,
	$translate_btn_thumbnails_hide,
	$translate_btn_slider,
	$lang,
	$db_settings_table_name,
	$args
){
	
	$message = "";
	$output = "";
	$eslide_id = 0;
	$imageCount = 0;
	$html_text = "";
	$html_slide = "";
	$html_thumb = "";
	$html_nav = "";
	
	if(trim($translate_btn_thumbnails_show) == ""){$translate_btn_thumbnails_show = esc_html__("Show");}
	if(trim($translate_btn_thumbnails_hide) == ""){$translate_btn_thumbnails_hide = esc_html__("Hide");}
	if(trim($translate_btn_slider) == ""){$translate_btn_slider = esc_html__('Read more', 'woocommerce');}
	
	//Standardhämtning utan PRO
	if($args == ""){
		$args = array(  
			'post_type' => 'product',
			'post_status' => 'publish', 
			'tax_query' => array(
				array(
					'taxonomy' => 'product_visibility',
					'field'    => 'name',
					'terms'    => 'featured',
					'operator' => 'IN'
				),
			),
			'posts_per_page' => 20,
			'orderby' => 'date',
			'order' => 'asc'
		);  
	}
	
	$db_posts = new WP_Query( $args );
	if ($db_posts->have_posts()) :
		while ($db_posts->have_posts()) :
			
			$db_posts->the_post();
			$product = wc_get_product($db_posts->post->ID);
			
			$title = "";
			$title_thumb = "";
			$price = "";
			$price_thumb = "";
			$desc = "";
			$button = "";
			$image = "";
			$image_post_meta = 0;
			
			//Titel
			if($custom_show_proname == 1){
				$title = trim(get_the_title());
				$title_thumb = "<span class='ellibot_woocommerce_slider_thumb_title'>".$title."</span>";
				$title = "<span class='ellibot_woocommerce_slider_image_text_title'>".$title."</span>";
			}
			
			//Pris
			if($custom_show_price == 1){
				$price = $product->get_price_html();
				$price_thumb = "<span class='ellibot_woocommerce_slider_thumb_price'>".$price."</span>";
				$price = "<span class='ellibot_woocommerce_slider_image_text_price'>".$price."</span>";
			}
			
			//Knapp
			if($custom_show_button == 1){
				if(trim($custom_slide_button_url) != ""){$url = trim($custom_slide_button_url);}else{$url = trim(get_permalink());}
				$button = "<span class='ellibot_woocommerce_slider_image_text_button'><a href='".$url."'>".$translate_btn_slider."</a></span>";
			}
			
			//Beskrivning 
			if($custom_show_desc == 1){
				
				//Egen custom kort beskrivning
				if(trim($pro_custom_excerpt) != ""){
					$desc = nl2br(trim(get_post_meta($db_posts->post->ID,$pro_custom_excerpt,true)));
				}
				
				//WooCommerce kort beskrivning
				if(trim($desc) == ""){
					$desc = nl2br(trim($product->get_short_description()));
				}
				
				if($custom_allow_html_desc == 0){$desc = trim(strip_tags($desc));}
				if($desc != ""){$desc = "<span class='ellibot_woocommerce_slider_image_text_desc'>".$desc."</span>";}
				else{$desc = "";}
				
				//Shortcodes i excerpt
				$desc = do_shortcode($desc); 
				
			}
			
			//Egen custom bild (obs! måste generera ett bild-id)
			if(trim($pro_custom_image) != ""){
				$image_post_meta = trim(get_post_meta($db_posts->post->ID,$pro_custom_image,true));
				if(intval($image_post_meta) > 0){
					$image_src = wp_get_attachment_image_src($image_post_meta,$custom_image_size);
					$image_src_path = dirname($image_src[0]);
					$image_src_filename = basename($image_src[0]);
					if($image_src_filename != ""){$image = $image_src_path . '/' . $image_src_filename;}
				}
			}
			
			//Bild (woocommerce produktbild)
			if(trim($image) == ""){
				$image_src = wp_get_attachment_image_src(get_post_thumbnail_id($post_id),$custom_image_size);
				$image_src_path = dirname($image_src[0]);
				$image_src_filename = basename($image_src[0]);
				if($image_src_filename != ""){$image = $image_src_path . '/' . $image_src_filename;}
			}
			
			$img = "";
			if($image != ""){$img = "<img src='".$image."' />"; $imageCount++;}
			$eslide_id++;
			
			//Lägger in text i slide
			$html_text = "<div class='ellibot_woocommerce_slider_image_text'>".$title.$desc.$price.$button."</div>";
			
			//Lägger in bild i slide
			$html_image = "<div class='ellibot_woocommerce_slider_image' style='background-image:url(".$image.")'>".$img."</div>";
			
			//Lägger in slide (med text och bild)
			$html_slide .= "<div class='ellibot_woocommerce_slider_slide' id='ellibot_woocommerce_slider_slide_id_".$eslide_id."' data-id='".$eslide_id."' data-url='".$image."'>".$html_text.$html_image."</div>";
			
			//Lägger in thumbnail
			$html_thumb .= "<div class='ellibot_woocommerce_slider_thumb' data-id='".$eslide_id."'><div class='ellibot_woocommerce_slider_thumb_image' style='background-image:url(".$image.")'></div><div class='ellibot_woocommerce_slider_thumb_text'>".$title_thumb.$price_thumb."</div></div>";
				
			//Lägger in navigeringspunkt
			$html_nav .= "<div class='ellibot_woocommerce_slider_nav' id='ellibot_woocommerce_slider_nav_id_".$eslide_id."' data-id='".$eslide_id."'></div>";
				
		endwhile;
	endif;
	
	wp_reset_query();
	
	/* Kollar om några shortcode attribut är satta (förutom settings-id) */
	$shortcode_attr_arr = json_decode(stripslashes($_POST['shortcode_attr']),true);
	$shortcode_is_set = false;
	foreach($shortcode_attr_arr as $key => $val){
		if($val != null AND $key != "settings-id"){
			$shortcode_is_set = true;
		}
	}
	
	/* Kollar om det finns några inställningar med angivet id */
	if($settings_id > 0){
		global $wpdb;
		$db_id = intval($wpdb->get_var("SELECT id FROM $db_settings_table_name WHERE settings_id = $settings_id AND site_id = $site_id"));
		if($db_id <= 0){$message .= __("There are no settings saved with this attribute settings-id",$lang)." (".$settings_id.").<br />";}//Regular user message
	}
	
	/* Validering */
	if($shortcode_is_set == true AND $pro_user == false){
		$message .= __("Attributes can only be used by Pro users (except settings-id).",$lang)."<br />";//Regular user message
	}
	else if($eslide_id <= 0 AND $shortcode_is_set == true AND $pro_user == true){
		$message .= __("No products with given shortcode attributes could be found.",$lang)."<br />";//Pro user message
	}
	else if($eslide_id <= 0 AND $shortcode_is_set == false AND $pro_user == true){
		$message .= __("There are no products to show.",$lang)."<br />";//Pro user message
	}
	else if($eslide_id <= 0){
		$message .= __("There are no featured products to show.",$lang)."<br />";//Regular user message
	}
	else if($imageCount <= 0){
		$message .= __("No images found.",$lang)."<br />";
	}
	
	if($message != ""){
		die(json_encode(array("prompt","<div class='ellibot_woocommerce_slider_message'>Ellibot WooCoomerce Slider ".__("Message",$lang).": ".$message."</div>")));
	}
	
	/* Skriver ut slidern */
	$output .= "<div class='ellibot_woocommerce_slider_content' data-slide='0' data-auto='yes' data-status='ready'>".$html_slide."</div>";
	if($eslide_id > 1){
		$output .= "<div class='ellibot_woocommerce_slider_arrow_left'></div><div class='ellibot_woocommerce_slider_arrow_right'></div>";
		$output .= "<div class='ellibot_woocommerce_slider_thumbs_arrow_left'></div><div class='ellibot_woocommerce_slider_thumbs_arrow_right'></div>";
		$output .= "<div class='ellibot_woocommerce_slider_thumbs' data-status='ready'><div class='ellibot_woocommerce_slider_thumbs_container'><div class='ellibot_woocommerce_slider_thumbs_content'>".$html_thumb."</div></div></div>";
		$output .= "<div class='ellibot_woocommerce_slider_navs'><div class='ellibot_woocommerce_slider_navs_container'>".$html_nav."<div class='ellibot_woocommerce_slider_btn_handle_thumbs'><span class='ellibot_woocommerce_slider_thumbs_show'>".$translate_btn_thumbnails_show."</span><span class='ellibot_woocommerce_slider_thumbs_hide'>".$translate_btn_thumbnails_hide."</span></div></div></div>";
	}

	echo json_encode(array("success",$output));
}

wp_die();

?>