<?php
/**
 * @package WC Elitsms
 */

//prevent direct entry
if(!defined('ABSPATH')){
    exit;
}

if(!class_exists('wc_elitsms_sms')){
    class wc_elitsms_sms{

        private function elisms_generateSms($contact,$msg){
            $elitsms_settings=get_option('elitsms_settings');
            $senderid= $elitsms_settings['elitsms_senderid'];
            $apikey=$elitsms_settings['elitsms_apikey'];
            $url = $elitsms_settings['elitsms_sms_domain'];

            $data = [
                "api_key" => $apikey,
                "type" => "text",
                "contacts" => $contact,
                "senderid" => $senderid,
                "msg" =>$msg];
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            $response = curl_exec($ch);
            curl_close($ch);
        }

        public function elitsms_sendsms_on_order($order_id ){
            $order = wc_get_order( $order_id );
            $firstname = $order->get_billing_first_name();
            $shopname= rawurldecode(get_option('blogname'));
            $phone=$order->get_billing_phone();
            $amount= $order->get_formatted_order_total();
            $message = "Dear ".$firstname.", Your order from ". $shopname. " Has been placed.\n Your OrderID: ".$order_id. "\nOrder amount: ". $amount."\nThank you for staying with us.";
            $this->elisms_generateSms($phone,$message);
        }


        public function elitsms_sendsms_on_user_registration(){
            //var_dump($user_id);
            //die('Testing User Registration SMS');
        }

        public function elitsms_sendsms_on_order_status_change($order){
            $order_id=$order;
            $order = wc_get_order( $order);
            $firstname = $order->get_billing_first_name();
            $shopname= rawurldecode(get_option('blogname'));
            $phone=$order->get_billing_phone();
            $order_status=ucwords($order->get_status()) ;
            $message="Dear ".$firstname.", Status of your order from ". $shopname. " has been changed.\n OrderID: ".$order_id. "\nCurrent Status: ". $order_status."\nThank you for staying with us.";
            $this->elisms_generateSms($phone,$message);

        }
    }
}

