<?php
/**
 * Plugin Name: Elite Stay Helper - Create Cpts and taxonomy for rooms
 * Description: This plugin registers all custom post types related to the Elite Stay theme.
 * Version: 1.0.2
 * Author: Kamaldhari Infotech
 * Author URI: https://kamaldhari.com/
 * License: GPL-2.0-or-later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: elite-stay-helper
 */
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit; 
}
// Define plugin constants
define('elite_stay_mainfile', plugin_dir_url(__FILE__));
define('ELITE_STAY_PLUGIN_DIR', plugin_dir_url(__FILE__));
define('ELITE_STAY_ACTIVATE', __FILE__);
if (!defined('_eshelite_verison')) {
    define('_eshelite_verison', '1.0.1');
}
// Include the shortcode file
require_once plugin_dir_path(__FILE__) . 'class/Shortcode_Class.php';
// Function to run during plugin activation
function elite_stay_helper_activate_instantiation() {
    // Instantiate Shortcode_Class
    $shortcode_class = new Elite_stay_plugin\Esh_Includes\Esh_Shortcode_Class();
}
add_action('init', 'elite_stay_helper_activate_instantiation');
// Function to run during plugin deactivation
function elite_stay_deactivate() {
    delete_option('elite_stay_helper_activation');
}
register_deactivation_hook(__FILE__, 'elite_stay_deactivate');
require_once plugin_dir_path(__FILE__) . 'class/elite-helpter-activate.php';
new Elite_Helper_Activate();
require_once plugin_dir_path(__FILE__) . 'class/hm-theme-setting.php';
new elitestay_HotelThemeSetting();
function elitestay_add_demo_import_menu() {
    add_theme_page(
        'Demo Import', // Page title
        'Demo Import', // Menu title
        'manage_options', // Capability
        'elitestay-demo-import', // Menu slug
        'elitestay_demo_import_page' // Callback function
    );
}
add_action('admin_menu', 'elitestay_add_demo_import_menu');
function elitestay_demo_import_page() {
    ?>
    <div class="wrap">
        <h2>EliteStay Demo Import</h2>
        <button id="elitestay-demo-import-btn" class="button button-primary">Start Demo Import</button>
        <div id="elitestay-import-status"></div>
        <script>
        jQuery(document).ready(function($) {
            var functionsList = [
                'elitestay_table_create',
                'elitestay_default_option_sets',
                'elitestay_default_saving',
                'elitestay_theme_page_create',
                'elitestay_create_testimonial_posts',
                'elitestay_create_three_blog_posts',
                'elitestay_create_hm_offers_posts',
                'elitestay_create_hm_hidden_gem_posts',
                'elitestay_create_three_adventure_posts',
                'elitestay_create_rooms_posts'
            ];
            
            function runAjaxSequence(index) {
                if (index >= functionsList.length) {
                    $('#elitestay-import-status').append('<p><strong>All tasks completed!</strong></p>');
                    return;
                }
                
                var functionName = functionsList[index];
                $('#elitestay-import-status').append('<p>Running: ' + functionName + '</p>');
                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: functionName,
                        security: '<?php $nonece = wp_create_nonce("elitestay_demo_nonce"); echo esc_attr($nonece);  ?>',
                        function_name: functionName
                    },
                    success: function(response) {
                        if (response.success) {
                            $('#elitestay-import-status').append('<p style="color:green;">' + response.data.message + '</p>');
                            runAjaxSequence(index + 1);
                        } else {
                            $('#elitestay-import-status').append('<p style="color:red;">Error: ' + response.data.message + '</p>');
                        }
                    },
                    error: function() {
                        $('#elitestay-import-status').append('<p style="color:red;">AJAX request failed!</p>');
                    }
                });
            }
            $('#elitestay-demo-import-btn').click(function() {
                $('#elitestay-import-status').html('');
                runAjaxSequence(0);
            });
        });
        </script>
    </div>
    <?php
}
function elitestay_plugin_scripts_admin(){
    
    wp_enqueue_style('datatable-js', ELITE_STAY_PLUGIN_DIR . '/admin/css/style.css');
    wp_enqueue_script('datatable-uncss',  ELITE_STAY_PLUGIN_DIR . '/admin/js/hm-admin.js');
    
}
add_action('admin_enqueue_scripts', 'elitestay_plugin_scripts_admin');