<?php
/**
* Shortcode Class.
*
* @package Elite_stay_plugin
*/
namespace Elite_stay_plugin\Esh_Includes;
class Esh_Shortcode_Class {
    /**
     * Constructor for initialization.
    */
    private $filesystem ;
    public function __construct( ) {
       
        $THEME_ASSETS_PATH = defined('THEME_ASSETS_PATH') ? THEME_ASSETS_PATH : '';
        if(empty($THEME_ASSETS_PATH)){
            $THEME_ASSETS_PATH = elite_stay_mainfile .'/assets/img/';
        }
        $this->main_dir = get_template_directory_uri() . "/";
        $this->main_dir_files = elite_stay_mainfile .'assets';
        $this->eshelite_helper_init();
    }   
    /**
     * Initialize necessary functions.
    */
    public function eshelite_helper_init() {
        add_action('init', array($this, 'eshelite_cpt_include'), 99);
        add_action('init', array($this, 'eshelite_shortcode_inc'), 99);
        add_action('add_meta_boxes', array($this, 'eshelite_cpts_meta'), 10);
        add_action('save_post', array($this, 'eshelite_save_metadata'), 299);
        add_action('wp_enqueue_scripts',array($this, 'eshelite_scripts'));
        add_action('admin_enqueue_scripts',array($this, 'eshelite_scripts_admin'));
        add_action('post_edit_form_tag', array($this, 'eshelite_modify_edit_tag'), 99);
        add_action('room_amenities_term_edit_form_tag', array($this, 'eshelite_modify_cat_edit_tag'));
        add_action('room_amenities_term_new_form_tag', array($this, 'eshelite_modify_cat_edit_tag'));
        add_action('hotel_amenities_term_edit_form_tag', array($this, 'eshelite_modify_cat_edit_tag'));
        add_action('hotel_amenities_term_new_form_tag', array($this, 'eshelite_modify_cat_edit_tag'));
         
    }
    
    public function eshelite_scripts() {
        // Enqueue main CSS file
        wp_enqueue_style('elite_helper_style', $this->main_dir_files . '/css/elite_stay.css', array(), _eshelite_verison);
        // Add RTL support for the main CSS file
        wp_style_add_data('elite_helper_style', 'rtl', 'replace');
        // Enqueue responsive CSS file
        wp_enqueue_style('elite-stay-hmrespostyle', $this->main_dir_files . '/css/elite_stay_responsive.css', array('elite_helper_style'), _eshelite_verison, 'screen and (max-width: 768px)');
        // Enqueue jQuery
        wp_enqueue_script('jquery');
        // Enqueue owl carousel JS file
        wp_enqueue_script('owl-js', $this->main_dir_files . '/js/owl.carousel.min.js', array('jquery'), _eshelite_verison, true);
        // Enqueue owl carousel CSS file
        wp_enqueue_style('sowl-css', $this->main_dir_files . '/css/owl.carousel.css', array(), _eshelite_verison);
        // Enqueue custom public JS file
        wp_enqueue_script('elite_helper_public_js', $this->main_dir_files . '/elite_helper_script.js', array('jquery', 'owl-js'), _eshelite_verison, true);
    }
    public function eshelite_scripts_admin() {
        
        // Enqueue media scripts for the admin
        wp_enqueue_media();
        // Enqueue custom admin JS file
        wp_enqueue_script('elite_helper_', $this->main_dir_files . '/js/cstm_admin.js', array('jquery'), _eshelite_verison, true);
        // Enqueue custom admin CSS file
        wp_enqueue_style('elite-helper-admin-style-css', $this->main_dir_files . '/css/elite_helper_admin.css', array(), _eshelite_verison);
    }
    public function eshelite_modify_edit_tag() {
        echo 'enctype="multipart/form-data"';
    }
    public function eshelite_modify_cat_edit_tag($tag) {
        echo ' enctype="multipart/form-data"';
    }
    
    public function eshelite_cpt_include() {
        $hm_rooms_label = array(
            'name'               => __('HM Rooms', 'elite-stay-helper'),
            'singular_name'      => __('HM Room', 'elite-stay-helper'),
            'add_new'            => __('Add New Room', 'elite-stay-helper'),
            'add_new_item'       => __('Add New Room', 'elite-stay-helper'),
            'edit_item'          => __('Edit Room', 'elite-stay-helper'),
            'new_item'           => __('New Room', 'elite-stay-helper'),
            'view_item'          => __('View Room', 'elite-stay-helper'),
            'view_items'         => __('View Rooms', 'elite-stay-helper'),
            'search_items'       => __('Search Rooms', 'elite-stay-helper'),
            'not_found'          => __('No rooms found', 'elite-stay-helper'),
            'not_found_in_trash' => __('No rooms found in Trash', 'elite-stay-helper'),
        );
        $hm_rooms_args = array(
            'labels'        => $hm_rooms_label,
            'public'        => true,
            'has_archive'   => true,
            'rewrite'       => array('slug' => 'rooms'),
            'menu_icon'     => 'dashicons-admin-home',
            'supports'      => array('title', 'editor', 'thumbnail'),
        );
        $hidden_gem_labels = array(
            'name'          => __('Hidden Gems', 'elite-stay-helper'),
            'singular_name' => __('Hidden Gem', 'elite-stay-helper'),
            'add_new'            => __('Add Hidden Gem', 'elite-stay-helper'),
            'add_new_item'       => __('Add Hidden Gem', 'elite-stay-helper'),
            'edit_item'          => __('Edit Hidden Gem', 'elite-stay-helper'),
            'new_item'           => __('New Hidden Gem', 'elite-stay-helper'),
            'view_item'          => __('View Hidden Gem', 'elite-stay-helper'),
            'view_items'         => __('View Hidden Gem', 'elite-stay-helper'),
            'search_items'       => __('Search Hidden Gem', 'elite-stay-helper'),
            'not_found'          => __('No hidden gem found', 'elite-stay-helper'),
            'not_found_in_trash' => __('No hidden gem found in Trash', 'elite-stay-helper'),
        );
        $hidden_args = array(
            'labels'        => $hidden_gem_labels,
            'public'        => false,
            'show_ui'       => true,
            'show_in_menu'  => true,
            'show_in_nav_menus' => false,
            'show_in_admin_bar' => false,
            'supports'      => array('title', 'editor', 'thumbnail'),
        );
        $testimonial_labels = array(
            'name'               => __('Testimonials', 'elite-stay-helper'),
            'singular_name'      => __('Testimonial', 'elite-stay-helper'),
            'menu_name'          => __('Testimonials', 'elite-stay-helper'),
            'name_admin_bar'     => __('Testimonial', 'elite-stay-helper'),
            'add_new'            => __('Add New', 'elite-stay-helper'),
            'add_new_item'       => __('Add New Testimonial', 'elite-stay-helper'),
            'new_item'           => __('New Testimonial', 'elite-stay-helper'),
            'edit_item'          => __('Edit Testimonial', 'elite-stay-helper'),
            'view_item'          => __('View Testimonial', 'elite-stay-helper'),
            'all_items'          => __('All Testimonials', 'elite-stay-helper'),
            'search_items'       => __('Search Testimonials', 'elite-stay-helper'),
            'parent_item_colon'  => __('Parent Testimonials:', 'elite-stay-helper'),
            'not_found'          => __('No testimonials found.', 'elite-stay-helper'),
            'not_found_in_trash' => __('No testimonials found in Trash.', 'elite-stay-helper'),
        );
        $testimonial_args = array(
            'labels'             => $testimonial_labels,
            'description'        => __('Description.', 'elite-stay-helper'),
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'menu_icon'          => 'dashicons-testimonial',
            'query_var'          => true,
            'rewrite'            => array('slug' => 'testimonials'),
            'capability_type'    => 'post',
            'has_archive'        => true,
            'hierarchical'       => false,
            'menu_position'      => null,
            'supports'           => array('title', 'editor', 'thumbnail')
        );
        $adventure_labels = array(
            'name'               => __('Adventures', 'elite-stay-helper'),
            'singular_name'      => __('Adventure', 'elite-stay-helper'),
            'menu_name'          => __('Adventures', 'elite-stay-helper'),
            'name_admin_bar'     => __('Adventure', 'elite-stay-helper'),
            'add_new'            => __('Add New', 'elite-stay-helper'),
            'add_new_item'       => __('Add New Adventure', 'elite-stay-helper'),
            'new_item'           => __('New Adventure', 'elite-stay-helper'),
            'edit_item'          => __('Edit Adventure', 'elite-stay-helper'),
            'view_item'          => __('View Adventure', 'elite-stay-helper'),
            'all_items'          => __('All Adventures', 'elite-stay-helper'),
            'search_items'       => __('Search Adventures', 'elite-stay-helper'),
            'parent_item_colon'  => __('Parent Adventures:', 'elite-stay-helper'),
            'not_found'          => __('No Adventures found.', 'elite-stay-helper'),
            'not_found_in_trash' => __('No Adventures found in Trash.', 'elite-stay-helper'),
        );
        $adventure_args = array(
            'labels'             => $adventure_labels,
            'description'        => __('Description.', 'elite-stay-helper'),
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'menu_icon'          => 'dashicons-location',
            'query_var'          => true,
            'rewrite'            => array('slug' => 'Adventures'),
            'capability_type'    => 'post',
            'has_archive'        => true,
            'hierarchical'       => false,
            'menu_position'      => null,
            'supports'           => array('title', 'editor', 'thumbnail')
        );
        $hm_offers_label = array(
            'name'               => __('HM Offers', 'elite-stay-helper'),
            'singular_name'      => __('HM Offer', 'elite-stay-helper'),
            'add_new'            => __('Add Offers', 'elite-stay-helper'),
            'add_new_item'       => __('Add Offers', 'elite-stay-helper'),
            'edit_item'          => __('Edit Offers', 'elite-stay-helper'),
            'new_item'           => __('New Offers', 'elite-stay-helper'),
            'view_item'          => __('View Offer', 'elite-stay-helper'),
            'view_items'         => __('View Offers', 'elite-stay-helper'),
            'search_items'       => __('Search Offers', 'elite-stay-helper'),
            'not_found'          => __('No Offers found', 'elite-stay-helper'),
            'not_found_in_trash' => __('No Offers found in Trash', 'elite-stay-helper'),
        );
        $hm_offers_args = array(
            'labels'       => $hm_offers_label,
            'public'       => true,
            'has_archive'  => true,
            'rewrite'      => array('slug' => 'Offers'),
            'menu_icon'    => 'dashicons-star-filled',
            'supports'     => array('title', 'editor', 'thumbnail', 'custom-fields'),
        );
    
        register_post_type('hm_rooms', $hm_rooms_args);
        register_post_type('hm_hidden_gem', $hidden_args);
        register_post_type('hm_testimonial', $testimonial_args);
        register_post_type('hm_adventures', $adventure_args);
        register_post_type('hm_offers', $hm_offers_args);
        // REGISTER TAXONOMY FOR POSTS 
        $this->elite_helper_cpt_taxonomy_include();
    }
    public function eshelite_shortcode_inc() {
        add_shortcode('eshelite_home_booking_form', array($this, 'eshelite_home_booking_form'));
        add_shortcode('eshelite_home_newsletter_form',array($this,'eshelite_home_newsletter_form_callback'));
        add_shortcode('eshelite_rooms_preview', array($this, 'eshelite_rooms_preview_callback'));
        add_shortcode('eshelite_hidden_gems', array($this, 'eshelite_hidden_gems_preview_callback'));
        add_shortcode('eshelite_testimonials', array($this, 'eshelite_testimonials_callback'));
        add_shortcode('eshelite_blogs_preview', array($this, 'eshelite_blogs_preview_callback'));
        add_shortcode('eshelite_roomspg_room_preview', array($this, 'eshelite_roomspg_room_preview_callback'));
        add_shortcode('eshelite_local_pg_hidden_gems', array($this, 'eshelite_local_pg_hidden_gems_callback'));
        add_shortcode('eshelite_adventures', array($this, 'eshelite_adventures_callback'));
        add_shortcode('eshelite_offers_display', array($this, 'eshelite_offers_display_callback'));
        add_shortcode('eshelite_offers_roompreview', array($this, 'eshelite_offers_rooms_callback'));
        add_shortcode('eshelite_contactus_form', array($this, 'eshelite_contactus_form_callback'));
        add_shortcode('eshelite_map_shortcode', array($this, 'eshelite_map_shortcode_callback'));
    }
    public function elite_helper_cpt_taxonomy_include() {
        $room_labels = array(
            'name' => __('Room Amenities', 'elite-stay-helper'),
            'singular_name' => __('Room Amenity', 'elite-stay-helper'),
            'menu_name' => __('Room Amenities', 'elite-stay-helper'),
            'all_items' => __('All Room Amenities', 'elite-stay-helper'),
            'edit_item' => __('Edit Room Amenity', 'elite-stay-helper'),
            'view_item' => __('View Room Amenity', 'elite-stay-helper'),
            'update_item' => __('Update Room Amenity', 'elite-stay-helper'),
            'add_new_item' => __('Add New Room Amenity', 'elite-stay-helper'),
            'new_item_name' => __('New Room Amenity Name', 'elite-stay-helper'),
        );
        $room_args = array(
            'hierarchical' => false,
            'labels' => $room_labels,
            'show_ui' => true,
            'show_admin_column' => true,
            'query_var' => true,
            'rewrite' => array('slug' => 'room-amenities'),
        );
        $hotels_labels = array(
            'name' => __('Hotel Amenities', 'elite-stay-helper'),
            'singular_name' => __('Hotel Amenity', 'elite-stay-helper'),
            'menu_name' => __('Hotel Amenities', 'elite-stay-helper'),
            'all_items' => __('All Hotel Amenities', 'elite-stay-helper'),
            'edit_item' => __('Edit Hotel Amenity', 'elite-stay-helper'),
            'view_item' => __('View Hotel Amenity', 'elite-stay-helper'),
            'update_item' => __('Update Hotel Amenity', 'elite-stay-helper'),
            'add_new_item' => __('Add New Hotel Amenity', 'elite-stay-helper'),
            'new_item_name' => __('New Hotel Amenity Name', 'elite-stay-helper'),
        );
        $hotel_args = array(
            'hierarchical' => false,
            'labels' => $hotels_labels,
            'show_ui' => true,
            'show_admin_column' => true,
            'query_var' => true,
            'rewrite' => array('slug' => 'hotel-amenities'),
        );
        register_taxonomy('room_amenities', 'hm_rooms', $room_args);
        register_taxonomy('hotel_amenities', 'hm_rooms', $hotel_args);
        add_action('room_amenities_add_form_fields', array($this, 'eshelite_taxonomy_room_amini_custom_field'), 99);
        add_action('room_amenities_edit_form_fields', array($this, 'eshelite_edit_taxonomy_room_amini_custom_field'), 99, 2);
        add_action('hotel_amenities_add_form_fields', array($this, 'eshelite_taxonomy_room_amini_custom_field'), 99);
        add_action('hotel_amenities_edit_form_fields', array($this, 'eshelite_edit_taxonomy_room_amini_custom_field'), 99, 2);
        add_action('edited_room_amenities', array($this, 'eshelite_save_room_amenities_image_field'), 10, 2);
        add_action('created_room_amenities', array($this, 'eshelite_save_room_amenities_image_field'), 10, 2);
        add_action('edited_hotel_amenities', array($this, 'eshelite_save_room_amenities_image_field'), 10, 2);
        add_action('created_hotel_amenities', array($this, 'eshelite_save_room_amenities_image_field'), 10, 2);
        $this->eshelite_create_taxonomy_proterm();
    }
    public function eshelite_create_taxonomy_proterm() {
        // Check if 'room_amenities' taxonomy is empty
        $active_ones = get_option('elite_stay_helper_activation');
        $active_ones = "";
        $room_amenities_terms = get_terms(array(
            'taxonomy' => 'room_amenities',
            'hide_empty' => true,
        ));
        if (empty($room_amenities_terms)  && !$active_ones ) {
            $term_data = array(
                'Air conditioning' => 'assets/img/ac_amini.png',
                'Free Wifi' => 'assets/img/wifi_amini.png',
                'Phone' => 'assets/img/phone_amini.png',
                'Safe' => 'assets/img/safe_amini.png',
                'Smoking Area' => 'assets/img/smoking_area.png',
                'TV' => 'assets/img/tv_amini.png',
            );
    
            foreach ($term_data as $term_name => $image_filename) {
                $existing_term = term_exists($term_name, 'room_amenities');
    
                if (!$existing_term) {
                    $term_data = wp_insert_term($term_name, 'room_amenities');
    
                    if (!is_wp_error($term_data)) {
                        $term_id = $term_data['term_id'];
                        $image_path = $this->main_dir . $image_filename;
                        $attachment_id = $this->supload_image_from_url($image_path);
    
                        if ($attachment_id) {
                            update_term_meta($term_id, 'hm_room_term_img', $attachment_id);
                        }
                    }
                }
            }
        }
        // Check if 'hotel_amenities' taxonomy is empty
        $hotel_amenities_terms = get_terms(array(
            'taxonomy' => 'hotel_amenities',
            'hide_empty' => true,
        ));
        if (empty($hotel_amenities_terms) && !$active_ones ) {
            $term_data = array(
                '24 hour Food' => 'assets/img/food.png',
                'Gym' => 'assets/img/gym.png',
                'Laundry' => 'assets/img/laundry.png',
                'Parking' => 'assets/img/parking.png',
                'Resturant' => 'assets/img/resturant.png',
                'Room Service' => 'assets/img/room_Ser.png',
                'Spa' => 'assets/img/spa.png',
                'Swimming Pool' => 'assets/img/swimming.png',
            );
    
            foreach ($term_data as $term_name => $image_filename) {
                $existing_term = term_exists($term_name, 'hotel_amenities');
    
                if (!$existing_term) {
                    $term_data = wp_insert_term($term_name, 'hotel_amenities');
    
                    if (!is_wp_error($term_data)) {
                        $term_id = $term_data['term_id'];
                        $image_path = $this->main_dir . '/' . $image_filename;
                        $attachment_id = $this->supload_image_from_url($image_path);
    
                        if ($attachment_id) {
                            update_term_meta($term_id, 'hm_room_term_img', $attachment_id);
                        }
                    }
                }
            }
        }
        update_option('elite_stay_helper_activation',true);
    }
    public function eshelite_home_booking_form() {
        $html = '';
    
        $html .= '<div class="container hm_home_rqform">';
        $html .= '<h4>' . esc_html__('Experience Something New', 'elite-stay-helper') . '</h4>';
        $html .= '<form action="#" method="post" class="hm_home_rqself">';
        $html .= '<div class="hmrq_form_iw_fields">';
        
        // Form fields
        $html .= '<div class="hm_checkinout_date">';
        $html .= '<div class="form-group hm_datepickers_dtc">';
        $html .= '<label for="arrival-date" class="hm_home-label">' . esc_html__('Arrival Date: ', 'elite-stay-helper') . '</label>';
        $html .= '<input type="text" id="arrival-date" name="arrival_date" class="hm_home-input" required placeholder="' . esc_attr__('Select Date', 'elite-stay-helper') . '">';
        $html .= '<div class="hm_home_datepicker arrival_datepicker"></div>';
        $html .= '</div>';
        $html .= '<div class="form-group">';
        $html .= '<label for="no_of_rooms" class="hm_home-label">' . esc_html__('No of Rooms:', 'elite-stay-helper') . '</label>';
        $html .= '<input type="number" id="no_of_rooms" name="no_of_rooms" class="hm_home-input" min="1" required placeholder="' . esc_attr__('Enter Rooms', 'elite-stay-helper') . '">';
        $html .= '</div>';
        $html .= '</div>';
        
        $html .= '<div class="hm_form_grp_fields">';
        $html .= '<div class="form-group hm_datepickers_dtc">';
        $html .= '<label for="departure-date" class="hm_home-label">' . esc_html__('Departure Date:', 'elite-stay-helper') . '</label>';
        $html .= '<input type="text" id="departure-date" name="departure_date" class="hm_home-input" required placeholder="' . esc_attr__('Select Date', 'elite-stay-helper') . '">';
        $html .= '<div class="hm_home_datepicker departure_datepicker"></div>';
        $html .= '</div>';
        $html .= '<div class="form-group">';
        $html .= '<label for="no-of-persons" class="hm_home-label">' . esc_html__('Number of Persons: ', 'elite-stay-helper') . '</label>';
        $html .= '<input type="number" id="no-of-persons" name="num_persons" class="hm_home-input" min="1" required placeholder="' . esc_attr__('Select Persons', 'elite-stay-helper') . '">';
        $html .= '</div>';
        $html .= '</div>';
        
        $html .= '</div>';
        
        $html .= '<div class="hmrq_form_btns">';
        $html .= '<div class="form-group">';
        $html .= '<input type="hidden" value="' . esc_url(site_url()) . '" name="site_url" class="site_url">';
        $html .= '<button type="submit" class="hm_home-button hm_global_btns hm_second_btns hm_bookingfbtn">' . esc_html__('Send a Booking Request', 'elite-stay-helper') . '</button>';
        $html .= '<div class="hm_home_rq_error"></div>';
        $html .= '</div>';
        $html .= '</div>';
        
        $html .= '</form>';
        $html .= '</div>';
    
        return $html;
    }
    public function eshelite_home_newsletter_form_callback() {
        $loader_url = esc_url($this->main_dir_files . '/img/yellow_.gif');
    
        $html = '';
    
        $html .= '<div class="hm_news_box hm_home_newsletter_form">';
        $html .= '<form action="#" method="post" class="hm_home_newsself" name="hm_home_newsself">';
        $html .= '<div class="form-group">';
        $html .= '<input type="email" id="user_email" name="user_email" class="hm_news_input" required placeholder="' . esc_attr__('Enter Your Email', 'elite-stay-helper') . '">';
        $html .= '</div>';
        $html .= '<div class="form-group">';
        $html .= '<input type="hidden" class="hm-site-button" value="hmnews_frm_frontsubmit" name="action">';
        $html .= wp_nonce_field('ajax-nonce', 'nonce', true, false); // Passing true and false to echo and not include extra hidden fields
        $html .= '<button class="hm_news-button hm_global_btns hm_second_btns">' . esc_html__('Submit', 'elite-stay-helper') . '</button>';
        $html .= '</div>';
        $html .= '</form>';
        $html .= '<div class="hm_newsletter_loader">';
        $html .= '<div class="hm_loader_div">';
        $html .= '<img src="' . $loader_url . '" alt="loader" class="hm_loader_img">';
        $html .= '</div>';
        $html .= '</div>';
        $html .= '<div class="hm_form_response"></div>';
        $html .= '</div>';
    
        return $html;
    }
    public function eshelite_save_room_amenities_image_field($term_id) {
        if (isset($_POST['elite-stay-helper-nonce']) &&  wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['elite-stay-helper-nonce'] ) ), 'elite-stay-helper-action')) {
            if (isset($_POST['acid'])) {
                $image = sanitize_text_field($_POST['acid']);
                update_term_meta($term_id, 'hm_room_term_img', $image);
            }
        } 
    }
    public function eshelite_taxonomy_room_amini_custom_field() {
        ?>
        <div class="form-field term-group">
            <label for="amini_image"><?php esc_html_e('Amini Image', 'elite-stay-helper'); ?></label>
            <input type="button" class="button amini-image-upload-button" value="<?php esc_html_e('Upload Image', 'elite-stay-helper'); ?>">
            <input type="hidden" id="acurl">
            <input type="hidden" id="acid" name="acid">
            <br />
            <div id='icpreview' class="icviewimg"></div>
        </div>
        <?php
        wp_nonce_field('elite-stay-helper-action', 'elite-stay-helper-nonce');
    }
    public function eshelite_edit_taxonomy_room_amini_custom_field($term) {
        $image = intval(get_term_meta($term->term_id, 'hm_room_term_img', true)); // Ensure $image is an integer
        $url = esc_url(wp_get_attachment_url($image));
        ?>
        <tr class="form-field term-group-wrap">
            <th scope="row">
                <label for="amini_abcs_image"><?php esc_html_e('Aminites Image', 'elite-stay-helper'); ?></label>
            </th>
            <td class="iconviewtd">
                <input type="button" class="button amini-image-upload-button" value="<?php esc_html_e('Upload Image', 'elite-stay-helper'); ?>">
                <br />
                <input type="hidden" id="acurl" name="amini_acurl" value="<?php echo esc_attr($url); ?>">
                <input type="hidden" id="acid" name="acid" value="<?php echo esc_attr($image); ?>">
                <div id='icpreview'><img src="<?php echo esc_url($url); ?>" class="amini_old_image" style="max-width: 100px; max-height: 100px;"></div>
            </td>
        </tr>
        <?php
        wp_nonce_field('elite-stay-helper-action', 'elite-stay-helper-nonce');
    }
    public function eshelite_cpts_meta() {
        add_meta_box('hm_rooms_main_features', __('Main Features', 'elite-stay-helper'), array($this, 'hm_rooms_render_main_features_meta_box'), 'hm_rooms', 'normal', 'high');
        add_meta_box('hm_rooms_hotel_rules', __('Hotel Rules', 'elite-stay-helper'), array($this, 'hm_rooms_render_hotel_rules_meta_box'), 'hm_rooms', 'normal', 'high');
        add_meta_box('testimonial_rating', __('Rating', 'elite-stay-helper'), array($this, 'render_testimonial_rating_meta_box'), 'hm_testimonial', 'normal', 'default');
        add_meta_box('posts_images', __('Images', 'elite-stay-helper'), array($this, 'render_image_meta_box'), 'post', 'normal', 'default');
        add_meta_box('offers_meta', __('Offers Details', 'elite-stay-helper'), array($this, 'render_offers_meta'), 'hm_offers', 'normal', 'default');
    }
    public function hm_rooms_render_main_features_meta_box($post) {
        // Retrieve existing values from the database
        $number_of_beds = sanitize_text_field(get_post_meta($post->ID, 'hmnumber_of_beds', true));
        $number_of_guests = sanitize_text_field(get_post_meta($post->ID, 'hmnumber_of_guests', true));
        $number_of_baths = sanitize_text_field(get_post_meta($post->ID, 'hmnumber_of_baths', true));
        $square_feet = sanitize_text_field(get_post_meta($post->ID, 'hmsquare_feet', true));            
        $view = sanitize_text_field(get_post_meta($post->ID, 'hmview', true));
        $room_price = intval(get_post_meta($post->ID, 'hmrooms_price', true));
        $hm_room_tagline = esc_textarea(get_post_meta($post->ID, 'hm_room_tagline', true));
        ?>
            <div class="main_wrap_section">
                <div class="wrap_class">
                    <label for="number_of_beds"><?php esc_html_e('Number of Beds:', 'elite-stay-helper'); ?></label>
                    <input type="text" name="number_of_beds" id="number_of_beds" value="<?php echo esc_attr($number_of_beds); ?>">
                </div>
                <div class="wrap_class">
                    <label for="number_of_guests"><?php esc_html_e('Number of Guests:', 'elite-stay-helper'); ?></label>
                    <input type="text" name="number_of_guests" id="number_of_guests" value="<?php echo esc_attr($number_of_guests); ?>">
                </div>
                <div class="wrap_class">
                    <label for="square_feet"><?php esc_html_e('Square Feet:', 'elite-stay-helper'); ?></label>
                    <input type="text" name="square_feet" id="square_feet" value="<?php echo esc_attr($square_feet); ?>">
                </div>
                <div class="wrap_class">
                    <label for="view"><?php esc_html_e('View:', 'elite-stay-helper'); ?></label>
                    <input type="text" name="view" id="view" value="<?php echo esc_attr($view); ?>">
                </div>
                <div class="wrap_class">
                    <label for="number_of_baths"><?php esc_html_e('Number Of Bathrooms', 'elite-stay-helper'); ?></label>
                    <input type="text" name="number_of_baths" id="number_of_baths" value="<?php echo esc_attr($number_of_baths); ?>">
                </div>
                <div class="wrap_class">
                    <label for="room_price"><?php esc_html_e('Room Price', 'elite-stay-helper'); ?></label>
                    <input type="number" name="hm_room_price" id="hm_room_price" value="<?php echo esc_attr($room_price); ?>">
                </div>
                <div class="wrap_class">
                    <label for="hm_room_tagline"><?php esc_html_e('Room Tag Line', 'elite-stay-helper'); ?></label>
                    <textarea rows="4" cols="50" name="hm_room_tagline" id="hm_room_tagline"><?php echo esc_html($hm_room_tagline); ?></textarea>
                </div>
            </div>
        <?php
    }
    public function hm_rooms_render_hotel_rules_meta_box($post) {
        // Retrieve existing values from the database
        $hotel_rules = esc_textarea(get_post_meta($post->ID, 'hmhotel_rules', true));
        $room_images = array_map('intval', (array) get_post_meta($post->ID, 'hm_rooms_gallery', true));
        $hm_room_preCode = intval(get_post_meta($post->ID, 'hm_room_preCode', true));
        ?>
        <div class="hm_rooms_meta_boxes">
            <div class="hm_rooms_wrap">
                <label for="hotel_rules"><?php esc_html_e('Hotel Rules:', 'elite-stay-helper'); ?></label>
                <textarea name="hotel_rules" id="hotel_rules" rows="4"><?php echo esc_textarea($hotel_rules); ?></textarea>
            </div>
            <div class="hm_select_offers_div">
                <label><?php esc_html_e('Select Offers To Apply', 'elite-stay-helper'); ?></label>
                <?php
                // Retrieve selected post IDs from post meta
                $selected_post_ids = array_map('intval', (array) get_post_meta($post->ID, 'hm_rooms_related_offers', true));
                // Arguments to query the custom post type "hm_offers"
                $args = array(
                    'post_type' => 'hm_offers',
                    'post_status' => 'publish',
                    'posts_per_page' => -1, // Retrieve all posts
                );
                $query = new \WP_Query($args);
                if ($query->have_posts()) {
                    ?>
                        <select name="hm_offer_post[]" multiple>
                            <?php
                                while ($query->have_posts()) {
                                    $query->the_post();
                                    $post_id = get_the_ID();
                                    $post_title = get_the_title();
                                    $selected = in_array($post_id, $selected_post_ids) ? 'selected' : '';
                                    $option_value = intval($post_id);
                                    $option_text = esc_html($post_title);
                                    echo "<option value='" . esc_attr($option_value) . "'".esc_attr($selected) .">" . esc_attr($option_text) . "</option>";
                                }
                    
                            ?>
                        </select>
                    <?php
                }
                wp_reset_postdata(); // Restore original post data
                ?>
            </div>
            <div class="hm_roomsidiv">
                <label for="hm_rooms_images"><?php esc_html_e('Select Room Images:', 'elite-stay-helper'); ?></label>
                <input type="button" class="button samini-image-upload-button" value="<?php esc_html_e('Select Images', 'elite-stay-helper'); ?>">     
                <div class="hm_rooms_gallery_image">    
                    <div class="hm_rooms_upfront" img_count="<?php echo count($room_images); ?>">
                        <?php
                        if (!empty($room_images)) {
                            foreach ($room_images as $key => $value) {
                                $img_url =  wp_get_attachment_image_url($value);
                            ?>
                                <div class="hm_blogs_upfront_iview" img_count="<?php echo count($room_images); ?>">
                                    <div class="hm_img_idrwrap">
                                        <img src="<?php echo esc_url($img_url); ?>">
                                        <input type="hidden" name="hm_room_old_images[]" value="<?php echo esc_attr($value); ?>">
                                        <div class="img_remove img_clsicon">X </div>
                                    </div>
                                </div>
                            <?php
                            }
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
        // Load PHP variables
        $hmpremium_agentcode = intval(get_option('hmpremium_agentcode'));
        $hmpremium_hotelcode = intval(get_option('hmpremium_hotelcode'));
        if (!empty($hmpremium_agentcode) && !empty($hmpremium_hotelcode)) {
        ?>
            <div class="hm_rooms_premium_code">
                <div class="hm_rooms_premium_codewrap">
                    <label for="room_code"><?php esc_html_e('Room Code :', 'elite-stay-helper'); ?></label>
                    <input type="number" placeholder="<?php esc_html_e('Room Premium Code', 'elite-stay-helper'); ?>" name="hm_room_preCode" value="<?php echo esc_attr($hm_room_preCode); ?>">
                </div>
            </div>
        <?php
        }
    }
    public function render_testimonial_rating_meta_box($post) {
        $rating = intval(get_post_meta($post->ID, 'hm_testimonial_ratings', true));
        $testimonial_desg = get_post_meta($post->ID, 'hm_testimonial_designation', true);
        $testimonial_desg = sanitize_text_field($testimonial_desg);
        ?>
        
        <label for="testimonial_rating"><?php esc_html_e('Rating:', 'elite-stay-helper'); ?></label>
        <select name="testimonial_rating" id="testimonial_rating">
            <?php
            for ($i = 1; $i <= 5; $i++) {
                $selected = selected($rating, $i, false);
                echo "<option value='" . esc_attr($i) . "' ".esc_attr($selected).">" . esc_html($i) . "</option>";
            }
            ?>
        </select>
        <label for="testimonial_designation"><?php esc_html_e('Designation:', 'elite-stay-helper'); ?></label>
        <input type="text" value="<?php echo esc_attr($testimonial_desg); ?>" name="hm_testimonial_designation" id="hm_testimonial_designation">
        <?php
    } 
    public function render_image_meta_box($post) {
        $images = get_post_meta($post->ID, 'hm_blogs_gallery', true);
        $description = get_post_meta($post->ID, 'hm_blogs_description', true);
    
         wp_nonce_field('custom_image_upload_nonce', 'custom_image_upload_nonce');
        ?>
        <label for="description"><?php esc_html_e('Description:', 'elite-stay-helper'); ?></label>
        <textarea id="description" name="hm_blogs_description" rows="4" cols="50" required><?php echo esc_textarea($description); ?></textarea>
        <div class="hm_select_images">
            <label for="hm_blogs_images"><?php esc_html_e('Select Images:', 'elite-stay-helper'); ?></label>
            <input type="button" class="button blogs-image-upload-button" value="<?php esc_html_e('Upload Image', 'elite-stay-helper'); ?>">
        </div>
        <div id="image_attachment_ids"></div>
        <div id="image-preview-container"></div>
        <div id="hm_blogs_image_preview">
            <?php
            foreach ($images as $ipid) {
                $image_url = wp_get_attachment_url(intval($ipid));
                ?>
                <div class="image-preview">
                    <img src="<?php echo esc_url($image_url); ?>">
                    <input type="hidden" name="image_attachment_ids[]" value="<?php echo intval($ipid); ?>">
                    <span class="delete-image">X</span>
                </div>
                <?php
            }
            ?>
        </div>
        <?php
    }
    public function render_offers_meta($post) {
        $hm_offers_tagline = get_post_meta($post->ID, 'hm_offers_tagline', true);
        $hm_offers_date = get_post_meta($post->ID, 'hm_offers_date', true);
        ?>
        <div class="hm_offers_meta">
            <label for="hm_offers_tagline"><?php esc_html_e('Offers Tagline:', 'elite-stay-helper'); ?></label>
            <input type="text" id="hm_offers_tagline" class="hm_offers_input" name="hm_offers_tagline" placeholder="<?php esc_html_e('Enter Tagline', 'elite-stay-helper'); ?>" value="<?php echo esc_attr($hm_offers_tagline); ?>">
            <label for="hm_offers_date"><?php esc_html_e('Date:', 'elite-stay-helper'); ?></label>
            <input type="date" id="hm_offers_date" class="hm_offers_input" name="hm_offers_date" value="<?php echo esc_attr($hm_offers_date); ?>">
        </div>
        <?php
    }
    public function eshelite_save_metadata($post_id) {
        if ( ! isset( $_POST['_wpnonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['_wpnonce'] )) , 'update-post_' . $post_id ) ) {
            return;
        }          
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return $post_id;
        }
        $post_type = get_post_type($post_id);
        if ($post_type === 'hm_testimonial') {
            if (isset($_POST)) {
                if (isset($_POST['testimonial_rating'])) {
                    update_post_meta($post_id, 'hm_testimonial_ratings', intval($_POST['testimonial_rating']));
                }
                if (isset($_POST['hm_testimonial_desg'])) {
                    update_post_meta($post_id, 'hm_testimonial_designation', sanitize_text_field($_POST['hm_testimonial_desg']));
                }
            }
        }
        if (isset($_POST) && $post_type === 'hm_rooms') {
            $fields_to_update = array(
                "hmnumber_of_beds" => 'number_of_beds',
                "hmnumber_of_guests" => 'number_of_guests',
                "hmnumber_of_baths" => 'number_of_baths',
                "hmrooms_price" => 'hm_room_price',
                "hmsquare_feet" => 'square_feet',
                "hmview" => 'view',
                "hmhotel_rules" => 'hotel_rules',
                "hm_room_tagline" => 'hm_room_tagline',
                "hm_room_preCode" => 'hm_room_preCode'
            );
    
            foreach ($fields_to_update as $meta_key => $request_key) {
                if (isset($_REQUEST[$request_key])) {
                    update_post_meta($post_id, $meta_key, sanitize_text_field($_REQUEST[$request_key]));
                }
            }
            if (!empty($_POST['hm_offer_post'])) {
                $post_filters = array(
                    'hm_offer_post' => array(
                        'filter' => FILTER_VALIDATE_INT,
                        'flags' => FILTER_REQUIRE_SCALAR
                    )
                );
                
                $filtered_posts = filter_var_array($_POST['hm_offer_post'], $post_filters);
                
                $filtered_posts = array_filter($filtered_posts, 'intval');
                
                if (!empty($filtered_posts)) {
                    update_post_meta($post_id, 'hm_rooms_related_offers', $filtered_posts);
                }
            }
            $old_images_filters = array(
                'filter' => FILTER_VALIDATE_INT,
                'flags' => FILTER_REQUIRE_SCALAR 
            );
            $old_room_images = isset($_POST['hm_room_old_images']) ? filter_var_array($_POST['hm_room_old_images'], $old_images_filters) : array();
            update_post_meta($post_id, 'hm_rooms_gallery', $old_room_images);
        }
        if ($post_type === 'post') {
            if (isset($_POST['hm_blogs_description'])) {
                update_post_meta($post_id, 'hm_blogs_description', sanitize_text_field($_POST['hm_blogs_description']));
            }
            $image_attachment_ids = array();
            if (isset($_POST['image_attachment_ids'])) {
                $element_filters = array(
                    'filter' => FILTER_VALIDATE_INT,
                    'flags' => FILTER_REQUIRE_SCALAR 
                );
            
                $image_attachment_ids = filter_var_array($_POST['image_attachment_ids'], $element_filters);
                
                $image_attachment_ids = array_filter($image_attachment_ids, 'intval');
            }
            
            update_post_meta($post_id, 'hm_blogs_gallery', $image_attachment_ids);
        }
        if ($post_type === 'hm_offers') {
            if (isset($_POST['hm_offers_tagline'])) {
                $hm_otagline = sanitize_text_field($_POST['hm_offers_tagline']);
                update_post_meta($post_id, 'hm_offers_tagline', $hm_otagline);
            }
            if (isset($_POST['hm_offers_date'])) {
                $hm_offers_date = $_POST['hm_offers_date'];
                $date_pattern = '/^\d{4}-\d{2}-\d{2}$/';
                if (preg_match($date_pattern, $hm_offers_date)) {
                    $sanitized_hm_offers_date = $hm_offers_date;
                } else {
                    $sanitized_hm_offers_date = ''; // Default value
                }
                update_post_meta($post_id, 'hm_offers_date', $hm_offers_date);
            }
        }
    }
    public function eshelite_hidden_gems_preview_callback($atts) {
        $output = ''; // Initialize the output variable
    
        $hgem_shortcode_np = get_option('hm_hgem_shortcode_np');
        $hgem_shortcode_cg = get_option('hm_hgem_shortcode_cg');
        
        if (empty($hgem_shortcode_np)) {
            $hgem_shortcode_np = -1;
            
        }
        if(empty($hgem_shortcode_cg)){
            $hgem_shortcode_cg = 6;
        }
    
        $args = array(
            'post_type'      => 'hm_hidden_gem',
            'posts_per_page' => $hgem_shortcode_np,
        );
    
        // Query all posts of the 'hm_nearby_location' custom post type
        $query = new \WP_Query($args);
    
        $output .= '<div class="hm_nearby_location owl-carousel" id="hm_nearby_location" hgems="' . $hgem_shortcode_cg . '">';
    
        if ($query->have_posts()) {
            while ($query->have_posts()) {
                $query->the_post();
                $post_id    = get_the_ID();
                $title      = sanitize_text_field(get_the_title());
                $thumbnail_url  = get_the_post_thumbnail_url($post_id, 'full');
                $permalink  = '#';
    
                $output .= '<div class="hm_nearby_item">';
                $output .= '<a href="' . esc_url($permalink) . '">';
                $output .= '<img src="'.esc_url($thumbnail_url).'">';
                $output .= '<span>' . esc_html($title) . '</span>';
                $output .= '</a>';
                $output .= '</div>';
            }
        }
    
        $output .= '</div>';
    
        wp_reset_postdata();
    
        return $output; // Return the captured HTML as a string
    }
    
    public function eshelite_roomspg_room_preview_callback() {
        $output = ''; // Initialize the output variable
    
        $rompargs = array(
            'post_type'      => 'hm_rooms',
            'posts_per_page' => -1,
        );
    
        // Query all posts of the 'hm_rooms' custom post type
        $rompquery = new \WP_Query($rompargs);
    
        if ($rompquery->have_posts()) {
            $output .= '<div class="hm_room_pg_rooms_main">';
            $output .= '<div class="hm_room_pg_rooms_inner">';
            $output .= '<ul class="hm_room_pg_rooms_ul">';
            while ($rompquery->have_posts()) {
                $rompquery->the_post();
                $rooms_id       = get_the_ID();
                $rooms_title    = get_the_title($rooms_id);
                $rooms_content  = get_the_content($rooms_id);
                $number_of_beds = esc_attr(get_post_meta($rooms_id, 'hmnumber_of_beds', true));
                $number_of_guests = esc_attr(get_post_meta($rooms_id, 'hmnumber_of_guests', true));
                $square_feet    = esc_attr(get_post_meta($rooms_id, 'hmsquare_feet', true));
                $number_of_baths = esc_attr(get_post_meta($rooms_id, 'hmnumber_of_baths', true));
                $view           = esc_attr(get_post_meta($rooms_id, 'hmview', true));
                $site_murl      = get_template_directory_uri() . '/assets/img';
                $room_permalink = get_the_permalink($rooms_id);
                $room_price     = esc_attr(get_post_meta($rooms_id, 'hmrooms_price', true));
                $room_fimg      = get_the_post_thumbnail_url($rooms_id);
    
                $output .= '<li class="hm_room_pg_rooms_li" data-id="' . esc_attr($rooms_id) . '">';
                $output .= '<div class="hm_room_pg_room_self">';
                if ($room_price) {
                    $output .= '<div class="hm_room_pg_room_price">';
                    $output .= '<p class="hm_room_price_Self">' . esc_html__('From', 'elite-stay-helper') . ' <strong>$' . esc_html($room_price) . '</strong>' . esc_html__('/per night', 'elite-stay-helper') . '</p>';
                    $output .= '</div>';
                }
                $output .= '<div class="hm_room_pg_room_fimg">';
                $output .= '<img src="' . esc_url($room_fimg) . '">';
                $output .= '</div>';
                $output .= '<div class="hm_room_pg_room_content">';
                $output .= '<div class="hm_room_title">';
                $output .= '<h4>' . esc_html($rooms_title) . '</h4>';
                $output .= '</div>';
                $output .= '<div class="hm_room_cmeta_yellow">';
                if (!empty($square_feet)) {
                    $output .= '<p>' . esc_html($square_feet) . '</p>';
                }
                if (!empty($view)) {
                    $output .= '<p>' . esc_html($view) . '</p>';
                }
                if (!empty($number_of_guests)) {
                    $output .= '<p>' . esc_html($number_of_guests) . '</p>';
                }
                $output .= '</div>';
                $output .= '<div class="hm_room_cmeta_normal">';
                if (!empty($number_of_beds)) {
                    $output .= '<div class="hm_room_cstmmeta">';
                    $output .= '<img src="' . esc_url($site_murl . 'bedoutline.png') . '" class="hm_room_blogo">';
                    $output .= '<p class="hm-room-meta">' . esc_html($number_of_beds) . '</p>';
                    $output .= '</div>';
                }
                if (!empty($number_of_guests)) {
                    $output .= '<div class="hm_room_cstmmeta">';
                    $output .= '<img src="' . esc_url($site_murl . 'people.png') . '" class="hm_room_blogo">';
                    $output .= '<p class="hm-room-meta">' . esc_html($number_of_guests) . '</p>';
                    $output .= '</div>';
                }
                if (!empty($number_of_baths)) {
                    $output .= '<div class="hm_room_cstmmeta">';
                    $output .= '<img src="' . esc_url($site_murl . 'bathroom.png') . '" class="hm_room_blogo">';
                    $output .= '<p class="hm-room-meta">' . esc_html($number_of_baths) . '</p>';
                    $output .= '</div>';
                }
                $output .= '</div>';
                $output .= '<div class="hm_room_exce">';
                $output .= '<p>' . esc_html($rooms_content) . '</p>';
                $output .= '</div>';
                $output .= '<div class="hm_room_book_now">';
                $output .= '<div class="hm-room-booknow">';
                $output .= '<button class="hm-room-bbtn">';
                $output .= '<a href="' . esc_url($room_permalink) . '">' . esc_html__('Book Now', 'elite-stay-helper') . '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none"><path d="M6.61598 2.54506C6.38164 2.77947 6.25 3.09735 6.25 3.42881C6.25 3.76027 6.38164 4.07815 6.61598 4.31256L12.8035 10.5001L6.61598 16.6876C6.38829 16.9233 6.26229 17.2391 6.26514 17.5668C6.26799 17.8946 6.39945 18.2081 6.63121 18.4398C6.86297 18.6716 7.17649 18.8031 7.50423 18.8059C7.83198 18.8088 8.14773 18.6828 8.38348 18.4551L15.4547 11.3838C15.6891 11.1494 15.8207 10.8315 15.8207 10.5001C15.8207 10.1686 15.6891 9.85072 15.4547 9.61631L8.38348 2.54506C8.14907 2.31072 7.83119 2.17908 7.49973 2.17908C7.16828 2.17908 6.85039 2.31072 6.61598 2.54506Z" fill="black" /></svg></a>';
                $output .= '</button>';
                $output .= '</div>';
                $output .= '</div>';
                $output .= '</div>';
                $output .= '</div>';
                $output .= '</li>';
            }
            $output .= '</ul>';
            $output .= '</div>';
            $output .= '</div>';
            wp_reset_postdata();
        } else {
            $output .= '<div class="hm_rooms_g_norooms">' . esc_html__('No Rooms Found !', 'elite-stay-helper') . '</div>';
        }
    
        return $output;
    }
    public function eshelite_testimonials_callback($atts) {
        $soutput = ''; // Initialize the output variable
    
        $htestimonial_shortcode_np = intval(get_option('hm_htestimonial_shortcode_np'));
        $htestimonial_shortcode_cg = intval(get_option('hm_htestimonial_shortcode_cg'));
    
        if (empty($htestimonial_shortcode_np)) {
            $htestimonial_shortcode_np = 3;
        }
        if(empty($htestimonial_shortcode_cg)){
            $htestimonial_shortcode_cg = 2;
        }
    
        $sargs = array(
            'post_type'      => 'hm_testimonial',
            'posts_per_page' => $htestimonial_shortcode_np,
        );
    
        // Query all posts of the 'hm_testimonial' custom post type
        $squery = new \WP_Query($sargs);
    
        $soutput .= '<div class="hm_testimonial_shortcode" tmonial="' . esc_attr($htestimonial_shortcode_cg) . '">';
    
        if ($squery->have_posts()) {
            $soutput .= '<div class="hm_testimonial_iwrap">';
            $soutput .= '<div class="hm_testimonial_ulwrap">';
            $soutput .= '<div class="hm_testimonial_ul owl-carousel" id="hm_testimonial_shortcode">';
            while ($squery->have_posts()) {
                $squery->the_post();
                $post_id             = get_the_ID();
                $testi_title         = esc_html(get_the_title());
                $testi_content       = get_the_content();
                $trimmed_content     = wp_kses_post(wp_trim_words($testi_content, 55));
                $thumbnail           = esc_url(get_the_post_thumbnail_url($post_id, 'thumbnail') ?: get_template_directory_uri() . '/assets/img/testimonial.png');
                $testimonial_desg    = esc_html(get_post_meta($post_id, 'hm_testimonial_designation', true));
                $testimonial_ratings = intval(get_post_meta($post_id, 'hm_testimonial_ratings', true));
                $star_img_path       = get_template_directory_uri() . '/assets/img/star' . $testimonial_ratings . '.svg';
    
                $soutput .= '<div class="hm_testimonial_li" data_id="' . esc_attr($post_id) . '">';
                $soutput .= '<div class="hm_testimonial_img">';
                $soutput .= '<img src="' . esc_url($thumbnail) . '" alt="' . esc_attr($testi_title) . '">';
                $soutput .= '</div>';
                $soutput .= '<div class="hm_testimonial_contentpart">';
                $soutput .= '<div class="hm_testimonial_content">';
                $soutput .= '<p>' . esc_attr($trimmed_content) . '</p>';
                $soutput .= '</div>';
                $soutput .= '<div class="hm_testimonial_title">';
                $soutput .= '<p>' . esc_attr($testi_title) . '</p>';
                $soutput .= '</div>';
                $soutput .= '<div class="hm_testimonial_desg">';
                $soutput .= '<span>' . esc_attr($testimonial_desg) . '</span>';
                $soutput .= '</div>';
                $soutput .= '<div class="hm_testimonial_ratings">';
                $soutput .= '<img src="' . esc_url($star_img_path) . '" alt="' . esc_attr('Rating: %d', 'elite-stay-helper') . '">';
                $soutput .= '</div>';
                $soutput .= '</div>';
                $soutput .= '</div>';
            }
            $soutput .= '</div>'; // .hm_testimonial_ul owl-carousel
            $soutput .= '</div>'; // .hm_testimonial_ulwrap
            $soutput .= '</div>'; // .hm_testimonial_iwrap
        }
    
        $soutput .= '</div>'; // .hm_testimonial_shortcode
    
        wp_reset_postdata();
    
        return $soutput;
    } 
    
    public function eshelite_rooms_preview_callback($atts) {
        $hrooms_shortcode_np = intval(get_option('hm_hrooms_shortcode_np'));
        if (empty($hrooms_shortcode_np)) {
            $hrooms_shortcode_np = 3;
        }
        $output = ''; // Initialize the output variable
        $args = array(
            'post_type'      => 'hm_rooms',
            'posts_per_page' => $hrooms_shortcode_np,
        );
        $query = new \WP_Query($args);
        if ($query->have_posts()) {
            $output .= '<div class="hm_rooms_main">';
            while ($query->have_posts()) : $query->the_post();
                $image = esc_url(get_the_post_thumbnail_url(get_the_ID()));
                $title = esc_html(get_the_title());
                $number_of_beds = esc_html(get_post_meta(get_the_ID(), 'hmnumber_of_beds', true));
                $number_of_guests = esc_html(get_post_meta(get_the_ID(), 'hmnumber_of_guests', true));
                $room_permalink = esc_url(get_the_permalink());
                $rate = esc_html(sanitize_text_field(get_post_meta(get_the_ID(), 'hmrooms_price', true)));
                $output .= '<div class="hm-room-single" data-id="' . esc_attr(get_the_ID()) . '">';
                $output .= '<div class="hm_room_rate_img">';
                if (!empty($image)) {
                    $output .= '<div class="hm-room-image"><img src="' . esc_url($image) . '"></div>';
                }
                if (!empty($rate)) {
                    $output .= '<div class="hm_room_pg_room_self">';
                    $output .= '<div class="hm_room_pg_room_price">';
                    $output .= '<p class="hm_room_price">From<strong>$' . esc_html($rate) . '</strong>/Per Night</p>';
                    $output .= '</div>';
                    $output .= '</div>';
                }
                $output .= '</div>';
                $output .= '<div class="hm-room-contents">';
                $output .= '<h5 class="hm-room-title">' . esc_html($title) . '</h5>';
                $output .= '<div class="hm-room-cwrap">';
                if ($number_of_beds != '') {
                    $output .= '<div class="hm_room_cstmmeta">';
                    $output .= '<img src="' . esc_url($this->main_dir) . '/assets/img/bed-outline.png" class="hm_room_blogo">';
                    $output .= '<p class="hm-room-meta">' . esc_html($number_of_beds) . '</p>';
                    $output .= '</div>';
                }
                if ($number_of_guests != '') {
                    $output .= '<div class="hm_room_cstmmeta">';
                    $output .= '<img src="' . esc_url($this->main_dir) . '/assets/img/guest.png" class="hm_room_glogo">';
                    $output .= '<p class="hm-Guests-meta">' . esc_html($number_of_guests) . '</p>';
                    $output .= '</div>';
                }
                $output .= '</div>';
                $output .= '<div class="hm-room-booknow">';
                $output .= '<button class="hm-room-bbtn">';
                $output .= '<a href="' . esc_url($room_permalink) . '">' . esc_html__('Book Now', 'elite-stay-helper');
                $output .= '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none">';
                $output .= '<path d="M6.61598 2.54506C6.38164 2.77947 6.25 3.09735 6.25 3.42881C6.25 3.76027 6.38164 4.07815 6.61598 4.31256L12.8035 10.5001L6.61598 16.6876C6.38829 16.9233 6.26229 17.2391 6.26514 17.5668C6.26799 17.8946 6.39945 18.2081 6.63121 18.4398C6.86297 18.6716 7.17649 18.8031 7.50423 18.8059C7.83198 18.8088 8.14773 18.6828 8.38348 18.4551L15.4547 11.3838C15.6891 11.1494 15.8207 10.8315 15.8207 10.5001C15.8207 10.1686 15.6891 9.85072 15.4547 9.61631L8.38348 2.54506C8.14907 2.31072 7.83119 2.17908 7.49973 2.17908C7.16828 2.17908 6.85039 2.31072 6.61598 2.54506Z" fill="black"/>';
                $output .= '</svg>';
                $output .= '</a>';
                $output .= '</button>';
                $output .= '</div>';
                $output .= '</div>';
                $output .= '</div>';
                endwhile;
                wp_reset_postdata();
                $output .= '</div>';
        } else {
            $output .= esc_html__('No rooms found.', 'elite-stay-helper');
        }
        return $output ; 
    }
    public function eshelite_blogs_preview_callback($atts) {
        $blogs_shortcode_np = intval(get_option('hm_blogs_shortcode_np'));
        $blogs_shortcode_cg = intval(get_option('hm_blogs_shortcode_cg'));
    
        if (empty($blogs_shortcode_np)) {
            
            $blogs_shortcode_np = 5;
           
        }
        if(empty($blogs_shortcode_cg)){
            $blogs_shortcode_cg = 3;
        }
        // Query all posts of the 'post' custom post type
        $query = new \WP_Query(array(
            'post_type'      => 'post',
            'posts_per_page' => $blogs_shortcode_np,
        ));
    
        $output = '';
    
        $output .= '<div class="hm_blogs_smain" blogs_data="' . esc_attr($blogs_shortcode_cg) . '">';
    
        if ($query->have_posts()) {
            $output .= '<div class="hm_blogs_iwrap">';
            $output .= '<div class="hm_blogs_ulwrap">';
            $output .= '<div class="hm_blogs_ul owl-carousel" id="hm_blogs_owl_slider">';
    
            while ($query->have_posts()) {
                $query->the_post();
                $post_id = get_the_ID();
                $thumbnail = get_the_post_thumbnail_url($post_id, 'thumbnail');
                $published_date = esc_html(get_the_date('Y-m-d', $post_id));
                $blogs_link = esc_url(get_the_permalink($post_id));
                $blogs_title = esc_html(get_the_title($post_id));
    
                $output .= '<div class="hm_blogs_li">';
                $output .= '<div class="hm_blogs_imgpart">';
                $output .= '<div class="hm_blogs_img"><img src="' . esc_url($thumbnail) . '" class="attachment-full size-full wp-post-image"></div>';
                $output .= '<div class="hm_blogs_date">';
                $output .= '<p><span class="dashicons dashicons-calendar"></span> ' . esc_html($published_date) . '</p>';
                $output .= '</div>';
                $output .= '</div>';
                $output .= '<div class="hm_blogs_contentpart">';
                $output .= '<div class="hm_blogs_title">';
                $output .= '<a href="' . esc_url($blogs_link) . '">' . $blogs_title . '</a>';
                $output .= '</div>';
                $output .= '</div>';
                $output .= '</div>';
            }
    
            $output .= '</div>';
            $output .= '</div>';
            $output .= '</div>';
        }
    
        $output .= '</div>';
    
        wp_reset_postdata();
    
        return $output;
    }
    public function eshelite_local_pg_hidden_gems_callback() {
        $local_shortcode_np = get_option('hm_localhgem_shortcode_np');
        $local_shortcode_cg = get_option('hm_localhgem_shortcode_cg');
    
        if (empty($local_shortcode_np)) {
            $local_shortcode_np = 6;
        }
        if(empty($local_shortcode_cg)){
            $local_shortcode_cg = 3;
        }
    
        $largs = array(
            'post_type'      => 'hm_hidden_gem',
            'posts_per_page' => intval($local_shortcode_np),
        );
    
        // Query all posts of the 'hm_hidden_gem' custom post type
        $lquery = new \WP_Query($largs);
    
        $output = '';
    
        $output .= '<div class="hm_hlocal_gems" loclhgems="' . intval($local_shortcode_cg) . '">';
    
        if ($lquery->have_posts()) {
            $output .= '<div class="hm_localhgem_iwrap">';
            $output .= '<div class="hm_localhgem_ulwrap">';
            $output .= '<div class="hm_localhgem_ul owl-carousel" id="hm_localhgem_owl_slider">';
    
            while ($lquery->have_posts()) {
                $lquery->the_post();
                $lhpost_id = get_the_ID();
                $lh_title = get_the_title();
                $lhthumbnail = get_the_post_thumbnail($lhpost_id, 'full');
                $hgem_link = get_the_permalink($lhpost_id);
    
                $output .= '<div class="hm_localhgem_li">';
                $output .= '<div class="hm_localhgem_imgpart">';
                $output .= '<div class="hm_localhgem_img">' . $lhthumbnail . '</div>';
                $output .= '<div class="hm_localhgem_contentpart">';
                $output .= '<h5 class="hm_localhgem_title">' . esc_html($lh_title) . '</h5>';
                $output .= '<div class="hm_localhgem_link">';
                $output .= '<a href="#"> ' . esc_html__('Discover Now', 'elite-stay-helper') . ' <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none"><path d="M6.61598 2.54506C6.38164 2.77947 6.25 3.09735 6.25 3.42881C6.25 3.76027 6.38164 4.07815 6.61598 4.31256L12.8035 10.5001L6.61598 16.6876C6.38829 16.9233 6.26229 17.2391 6.26514 17.5668C6.26799 17.8946 6.39945 18.2081 6.63121 18.4398C6.86297 18.6716 7.17649 18.8031 7.50423 18.8059C7.83198 18.8088 8.14773 18.6828 8.38348 18.4551L15.4547 11.3838C15.6891 11.1494 15.8207 10.8315 15.8207 10.5001C15.8207 10.1686 15.6891 9.85072 15.4547 9.61631L8.38348 2.54506C8.14907 2.31072 7.83119 2.17908 7.49973 2.17908C7.16828 2.17908 6.85039 2.31072 6.61598 2.54506Z" fill="black" /></svg></a>';
                $output .= '</div>';
                $output .= '</div>';
                $output .= '</div>';
                $output .= '</div>';
            }
    
            $output .= '</div>';
            $output .= '</div>';
            $output .= '</div>';
    
            wp_reset_postdata();
        }
    
        $output .= '</div>';
    
        return $output;
    }
    
    public function eshelite_adventures_callback() {
        $adventure_shortcode_np = get_option('hm_adventure_shortcode_np');
        $adventure_shortcode_cg = get_option('hm_adventure_shortcode_cg');
    
        if (empty($adventure_shortcode_np)) {
            $adventure_shortcode_np = 6;
        }
        if(empty($adventure_shortcode_cg)){
            $adventure_shortcode_cg = 3;
        }
        $adv_args = array(
            'post_type'      => 'hm_adventures',
            'posts_per_page' => intval($adventure_shortcode_np),
        );
    
        // Query all posts of the 'hm_adventures' custom post type
        $adv_query = new \WP_Query($adv_args);
    
        $output = '';
    
        $output .= '<div class="hm_hadventure_gems" locladv="' . intval($adventure_shortcode_cg) . '">';
    
        if ($adv_query->have_posts()) {
            $output .= '<div class="hm_adventure_iwrap">';
            $output .= '<div class="hm_adventure_ulwrap">';
            $output .= '<div class="hm_adventure_ul owl-carousel" id="hm_adventures_owl_slider">';
    
            while ($adv_query->have_posts()) {
                $adv_query->the_post();
                $advpost_id = get_the_ID();
                $adv_title = get_the_title();
                $advthumbnail = get_the_post_thumbnail($advpost_id, 'full');
                $adv_link = get_the_permalink($advpost_id);
    
                $output .= '<div class="hm_adventure_li">';
                $output .= '<div class="hm_adventure_imgpart">';
                $output .= '<div class="hm_adventure_img">' .$advthumbnail . '</div>';
                $output .= '<div class="hm_adventure_contentpart">';
                $output .= '<h5 class="hm_adventure_title">' . esc_html($adv_title) . '</h5>';
                $output .= '<div class="hm_localadv_link">';
                $output .= '<a href="#">' . esc_html__('Discover Now', 'elite-stay-helper') . '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none"><path d="M6.61598 2.54506C6.38164 2.77947 6.25 3.09735 6.25 3.42881C6.25 3.76027 6.38164 4.07815 6.61598 4.31256L12.8035 10.5001L6.61598 16.6876C6.38829 16.9233 6.26229 17.2391 6.26514 17.5668C6.26799 17.8946 6.39945 18.2081 6.63121 18.4398C6.86297 18.6716 7.17649 18.8031 7.50423 18.8059C7.83198 18.8088 8.14773 18.6828 8.38348 18.4551L15.4547 11.3838C15.6891 11.1494 15.8207 10.8315 15.8207 10.5001C15.8207 10.1686 15.6891 9.85072 15.4547 9.61631L8.38348 2.54506C8.14907 2.31072 7.83119 2.17908 7.49973 2.17908C7.16828 2.17908 6.85039 2.31072 6.61598 2.54506Z" fill="black" /></svg></a>';
                $output .= '</div>';
                $output .= '</div>';
                $output .= '</div>';
                $output .= '</div>';
            }
    
            $output .= '</div>';
            $output .= '</div>';
            $output .= '</div>';
    
            wp_reset_postdata();
        }
    
        $output .= '</div>';
    
        return $output;
    }
    
    public function eshelite_offers_display_callback() {
        $currentDate = gmdate('Y-m-d');
    
        $offers_args = array(
            'post_type'      => 'hm_offers',
            'posts_per_page' => -1, // Show all posts
            'meta_query'     => array(
                array(
                    'key'     => 'hm_offers_date',
                    'value'   => $currentDate,
                    'compare' => '>=', // Show posts with a date greater than or equal to current date
                    'type'    => 'DATE',
                ),
            ),
            'orderby'        => 'meta_value',
            'order'          => 'DESC', // Display posts in descending order of the "hm_offers_date" meta value
        );
    
        // Query all posts of the 'hm_offers' custom post type
        $offers_query = new \WP_Query($offers_args);
    
        $output = '';
    
        $output .= '<div class="hm_offers_main">';
        $output .= '<div class="hm_comobodiv">';
        $output .= '<div class="hm_offers_cols_head">';
        $output .= '<h2 class="wp-block-heading">' . esc_html__('Last Minutes Offer', 'elite-stay-helper') . '</h2>';
        $output .= '</div>';
    
        if ($offers_query->have_posts()) {
            $output .= '<div class="hm_offers_cols">';
            $output .= '<div class="hm_offers_timer">';
            $output .= '<div id="hm_timer">';
            $output .= '<div id="timer-container">';
            $output .= '<div class="hm_hours">';
            $output .= '<div id="hours">' . esc_html__('24', 'elite-stay-helper') . '</div>';
            $output .= '<span>' . esc_html__('Hours', 'elite-stay-helper') . '</span>';
            $output .= '</div>';
            $output .= '<div class="hm_colns">' . esc_html__(':', 'elite-stay-helper') . '</div>';
            $output .= '<div class="hm_hours">';
            $output .= '<div id="minutes">' . esc_html__('00', 'elite-stay-helper') . '</div>';
            $output .= '<span>' . esc_html__('Minutes', 'elite-stay-helper') . '</span>';
            $output .= '</div>';
            $output .= '<div class="hm_colns">' . esc_html__(':', 'elite-stay-helper') . '</div>';
            $output .= '<div class="hm_hours">';
            $output .= '<div id="seconds">' . esc_html__('00', 'elite-stay-helper') . '</div>';
            $output .= '<span>' . esc_html__('Seconds', 'elite-stay-helper') . '</span>';
            $output .= '</div>';
            $output .= '</div>';
            $output .= '</div>';
            $output .= '</div>';
    
            $output .= '</div>';
            $output .= '</div>';
    
            $output .= '<div class="hm_offers_imain">';
            $output .= '<div class="hm_offers_ul">';
    
            while ($offers_query->have_posts()) : $offers_query->the_post();
                $offer_id           = get_the_ID();
                $offers_tag_line    = sanitize_text_field(get_post_meta($offer_id, 'hm_offers_tagline', true));
                $offer_date         = get_post_meta($offer_id, 'hm_offers_date', true);
                $timestamp          = strtotime($offer_date);
    
                if ($timestamp !== false) {
                    // Translators: %s is replaced with the formatted date
                    $formattedDate = esc_html(date_i18n('jS F Y', $timestamp));
                }
                $thumbnail_id = get_post_thumbnail_id(get_the_ID());
                $image_url = wp_get_attachment_image_src($thumbnail_id, 'full');
                $output .= '<div class="hm_offers_li" data-id="' . esc_attr(get_the_ID()) . '">';
                $output .= '<div class="hm_offers_img_part">';
                $output .= '<div class="hm_offers_uimg">';
                if ($image_url) {
                    $output .= '<div class="hm_offers_img">';
                    $output .= '<img src="' . esc_url($image_url[0]) . '" alt="' . esc_attr(get_the_title()) . '">'; 
                    $output .= '</div>';
                }
                $output .= '</div>';
                $output .= '</div>';
                $output .= '<div class="hm_offers_content_part">';
                $output .= '<div class="hm_offers_content_title">';
                $output .= '<a href="#">'; // the_permalink()
                $output .= '<h5>' .esc_html(get_the_title()) . '</h5>';
                $output .= '</a>';
                $output .= '</div>';
                $output .= '<div class="hm_offers_content_self">';
                $output .= '<p>' . esc_html($offers_tag_line) . '</p>';
                $output .= '</div>';
                $output .= '<div class="hm_offers_booking_date">';
                $output .= '<h6>' . esc_html__('Booking Period', 'elite-stay-helper') . '</h6>';
                $output .= '<p>';
                // Translators: %s is replaced with the formatted date
                $output .= sprintf(esc_html__('Valid Till %s', 'elite-stay-helper'), esc_html($formattedDate));
                $output .= '</p>';
                $output .= '</div>';
                $output .= '</div>';
                $output .= '</div>';
            endwhile;
    
            wp_reset_postdata(); // Reset the query
    
            $output .= '</div>';
            $output .= '</div>';
        } else {
            $output .= '<div class="hm_offers_imain">';
            $output .= '<p class="hm_red_notice">' . esc_html__('No offers found!', 'elite-stay-helper') . '</p>';
            $output .= '</div>';
        }
    
        $output .= '</div>';
        $output .= '</div>';
    
        return $output;
    }
    
    public function eshelite_offers_rooms_callback() {
        $output = ''; // Initialize the output variable
    
        $roofers_args = array(
            'post_type'      => 'hm_rooms',
            'posts_per_page' => 3,
            'meta_query'     => array(
                array(
                    'key'     => 'hm_rooms_related_offers',
                    'value'   => '',
                    'compare' => '!='
                ),
            ),
            'post_status'    => 'publish',
        );
    
        $roofers_query = new \WP_Query($roofers_args);
        $has_offers = 'none'; // Flag to check if there are offers
        $valid_room_ids = array();
        $valid_offer_ids = array();
    
        if ($roofers_query->have_posts()) {
            while ($roofers_query->have_posts()) {
                $roofers_query->the_post();
                $related_offers = get_post_meta(get_the_ID(), 'hm_rooms_related_offers', true);
                $room_id = get_the_ID();
    
                if (!empty($related_offers)) {
                    foreach ($related_offers as $offer_id) {
                        $offer_date = get_post_meta($offer_id, 'hm_offers_date', true);
                        $timestamp = strtotime($offer_date);
    
                        if ($timestamp !== false && $timestamp >= strtotime('today')) {
                            $valid_room_ids[] = $room_id; // Store IDs of rooms with associated valid offers
                            $valid_offer_ids[] = $offer_id; // Store IDs of offers with valid dates from the future
                        }
                    }
                }
            }
        }
    
        if (!empty($valid_room_ids)) {
            $has_offers = 'block';
        }
    
        if ($has_offers == 'block') {
            $output .= '<div class="wp-block-group__inner-container">';
            $output .= '<h2 class="wp-block-heading has-text-align-center">' . esc_html__('Offers to Claim now!', 'elite-stay-helper') . '</h2>';
            $output .= '<div class="hm_roffers_main">';
            $output .= '<div class="hm_roffers_imain">';
            $output .= '<div class="hm_roffers_ul owl-carousel hm_roffers_owl" id="hm_roffers_owl_cstm">';
    
            while ($roofers_query->have_posts()) {
                $roofers_query->the_post();
                $mroom_id = get_the_ID();
                $mroom_image = get_the_post_thumbnail($mroom_id, 'full');
                $related_offers = get_post_meta($mroom_id, 'hm_rooms_related_offers', true);
    
                $output .= '<div class="hm_roffers_main_li">';
                $output .= '<div class="hm_roffers_rimg">' . $mroom_image . '</div>';
    
                if (!empty($related_offers)) {
                    $output .= '<div class="hm_offers_imain">';
                    $output .= '<div class="hm_offers_ul owl_offersinner_cls owl-carousel" id="hm_roffers_inner_ul">';
    
                    foreach ($related_offers as $offer_id) {
                        if (in_array($offer_id, $valid_offer_ids)) {
                            $moffer_image = esc_url(get_the_post_thumbnail_url($offer_id, 'full'));
                            $offer_title = esc_html(get_the_title($offer_id));
                            $offers_tag_line = esc_html(get_post_meta($offer_id, 'hm_offers_tagline', true));
                            $offer_date = esc_attr(get_post_meta($offer_id, 'hm_offers_date', true));
                            $timestamp = strtotime($offer_date);
                            $formattedDate = ($timestamp !== false) ? esc_html(gmdate('jS F Y', $timestamp)) : '';
    
                            $output .= '<div class="hm_offers_li" data-id="' . esc_attr($offer_id) . '">';
                            $output .= '<div class="hm_offers_img_part">';
                            $output .= '<div class="hm_offers_img">';
                            $output .= '<img src="' . $moffer_image . '" alt="' . esc_attr($offer_title) . '">';
                            $output .= '</div>';
                            $output .= '</div>';
                            $output .= '<div class="hm_offers_content_part">';
                            $output .= '<div class="hm_offers_content_title">';
                            $output .= '<a href="' . esc_url(get_the_permalink($mroom_id)) . '">';
                            $output .= '<h5>' . esc_html($offer_title) . '</h5>';
                            $output .= '</a>';
                            $output .= '</div>';
                            $output .= '<div class="hm_offers_content_self">';
                            $output .= '<p>' . esc_html($offers_tag_line) . '</p>';
                            $output .= '</div>';
                            $output .= '<div class="hm_offers_booking_date">';
                            $output .= '<h6>' . esc_html__('Booking Period', 'elite-stay-helper') . '</h6>';
                            $output .= '<p>';
                            $output .= sprintf(esc_html('Valid Till %s', 'elite-stay-helper'), $formattedDate);
                            $output .= '</p>';
                            $output .= '</div>';
                            $output .= '</div>';
                            $output .= '</div>';
                        }
                    }
    
                    $output .= '</div>';
                    $output .= '</div>';
                }
    
                $output .= '</div>';
            }
    
            $output .= '</div>';
            $output .= '</div>';
            $output .= '</div>';
        } else {
            $output .= '<style>.hm_roffers_main { display: none; }</style>';
        }
    
        wp_reset_postdata();
        
        return $output;
    }
    
    public function eshelite_contactus_form_callback() {
        $output = ''; // Initialize the output variable
    
        $loader_url = $this->main_dir_files . '/img/yellow_.gif';
    
        $output .= '<div class="hm_contactus_form">';
        $output .= '<form action="#" method="post" id="hm_contactpg_frm">';
        $output .= '<div class="hm_contactus_input">';
        $output .= '<label class="hm_contactus_label" for="name">' . esc_html__('Your Name:', 'elite-stay-helper') . '</label>';
        $output .= '<input type="text" id="name" name="name" required placeholder="' . esc_attr__('Your Name', 'elite-stay-helper') . '">';
        $output .= '</div>';
        $output .= '<div class="hm_contactus_input">';
        $output .= '<label class="hm_contactus_label" for="email">' . esc_html__('Your Email:', 'elite-stay-helper') . '</label>';
        $output .= '<input type="email" id="email" name="email" required placeholder="' . esc_attr__('Your Email', 'elite-stay-helper') . '">';
        $output .= '</div>';
        $output .= '<div class="hm_contactus_input">';
        $output .= '<label class="hm_contactus_label" for="Subject">' . esc_html__('Subject:', 'elite-stay-helper') . '</label>';
        $output .= '<input type="text" id="Subject" name="Subject" required placeholder="' . esc_attr__('Your Subject Here ...', 'elite-stay-helper') . '">';
        $output .= '</div>';
        $output .= '<div class="hm_contactus_input">';
        $output .= '<label class="hm_contactus_label" for="message">' . esc_html__('Your Message:', 'elite-stay-helper') . '</label>';
        $output .= '<textarea id="message" name="message" rows="4" required placeholder="' . esc_attr__('Type Your Message Here ...', 'elite-stay-helper') . '"></textarea>';
        $output .= '</div>';
        $output .= '<div class="hm_contactus_submit">';
        $output .= '<input type="hidden" class="hm-site-button" value="hmcontact_frm_frontsubmit" name="action">';
        $output .= wp_nonce_field('ajax-nonce', 'nonce', false, false); // Return nonce without echoing
        $output .= '<button type="submit" class="hm_global_btns hm_second_btns hm_contactus_btn">' . esc_html__('Submit', 'elite-stay-helper') . '</button>';
        $output .= '</div>';
        $output .= '</form>';
        $output .= '<div class="hm_contactus_loader">';
        $output .= '<div class="hm_loader_div">';
        $output .= '<img src="' . esc_url($loader_url) . '" alt="' . esc_attr__('Loader', 'elite-stay-helper') . '" class="hm_loader_img">';
        $output .= '</div>';
        $output .= '</div>';
        $output .= '<div class="hm_form_response"></div>';
        $output .= '</div>';
    
        return $output;
    }
    public function hm_map_shortcode() {
        $output = ''; // Initialize the output variable
    
        $googlemap_key = get_option('hm_site_gmap_key');
        $hm_long = get_option('hm_long');
        $hm_lat = get_option('hm_lat');
        $locationInput = get_option('locationInput');
    
        $output .= '<div class="hm_cmap_parent">';
    
        if ($googlemap_key && $hm_lat && $hm_long) {
            $output .= '<div id="hm_contact_map" class="hm_contact_us_map" style="height: 400px; width:100%;"></div>';
            $output .= '<script>
                function sinitMap() {
                    const map = new google.maps.Map(document.getElementById("hm_contact_map"), {
                        center: { lat: ' . esc_attr($hm_lat) . ', lng: ' . esc_attr($hm_long) . ' },
                        zoom: 10,
                    });
                    const infowindow = new google.maps.InfoWindow({
                        content: "<strong>' . esc_html($locationInput) . '</strong>",
                    });
                    const marker = new google.maps.Marker({
                        position: { lat: ' . esc_attr($hm_lat) . ', lng: ' . esc_attr($hm_long) . ' },
                        map: map,
                        title: "' . esc_html($locationInput) . '",
                    });
                    marker.addListener("click", () => {
                        infowindow.open(map, marker);
                    });
                }
            </script>';
            $output .= '<script src="https://maps.googleapis.com/maps/api/js?key=' . esc_attr($googlemap_key) . '&callback=sinitMap" async defer></script>';
        } else {
            if (is_user_logged_in()) {
                $current_user = wp_get_current_user();
                if (in_array('administrator', $current_user->roles)) {
                    $output .= '<p class="hm_red_notice">' . esc_html__('Please Enter Google Map Api key!', 'elite-stay-helper') . '</p>';
                }
            }
        }
    
        $output .= '</div>';
    
        return $output;
    }
    
    public function supload_image_from_url($image_url) {
        $upload_dir = wp_upload_dir();
        $file_info = wp_remote_get($image_url);
        
        if (!is_wp_error($file_info) && $file_info['response']['code'] === 200) {
            $file_data = $file_info['body'];
            $file_type = wp_check_filetype(basename($image_url), null);
            $file_name = sanitize_file_name(pathinfo($image_url, PATHINFO_FILENAME));
            
            $file_path = $upload_dir['path'] . '/' . $file_name . '.' . $file_type['ext'];
            // Use WordPress functions to save the image data
            $saved_file = wp_upload_bits($file_name . '.' . $file_type['ext'], null, $file_data);
            if (!$saved_file['error']) {
                $attachment = array(
                    'post_mime_type' => $file_type['type'],
                    'post_title' => $file_name,
                    'post_content' => '',
                    'post_status' => 'inherit',
                );
                // Insert the attachment into the WordPress media library
                $attachment_id = wp_insert_attachment($attachment, $saved_file['file']);
                // Generate attachment metadata
                require_once(ABSPATH . 'wp-admin/includes/image.php');
                $attach_data = wp_generate_attachment_metadata($attachment_id, $saved_file['file']);
                wp_update_attachment_metadata($attachment_id, $attach_data);
                return $attachment_id;
            }
        }
        return false;
    }
}
?>