(function($) {
    function openMediaLibrary() {
        var frame = wp.media({
            title: 'Select or Upload Media',
            button: {
                text: 'Use this media'
            },
            multiple: false // Set this to true for multiple selection
        });
        frame.on('select', function() {
            var attachment = frame.state().get('selection').first().toJSON();
            // You can use attachment data here, e.g., attachment.url for the selected image URL.
            $("#acurl").attr("src", attachment.url);
            $("#acid").val(attachment.id);
            $('#icpreview').html('<img src="' + attachment.url + '" alt="Selected Image" />');
        });
        frame.open();
    }

    function multipleopenMediaLibrary() {
        var frame = wp.media({
            title: 'Select or Upload Media',
            button: {
                text: 'Use this media'
            },
            multiple: true // Set this to true for multiple selection
        });
    
        frame.on('select', function() {
            var attachments = frame.state().get('selection').toJSON();
            var parentContainer = document.querySelector('.hm_rooms_upfront');
    
            var innerDiv = document.createElement('div');
            innerDiv.className = 'hm_blogs_upfront_iview';
    
            attachments.forEach(function(attachment, index) {
                var div = document.createElement('div');
                div.className = 'hm_img_idrwrap';
    
                var img = document.createElement('img');
                img.src = attachment.url;
                div.appendChild(img);
    
                var inputHidden = document.createElement('input');
                inputHidden.type = 'hidden';
                inputHidden.name = 'hm_room_old_images[]';
                inputHidden.value = attachment.id;
                div.appendChild(inputHidden);
    
                var removeButton = document.createElement('div');
                removeButton.className = 'img_remove img_clsicon';
                removeButton.textContent = 'X';
                removeButton.addEventListener('click', function() {
                    div.remove();
                });
                div.appendChild(removeButton);
    
                innerDiv.appendChild(div);
            });
    
            parentContainer.appendChild(innerDiv);
        });
    
        frame.open();
    }
    
    
    $(document).on('click', '.amini-image-upload-button', function(e) {
        e.preventDefault();
        openMediaLibrary();
    });

    $(document).on('click', '.samini-image-upload-button', function(e) {
        e.preventDefault();
        multipleopenMediaLibrary();
    });

    $(document).on('change', '#hm_blogs_images', function() {
        var remainingFiles = 3 - parseInt($('.hm_blogs_upfront_iview').length);
        var maxAllowed = remainingFiles;
        if (remainingFiles === 0) {
            alert('You can not upload more than three images');
            return false; // Stop further processing
        }
        var files = $(this)[0].files;
        var preview = $('#hm_blogs_image_preview');
        if (files.length > maxAllowed) {
            alert('Please select a maximum of ' + maxAllowed + ' images.');
            // Clear the file input to prevent further selection
            $(this).val('');
            return;
        }
        preview.html(''); // Clear any previous previews.
        for (var i = 0; i < files.length; i++) {
            var file = files[i];
            var reader = new FileReader();
            // Create a closure to capture the current value of i
            (function(index) {
                reader.onload = function(e) {
                    // Create a container div for each image and close button.
                    var mcont = $('<div class="img_cont"></div>');
                    var container = $('<div class="image-container-inner">');
                    // Create an image element for the preview.
                    var img = $('<img>').attr('src', e.target.result);
                    // Create a close button.
                    var closeButton = $('<span class="close-button">X</span>');
                    // Click event to remove the parent div on close button click.
                    closeButton.click(function() {
                        $(this).closest('.img_cont').remove();
                    });
                    // Append the image and close button to the container div.
                    container.append(img);
                    container.append(closeButton);
                    var hiddenField = $('<input>')
                        .attr('type', 'hidden')
                        .attr('name', 'hm_blob_img_' + (index + 1 + remainingFiles)) // Increment index by remainingFiles
                        .val(e.target.result);
                    mcont.append(hiddenField);
                    mcont.append(container);
                    // Append the container div to the preview section.
                    preview.append(mcont);
                };
            })(i);
            reader.readAsDataURL(file);
        }
    });
    
    $(document).on('click', '.close_blog', function(e) {
        $(this).parent().remove();
    });
    $(document).on('click', '.img_remove', function(e) {
        $(this).parent().parent().remove();
    });
    $(document).on('change', '#hm_rooms_images', function() {
        $('.hm_rooms_upfront_iview').html('');
        var files = $(this)[0].files;
        var preview = $('#hm_rooms_image_preview');
        preview.html(''); // Clear any previous previews.
        for (var i = 0; i < files.length; i++) {
            var file = files[i];
            var reader = new FileReader();
            // Create a closure to capture the current value of i
            (function(index) {
                reader.onload = function(e) {
                    // Create an image element for the preview.
                    var img = $('<img>').attr('src', e.target.result);
                    // Create a hidden input field with a unique name for each image.
                    var hiddenField = $('<input>')
                        .attr('type', 'hidden')
                        .attr('name', 'hm_roomsblob_img_' + (index + 1)) // Increment index by 1 for 1-based numbering
                        .val(e.target.result);
                    preview.append(img);
                    preview.append(hiddenField);
                };
            })(i);
            reader.readAsDataURL(file);
        }
    });
    function updateHiddenInput(ids) {
        $('#image_attachment_ids').empty(); // Clear previous input fields
        ids.forEach(function(id) {
            var input = $('<input>').attr({
                type: 'hidden',
                name: 'image_attachment_ids[]',
                value: id,
                class: 'hm_image_inps'
            });
            $('#image_attachment_ids').append(input);
        });
    }
    $(document).on('click', '.blogs-image-upload-button', function(e) {
        e.preventDefault();
        var attachmentIdsLength = $('input[name="image_attachment_ids[]"]').length;
        if (attachmentIdsLength >= 3) {
            alert('You can only upload a maximum of 3 images.');
            return;
        }
        var imageIds = $('.hm_image_inps').map(function() {
            return $(this).val();
        }).get();
        var existingImagesCount = imageIds.length;
        // Opening WordPress media uploader
        var frame = wp.media({
            title: 'Upload Images',
            multiple: true
        });
        // Handling the selection of images
        frame.on('select', function() {
            var attachments = frame.state().get('selection').toJSON();
            attachments.forEach(function(attachment) {
                if (imageIds.includes(attachment.id.toString())) {
                    alert('This image already exists.');
                    return;
                }
                if (existingImagesCount >= 3) {
                    alert('You have reached the maximum limit of 3 images.');
                    return;
                }
                // Displaying selected images in a container
                var imageContainer = $('#image-preview-container');
                // Remove existing images before adding a new one
                imageContainer.empty();
                var image = $('<div class="image-preview"></div>');
                var img = $('<img>').attr('src', attachment.url);
                var aid = $('<input type="hidden" name="image_attachment_ids[]">').val(attachment.id);
                var deleteBtn = $('<span class="delete-image">X</span>');
                deleteBtn.on('click', function() {
                    image.remove();
                    imageIds = imageIds.filter(id => id !== attachment.id.toString());
                    updateHiddenInput(imageIds);
                    existingImagesCount--;
                });
                img.appendTo(image);
                aid.appendTo(image);
                deleteBtn.appendTo(image);
                image.appendTo(imageContainer);
                imageIds.push(attachment.id.toString());
                updateHiddenInput(imageIds);
                existingImagesCount++;
            });
            if (imageIds.length >= 3) {
                alert('You have reached the maximum limit of 3 images.');
            }
        });
        // Opening the media uploader
        frame.open();
    });
    $(document).on('click', '#hm_blogs_image_preview .delete-image', function(e) {
        $(this).parent().remove();
    });
})(jQuery);