<?php

if ( ! defined( 'ABSPATH' ) ) exit;

$einvappmy_library = new EINVAPPMY_Library(EINVAPPMY_Helper::get_config());

$GLOBALS['einvappmy_library'] = $einvappmy_library;

if (!function_exists('show_subscription_warning')) {
    function show_subscription_warning($subscription_url = "") {
        global $einvappmy_library;

        if (empty($subscription_url)) {
            // get the subscription info
            $subscription_info_response = $einvappmy_library->getSubscriptionInfo();
            $subscription_url = $subscription_info_response['data']['subscription_payment_url'] ?? '';
        }

        // check if the subscription is active
        $is_subscription_active = $einvappmy_library->isSubscriptionActive();
        
        $html = '';
        $plugin_name = EINVAPPMY_Helper::get_config_value('plugin_name');

        if (!$is_subscription_active) {
            $html = '<div class="notice notice-warning notice-large">';
            $html .= '<p>';
            $html .= '<strong>🚀 Active Subscription Required</strong><br/>';
            $html .= 'To use <em>' . esc_html($plugin_name) . '</em>, please head over to our <a class="button button-small button-subscription" href="' . esc_url($subscription_url) . '" target="_blank">subscription page</a> to subscribe to our service.';
            $html .= '</p>';
            $html .= '</div>';
        }

        return $html;
    }
}