<?php if ( ! defined( 'ABSPATH' ) ) exit; ?>

<?php if (!empty($myinvois_token) && $is_subscription_active): ?>
    <div id="e-invoice-container">
        <?php if (!empty($is_date_added_same_month)): ?>
            <?php $dnone_class = $is_ui_display_checking ? '' : 'd-none'; ?>
            <div class="e-invoice-status <?php echo esc_attr($dnone_class); ?>" status="checking">
                <p>Checking if this has been requested before ..</p>
            </div>

            <?php $dnone_class = $is_ui_display_not_requested ? '' : 'd-none'; ?>
            <div class="e-invoice-status <?php echo esc_attr($dnone_class); ?>" status="not-requested">
                <p>
                    <?php esc_html_e( 'Use this to send Malaysia e-invoice to the customer if they requested for one and has no access to order info page.', 'einvoiceapp-malaysia' ); ?>
                    <br />
                    <?php esc_html_e( 'This will generate the e-invoice form link and you can then send it to the customer.', 'einvoiceapp-malaysia' ); ?>
                </p>

                <?php if (!empty($validation_warning_fields)) : ?>
                    <div class="alert alert-warning">
                        <p><strong><?php esc_html_e( 'The order is lacking these information:', 'einvoiceapp-malaysia' ); ?></strong></p>
                        <ol>
                            <?php foreach ($validation_warning_fields as $warning_field) : ?>
                                <li><?php echo esc_html($warning_field); ?></li>
                            <?php endforeach; ?>
                        </ol>
                        <p><?php esc_html_e( 'They are mandatory when requesting for e-invoice. Please make sure to prepare them when making the request.', 'einvoiceapp-malaysia' ); ?></p>
                    </div>
                <?php endif; ?>

                <div id="einvappmy-order-error" class="alert alert-error d-none"></div>

                <div style="margin-bottom: 10px;">
                    <p><?php esc_html_e('Select datetime for e-invocie issuance', 'einvoiceapp-malaysia'); ?></p>
                    <select name="create_date" id="input_create_date">
                        <option value="order_creation_date"><?php esc_html_e('Order Creation Datetime', 'einvoiceapp-malaysia'); ?></option>

                        <?php if ($is_order_paid): ?>
                            <option value="order_paid_date"><?php esc_html_e('Order Processing Datetime (Order is Paid)', 'einvoiceapp-malaysia'); ?></option>
                        <?php endif; ?>

                        <?php if ($is_order_completed): ?>
                            <option value="order_completed_date"><?php esc_html_e('Order Completed Datetime', 'einvoiceapp-malaysia'); ?></option>
                        <?php endif; ?>
                    </select>
                </div>

                <button type="button" class="btn button" onclick="myeinvoiceRequest()">Request</button>
            </div>

            <div class="e-invoice-status" status="requesting" style="display:none">
                <img src="<?php echo esc_url(EINVAPPMY_PLUGIN_ASSETS_URL . 'images/loading.gif'); ?>" class="loading2" />
            </div>

            <?php $dnone_class = $is_ui_display_error ? '' : 'd-none'; ?>
            <div class="e-invoice-status <?php echo esc_attr($dnone_class); ?>" status="error">
                <p><?php echo esc_html($error_message); ?></p>
            </div>

            <?php $dnone_class = $is_ui_display_success ? '' : 'd-none'; ?>
            <div class="e-invoice-status <?php echo esc_attr($dnone_class); ?>" status="request-success">
                <p>The e-invoice form link has been generated. Please send this link to the customer to fill in the remaining information to complete the e-invoice request.</p>

                <?php $invoice_url = $invoice_data['invoice_url'] ?? ''; ?>
                <div class="einvoice-link-wrapper">
                    <input
                        readonly
                        type="text"
                        name="einvoice_link"
                        class="einvoice-link-input"
                        width="400px"
                        style="width:400px;cursor:pointer;"
                        value="<?php echo esc_url($invoice_url); ?>"
                        title="<?php esc_attr_e( 'Click to open this link in a new tab', 'einvoiceapp-malaysia' ); ?>"
                    />
                    <button
                        type="button"
                        class="button button-small einvoice-link-copy"
                        title="<?php esc_attr_e( 'Copy link to clipboard', 'einvoiceapp-malaysia' ); ?>"
                    >
                        <span class="dashicons dashicons-clipboard"></span>
                    </button>
                </div>

                <p class="e-invoice-label">Status: <b class="label" style="background-color: <?php echo esc_attr($status_color_hex); ?>;"><?php echo esc_html($invoice_data['status_text'] ?? $status_text); ?></b></p>
                <?php if (!empty($invoice_data['pdf_url'])) : ?>
                    <a href="<?php echo esc_url($invoice_data['pdf_url']); ?>" target="_blank" class="button button-primary">Download PDF</a>
                <?php endif; ?>

                <?php //if (!empty($invoice_data['credit_note_status']) || !empty($invoice_data['debit_note_status']) || !empty($invoice_data['refund_note_status'])): ?>
                <?php if (isset($invoice_data['status']) && $invoice_data['status'] == 1): ?>
                    <div class="notes-section" style="margin-top: 20px;">
                        <div class="note-section credit-note" style="border: 1px solid #ddd; padding: 10px; margin-top: 10px; border-radius: 6px;">
                            <?php if (!empty($invoice_data['credit_note'])): ?>
                                <h5>Credit Note Status: <span class="label" style="background-color: <?php echo esc_attr($invoice_data['credit_note']['status_color_hex']); ?>;"><?php echo esc_html($invoice_data['credit_note']['status_text']); ?></span></h5>
                                [<a href="<?php echo esc_url($invoice_data['credit_note_url']); ?>" target="_blank">Manage Submission</a>]

                                <?php if ($invoice_data['credit_note']['status'] == 1 && $invoice_data['credit_note']['uuid']): ?>
                                    [<a href="<?php echo esc_url($invoice_data['credit_note_pdf_url']); ?>" target="_blank">Download PDF</a>]
                                <?php endif; ?>
                            <?php else: ?>
                                <h5>No credit Note issued for this invoice. <small>[<a onclick="if (confirm('Are you sure you want to submit a new Credit Note for this invoice?')) { myInvoisCreateDocument('credit_note', '<?php echo esc_attr($invoice_data['invoice_code']); ?>') }">Submit New Credit Note</a>]</small></h5>
                            <?php endif; ?>
                        </div>

                        <div class="note-section debit-note" style="border: 1px solid #ddd; padding: 10px; margin-top: 10px; border-radius: 6px;">
                            <?php if (!empty($invoice_data['debit_note'])): ?>
                                <h5>Debit Note Status: <span class="label" style="background-color: <?php echo esc_attr($invoice_data['debit_note']['status_color_hex']); ?>;"><?php echo esc_html($invoice_data['debit_note']['status_text']); ?></span></h5>
                                [<a href="<?php echo esc_url($invoice_data['debit_note_url']); ?>" target="_blank">Manage Submission</a>]

                                <?php if ($invoice_data['debit_note']['status'] == 1 && $invoice_data['debit_note']['uuid']): ?>
                                    [<a href="<?php echo esc_url($invoice_data['debit_note_pdf_url']); ?>" target="_blank">Download PDF</a>]
                                <?php endif; ?>
                            <?php else: ?>
                                <h5>No debit Note issued for this invoice. <small>[<a onclick="if (confirm('Are you sure you want to submit a new Debit Note for this invoice?')) { myInvoisCreateDocument('debit_note', '<?php echo esc_attr($invoice_data['invoice_code']); ?>') }">Submit New Debit Note</a>]</small></h5>
                            <?php endif; ?>
                        </div>

                        <div class="note-section refund-note" style="border: 1px solid #ddd; padding: 10px; margin-top: 10px; border-radius: 6px;">
                            <?php if (!empty($invoice_data['refund_note'])): ?>
                                <h5>Refund Note Status: <span class="label" style="background-color: <?php echo esc_attr($invoice_data['refund_note']['status_color_hex']); ?>;"><?php echo esc_html($invoice_data['refund_note']['status_text']); ?></span></h5>
                                [<a href="<?php echo esc_url($invoice_data['refund_note_url']); ?>" target="_blank">Manage Submission</a>]

                                <?php if ($invoice_data['refund_note']['status'] == 1 && $invoice_data['refund_note']['uuid']): ?>
                                    [<a href="<?php echo esc_url($invoice_data['refund_note_pdf_url']); ?>" target="_blank">Download PDF</a>]
                                <?php endif; ?>
                            <?php else: ?>
                                <h5>No refund Note issued for this invoice. <small>[<a onclick="if (confirm('Are you sure you want to submit a new Refund Note for this invoice?')) { myInvoisCreateDocument('refund_note', '<?php echo esc_attr($invoice_data['invoice_code']); ?>') }">Submit New Refund Note</a>]</small></h5>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <?php $dnone_class = $is_ui_display_expired ? '' : 'd-none'; ?>
            <div class="e-invoice-status <?php echo esc_attr($dnone_class); ?>" status="expired">
                <p>You can no longer request for Malaysia e-invoice for this order.</p>
            </div>
        <?php else: ?>
            <p>You can no longer request for Malaysia e-invoice for this order.</p>
        <?php endif; ?>
    </div>
<?php elseif (!$is_subscription_active): ?>
    <div id="e-invoice-container">
        <p>
            <?php esc_html_e('It seem like you have not yet subscribe to the service. Please subscribe to the service first before proceeding.', 'einvoiceapp-malaysia'); ?><br/>
            You may click on <a href="<?php echo esc_url($subscription_url); ?>" target="_blank" class="button button-small button-subscription">Subscribe Now</a> to subscribe to the service.
        </p>
    </div>
<?php else: ?>
    <div id="e-invoice-container">
        <p>
            <?php esc_html_e('Company Information is required, please make sure you have filled in the company information and save the settings first.', 'einvoiceapp-malaysia'); ?><br/>
            You may click on <a href="<?php echo esc_url(admin_url('admin.php?page=' . $config['page_name'])); ?>" target="_blank">HERE</a> to the E-Invoice Settings Page to fill in the company information.
        </p>
    </div>
<?php endif; ?>